/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.RaidDefender;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.RawMessages.RawMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class defend
implements cmd {
    static HashMap<UUID, ClaimedResidence> ownerJoinRequests = new HashMap();
    static HashMap<UUID, ClaimedResidence> joinRequests = new HashMap();

    @Override
    @CommandAnnotation(simple=true, priority=3100)
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length != 0 && args.length != 1) {
            return false;
        }
        if (!ConfigManager.RaidEnabled) {
            plugin.msg((CommandSender)player, lm.Raid_NotEnabled, new Object[0]);
            return true;
        }
        ClaimedResidence res = null;
        ResidencePlayer target = null;
        if (args.length == 1) {
            OfflinePlayer targetP = plugin.getOfflinePlayer(args[0]);
            if (targetP != null) {
                if (!targetP.isOnline()) {
                    plugin.msg((CommandSender)player, lm.Invalid_PlayerOffline, new Object[0]);
                    return true;
                }
                target = plugin.getPlayerManager().getResidencePlayer(targetP.getUniqueId());
            } else {
                res = plugin.getResidenceManager().getByName(args[0]);
            }
        } else {
            res = plugin.getResidenceManager().getByLoc(player.getLocation());
        }
        if (res == null) {
            ResidencePlayer owner = plugin.getPlayerManager().getResidencePlayer(player);
            res = owner.getCurrentlyRaidedResidence();
        }
        if (res == null) {
            plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return true;
        }
        ResidencePlayer resPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        if (resPlayer.getJoinedRaid() != null) {
            plugin.msg((CommandSender)player, lm.Raid_attack_alreadyInAnother, resPlayer.getJoinedRaid().getRes().getName());
            return true;
        }
        if (res.isOwner(player)) {
            if (target != null) {
                ClaimedResidence req = joinRequests.get(target.getUniqueId());
                if (req != null && req.equals(res)) {
                    plugin.msg((CommandSender)target.getPlayer(), lm.Raid_defend_Joined, res.getName());
                    for (Map.Entry<UUID, RaidDefender> one : res.getRaid().getDefenders().entrySet()) {
                        if (target.getUniqueId().equals(one.getKey())) continue;
                        plugin.msg((CommandSender)Bukkit.getPlayer((UUID)one.getKey()), lm.Raid_defend_JoinedDef, target.getPlayer().getDisplayName());
                    }
                    res.getRaid().addDefender(target);
                    joinRequests.remove(target.getUniqueId());
                    ownerJoinRequests.remove(target.getUniqueId());
                    return true;
                }
                ownerJoinRequests.put(target.getUniqueId(), res);
                RawMessage rm = new RawMessage();
                rm.addText(plugin.getLM().getMessage(lm.Raid_defend_Invitation, res.getName())).addHover(res.getName()).addCommand("res defend " + res.getName());
                rm.show(target.getPlayer());
                return true;
            }
            plugin.msg((CommandSender)player, lm.Raid_defend_noSelf, new Object[0]);
            return true;
        }
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(res.getOwnerUUID());
        if (!rPlayer.isOnline()) {
            plugin.msg((CommandSender)player, lm.Raid_defend_IsOffline, new Object[0]);
            return true;
        }
        if (!res.getRaid().isInPreRaid() && !res.getRaid().isUnderRaid()) {
            plugin.msg((CommandSender)player, lm.Raid_defend_notRaided, new Object[0]);
            return true;
        }
        if (res.getRaid().isUnderRaid() || res.getRaid().isInPreRaid()) {
            ClaimedResidence req = ownerJoinRequests.get(player.getUniqueId());
            if (req != null && req.equals(res)) {
                plugin.msg((CommandSender)player, lm.Raid_defend_Joined, res.getName());
                for (Map.Entry<UUID, RaidDefender> one : res.getRaid().getDefenders().entrySet()) {
                    if (player.getUniqueId().equals(one.getKey())) continue;
                    plugin.msg((CommandSender)Bukkit.getPlayer((UUID)one.getKey()), lm.Raid_defend_JoinedDef, player.getDisplayName());
                }
                res.getRaid().addDefender(player);
                joinRequests.remove(player.getUniqueId());
                ownerJoinRequests.remove(player.getUniqueId());
                return true;
            }
            joinRequests.put(player.getUniqueId(), res);
            RawMessage rm = new RawMessage();
            plugin.msg((CommandSender)player, lm.Raid_defend_Sent, res.getName());
            rm.addText(plugin.getLM().getMessage(lm.Raid_defend_Invitation, player.getDisplayName())).addHover(player.getName()).addCommand("res defend " + rPlayer.getPlayer().getName());
            rm.show(rPlayer.getPlayer());
            return true;
        }
        plugin.msg(player, "Cant join raid");
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Join raid defence on residence");
        c.get("Info", Arrays.asList("&eUsage: &6/res defend [resName] (playerName)"));
        LocaleManager.addTabCompleteMain(this, "[cresidence]%%[playername]", "[playername]");
    }
}

