/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.raid;

import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceRaidEndEvent;
import com.bekvon.bukkit.residence.event.ResidenceRaidPreStartEvent;
import com.bekvon.bukkit.residence.event.ResidenceRaidStartEvent;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.RaidAttacker;
import com.bekvon.bukkit.residence.raid.RaidDefender;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Teleporters.CMITeleporter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceRaid {
    private ClaimedResidence res;
    private Long startsAt = 0L;
    private Long endsAt = 0L;
    private Long immunityUntil = null;
    private HashMap<UUID, RaidAttacker> attackers = new HashMap();
    private HashMap<UUID, RaidDefender> defenders = new HashMap();
    private CMITask schedRaidEndId = null;
    private CMITask shedRaidStartId = null;
    private CMITask schedBossBarId = null;
    public static final String bossBarPreRaidIdent = "ResidencePreRaid";
    public static final String bossBarRaidIdent = "ResidenceRaid";

    public ResidenceRaid(ClaimedResidence res) {
        this.res = res;
    }

    public boolean onSameTeam(Player player1, Player player2) {
        return this.attackers.containsKey(player1.getUniqueId()) && this.attackers.containsKey(player2.getUniqueId()) || this.defenders.containsKey(player1.getUniqueId()) && this.defenders.containsKey(player2.getUniqueId());
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public Long getCooldownEnd() {
        return this.endsAt + (long)(ConfigManager.RaidCooldown * 1000);
    }

    public void setEndsAt(Long endsAt) {
        this.endsAt = endsAt;
    }

    public boolean isEnded() {
        return this.getEndsAt() < System.currentTimeMillis();
    }

    public ClaimedResidence getRes() {
        return this.res;
    }

    public HashMap<UUID, RaidDefender> getDefenders() {
        return this.defenders;
    }

    public void addDefender(Player defender) {
        this.addDefender(Residence.getInstance().getPlayerManager().getResidencePlayer(defender));
    }

    public void addDefender(ResidencePlayer defender) {
        this.attackers.remove(defender.getUniqueId());
        this.defenders.put(defender.getUniqueId(), new RaidDefender(defender));
        defender.setJoinedRaid(this);
    }

    public boolean isDefender(Player player) {
        return this.isDefender(player.getUniqueId());
    }

    public boolean isDefender(UUID uuid) {
        return this.defenders.containsKey(uuid);
    }

    public void removeDefender(Player defender) {
        this.removeDefender(Residence.getInstance().getPlayerManager().getResidencePlayer(defender));
    }

    public void removeDefender(ResidencePlayer defender) {
        this.defenders.remove(defender.getUniqueId());
        defender.setJoinedRaid(null);
    }

    public boolean isAttacker(Player player) {
        return this.isAttacker(player.getUniqueId());
    }

    public boolean isAttacker(UUID uuid) {
        return this.attackers.containsKey(uuid);
    }

    public HashMap<UUID, RaidAttacker> getAttackers() {
        return this.attackers;
    }

    public void clearAttackers() {
        for (Map.Entry<UUID, RaidAttacker> one : this.attackers.entrySet()) {
            one.getValue().getPlayer().setJoinedRaid(null);
        }
        this.attackers.clear();
    }

    public void clearDefenders() {
        for (Map.Entry<UUID, RaidDefender> one : this.defenders.entrySet()) {
            one.getValue().getPlayer().setJoinedRaid(null);
        }
        this.defenders.clear();
    }

    public void addAttacker(Player attacker) {
        this.addAttacker(Residence.getInstance().getPlayerManager().getResidencePlayer(attacker));
    }

    public void addAttacker(ResidencePlayer attacker) {
        this.defenders.remove(attacker.getUniqueId());
        this.attackers.put(attacker.getUniqueId(), new RaidAttacker(attacker));
        attacker.setJoinedRaid(this);
    }

    public void removeAttacker(Player attacker) {
        this.attackers.remove(attacker.getUniqueId());
        this.removeAttacker(Residence.getInstance().getPlayerManager().getResidencePlayer(attacker));
    }

    public void removeAttacker(ResidencePlayer attacker) {
        attacker.setJoinedRaid(null);
        this.attackers.remove(attacker.getUniqueId());
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(Long startsAt) {
        this.startsAt = startsAt;
    }

    public void showBossBar() {
        block5: {
            block4: {
                if (!this.isUnderRaid()) break block4;
                for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
                    ResidencePlayer rPlayer = entry.getValue().getPlayer();
                    if (!rPlayer.isOnline()) continue;
                    this.showBossbar(rPlayer, BarColor.BLUE, lm.Raid_EndsIn);
                }
                for (Map.Entry<UUID, Object> entry : this.getDefenders().entrySet()) {
                    ResidencePlayer rOwner = ((RaidDefender)entry.getValue()).getPlayer();
                    if (!rOwner.isOnline()) continue;
                    this.showBossbar(rOwner, BarColor.BLUE, lm.Raid_EndsIn);
                }
                break block5;
            }
            if (!this.isInPreRaid()) break block5;
            for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
                ResidencePlayer rPlayer = entry.getValue().getPlayer();
                if (!rPlayer.isOnline()) continue;
                this.showBossbar(rPlayer, BarColor.GREEN, lm.Raid_StartsIn);
            }
            for (Map.Entry<UUID, Object> entry : this.getDefenders().entrySet()) {
                ResidencePlayer rOwner = ((RaidDefender)entry.getValue()).getPlayer();
                if (!rOwner.isOnline()) continue;
                this.showBossbar(rOwner, BarColor.GREEN, lm.Raid_StartsIn);
            }
        }
    }

    private void showBossbar(ResidencePlayer rPlayer, BarColor color, final lm msg) {
        BossBarInfo barInfo = CMILib.getInstance().getBossBarManager().getBossBar(rPlayer.getPlayer(), this.isUnderRaid() ? bossBarRaidIdent : bossBarPreRaidIdent);
        if (barInfo == null) {
            barInfo = new BossBarInfo(rPlayer.getPlayer(), this.isUnderRaid() ? bossBarRaidIdent : bossBarPreRaidIdent){

                public void updateCycle() {
                    this.setTitleOfBar(Residence.getInstance().msg(msg, ResidenceRaid.this.getDefenders().size(), ResidenceRaid.this.getAttackers().size()));
                }
            };
            Double secLeft = (double)((this.isUnderRaid() ? this.getEndsAt() : this.getStartsAt()) - System.currentTimeMillis()) / 1000.0;
            barInfo.setKeepForTicks(Integer.valueOf(22));
            barInfo.setColor(color);
            barInfo.setTitleOfBar(Residence.getInstance().msg(msg, this.getDefenders().size(), this.getAttackers().size()));
            barInfo.setAdjustPerc(Double.valueOf(-(1.0 / secLeft)));
            barInfo.setPercentage(secLeft.doubleValue(), secLeft.doubleValue());
            barInfo.setStyle(BarStyle.SEGMENTED_20);
            barInfo.setAuto(Integer.valueOf(20));
            CMILib.getInstance().getBossBarManager().addBossBar(rPlayer.getPlayer(), barInfo);
        }
    }

    public void endRaid() {
        BossBarInfo barInfo;
        ResidencePlayer RPlayer;
        this.setEndsAt(System.currentTimeMillis());
        if (this.schedRaidEndId != null) {
            ResidenceRaidEndEvent residenceRaidEndEvent = new ResidenceRaidEndEvent(this.res);
            Bukkit.getPluginManager().callEvent((Event)residenceRaidEndEvent);
            this.schedRaidEndId.cancel();
            this.schedRaidEndId = null;
        }
        if (this.shedRaidStartId != null) {
            this.shedRaidStartId.cancel();
            this.schedRaidEndId = null;
        }
        if (this.schedBossBarId != null) {
            this.schedBossBarId.cancel();
            this.schedRaidEndId = null;
        }
        this.setStartsAt(0L);
        for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            Residence.getInstance().msg((CommandSender)player, lm.Raid_Ended, this.res.getName());
            Location outside = this.res.getOutsideFreeLoc(player.getLocation(), player, true);
            if (outside == null) continue;
            CMITeleporter.teleportAsync((Entity)player, (Location)outside);
        }
        for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
            RPlayer = entry.getValue().getPlayer();
            if (RPlayer == null) continue;
            RPlayer.setLastRaidAttackTimer(System.currentTimeMillis());
            barInfo = CMILib.getInstance().getBossBarManager().getBossBar(RPlayer.getPlayer(), bossBarRaidIdent);
            if (barInfo != null) {
                barInfo.cancelAutoScheduler();
                barInfo.remove();
                CMILib.getInstance().getBossBarManager().removeBossBar(RPlayer.getPlayer(), barInfo);
            }
            if ((barInfo = CMILib.getInstance().getBossBarManager().getBossBar(RPlayer.getPlayer(), bossBarPreRaidIdent)) == null) continue;
            barInfo.cancelAutoScheduler();
            barInfo.remove();
            CMILib.getInstance().getBossBarManager().removeBossBar(RPlayer.getPlayer(), barInfo);
        }
        for (Map.Entry<UUID, Object> entry : this.getDefenders().entrySet()) {
            RPlayer = ((RaidDefender)entry.getValue()).getPlayer();
            if (RPlayer == null) continue;
            barInfo = CMILib.getInstance().getBossBarManager().getBossBar(RPlayer.getPlayer(), bossBarRaidIdent);
            if (barInfo != null) {
                barInfo.cancelAutoScheduler();
                barInfo.remove();
                CMILib.getInstance().getBossBarManager().removeBossBar(RPlayer.getPlayer(), barInfo);
            }
            if ((barInfo = CMILib.getInstance().getBossBarManager().getBossBar(RPlayer.getPlayer(), bossBarPreRaidIdent)) == null) continue;
            barInfo.cancelAutoScheduler();
            barInfo.remove();
            CMILib.getInstance().getBossBarManager().removeBossBar(RPlayer.getPlayer(), barInfo);
        }
        this.res.getRPlayer().setLastRaidDefendTimer(System.currentTimeMillis());
        this.clearAttackers();
        this.clearDefenders();
    }

    public boolean isImmune() {
        return this.immunityUntil == null ? false : this.immunityUntil > System.currentTimeMillis();
    }

    public Long getPlayerImmunityUntil() {
        ResidencePlayer rplayer = this.res.getRPlayer();
        if (rplayer == null) {
            return 0L;
        }
        return rplayer.getLastRaidDefendTimer() == null ? 0L : rplayer.getLastRaidDefendTimer() + (long)ConfigManager.RaidPlayerCooldown * 1000L;
    }

    public boolean isPlayerImmune() {
        return this.getPlayerImmunityUntil() > System.currentTimeMillis();
    }

    public Long getImmunityUntil() {
        return this.immunityUntil;
    }

    public void setImmunityUntil(Long immunityUntil) {
        this.immunityUntil = immunityUntil != null && immunityUntil > System.currentTimeMillis() ? immunityUntil : null;
    }

    public boolean preStartRaid(Player attacker) {
        if (this.isUnderRaid() || this.isInPreRaid()) {
            return false;
        }
        if (this.getCooldownEnd() > System.currentTimeMillis()) {
            return false;
        }
        if (attacker != null) {
            this.addAttacker(attacker);
        }
        this.addDefender(this.res.getRPlayer().getPlayer());
        this.setStartsAt(System.currentTimeMillis() + (long)(ConfigManager.PreRaidTimer * 1000));
        this.setEndsAt(this.getStartsAt() + (long)(ConfigManager.RaidTimer * 1000));
        ResidenceRaidPreStartEvent start = new ResidenceRaidPreStartEvent(this.res, this.getAttackers());
        Bukkit.getPluginManager().callEvent((Event)start);
        if (start.isCancelled()) {
            return false;
        }
        if (attacker != null) {
            Residence.getInstance().getPlayerManager().getResidencePlayer(attacker).setLastRaidAttackTimer(System.currentTimeMillis());
        }
        this.res.getRPlayer().setLastRaidDefendTimer(System.currentTimeMillis());
        this.setImmunityUntil((long)ConfigManager.RaidCooldown * 1000L);
        return true;
    }

    public boolean startRaid() {
        if (!this.isUnderRaid() && !this.isInPreRaid()) {
            return false;
        }
        ResidenceRaidStartEvent start = new ResidenceRaidStartEvent(this.res, this.getAttackers());
        this.shedRaidStartId = CMIScheduler.runTaskLater(() -> {
            Bukkit.getPluginManager().callEvent((Event)start);
            if (start.isCancelled()) {
                start.getRes().getRaid().endRaid();
            }
        }, (long)((this.getStartsAt() - System.currentTimeMillis()) / 50L));
        this.schedBossBarId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (!this.isUnderRaid() && !this.isInPreRaid()) {
                this.schedBossBarId.cancel();
                return;
            }
            this.showBossBar();
        }, (long)(this.isUnderRaid() ? 20L : 0L), (long)20L);
        this.schedRaidEndId = CMIScheduler.runTaskLater(() -> this.endRaid(), (long)((this.getEndsAt() - System.currentTimeMillis()) / 50L));
        return true;
    }

    public boolean isUnderRaid() {
        return this.getEndsAt() > System.currentTimeMillis() && this.getStartsAt() < System.currentTimeMillis();
    }

    public boolean isRaidInitialized() {
        if (this.isUnderRaid() || this.isInPreRaid()) {
            return true;
        }
        if (this.res.getParent() != null) {
            return this.res.getParent().getRaid().isRaidInitialized();
        }
        return false;
    }

    public boolean isInPreRaid() {
        return this.getEndsAt() > System.currentTimeMillis() && this.getStartsAt() > System.currentTimeMillis();
    }

    public boolean canRaid() {
        return !this.isUnderRaid() && this.getCooldownEnd() < System.currentTimeMillis();
    }

    public boolean isUnderRaidCooldown() {
        return this.getCooldownEnd() > System.currentTimeMillis();
    }
}

