/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.limit.PermissiveSelectorLimits;
import com.sk89q.worldedit.regions.selector.limit.SelectorLimits;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WorldEdit7SelectionManager
extends SelectionManager {
    Set<CuboidArea> queue = new HashSet<CuboidArea>();
    CMITask task = null;

    public WorldEdit7SelectionManager(Server serv, Residence plugin) {
        super(serv, plugin);
    }

    @Override
    public boolean worldEdit(Player player) {
        block5: {
            WorldEditPlugin wep = (WorldEditPlugin)this.server.getPluginManager().getPlugin("WorldEdit");
            Region sel = null;
            try {
                World w = wep.getSession(player).getSelectionWorld();
                if (w != null) {
                    sel = wep.getSession(player).getSelection(w);
                }
                if (sel == null) break block5;
                try {
                    Location pos1 = new Location(player.getWorld(), (double)sel.getMinimumPoint().getX(), (double)sel.getMinimumPoint().getY(), (double)sel.getMinimumPoint().getZ());
                    Location pos2 = new Location(player.getWorld(), (double)sel.getMaximumPoint().getX(), (double)sel.getMaximumPoint().getY(), (double)sel.getMaximumPoint().getZ());
                    this.updateLocations(player, pos1, pos2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            catch (IncompleteRegionException e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean worldEditUpdate(Player player) {
        if (!this.hasPlacedBoth(player)) {
            return false;
        }
        if (!player.hasPermission("worldedit.selection.pos")) {
            return false;
        }
        World w = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        try {
            Location p1 = this.getPlayerLoc1(player);
            Location p2 = this.getPlayerLoc2(player);
            LocalSession session = this.plugin.getWorldEdit().getSession(player);
            RegionSelector selector = session.getRegionSelector(w);
            selector.selectPrimary(BlockVector3.at((int)p1.getBlockX(), (int)p1.getBlockY(), (int)p1.getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            selector.selectSecondary(BlockVector3.at((int)p2.getBlockX(), (int)p2.getBlockY(), (int)p2.getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            if (session.hasCUISupport()) {
                session.dispatchCUISelection((Actor)new BukkitPlayer(player));
            }
        }
        catch (Error | Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void placeLoc1(Player player, Location loc, boolean show2) {
        super.placeLoc1(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void placeLoc2(Player player, Location loc, boolean show2) {
        super.placeLoc2(player, loc, show2);
        this.worldEditUpdate(player);
    }

    @Override
    public void sky(Player player, boolean resadmin2) {
        super.sky(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void bedrock(Player player, boolean resadmin2) {
        super.bedrock(player, resadmin2);
        this.worldEditUpdate(player);
    }

    @Override
    public void modify(Player player, boolean shift, double amount) {
        super.modify(player, shift, amount);
        this.worldEditUpdate(player);
    }

    @Override
    public void selectChunk(Player player) {
        super.selectChunk(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void showSelectionInfo(Player player) {
        super.showSelectionInfo(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void regenerate(CuboidArea area2) {
        this.queue.add(area2);
        if (this.task == null) {
            this.task = CMIScheduler.runTaskLater(this::nextInQueue, (long)1L);
        }
    }

    private void nextInQueue() {
        block9: {
            if (this.queue.isEmpty()) {
                this.task = null;
                return;
            }
            Iterator<CuboidArea> iter = this.queue.iterator();
            CuboidArea area2 = iter.next();
            iter.remove();
            CuboidRegionSelector sellection = new CuboidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)area2.getWorld()));
            EditSession session = null;
            try {
                try {
                    sellection.selectPrimary(BlockVector3.at((int)area2.getLowVector().getBlockX(), (int)area2.getLowVector().getBlockY(), (int)area2.getLowVector().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
                    sellection.selectSecondary(BlockVector3.at((int)area2.getHighVector().getBlockX(), (int)area2.getHighVector().getBlockY(), (int)area2.getHighVector().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
                    CuboidRegion cuboid = sellection.getIncompleteRegion();
                    session = WorldEdit.getInstance().newEditSessionBuilder().world(cuboid.getWorld()).build();
                    cuboid.getWorld().regenerate((Region)cuboid, session);
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            if (session != null) {
                session.close();
            }
        }
        this.task = CMIScheduler.runTaskLater(this::nextInQueue, (long)20L);
    }
}

