/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WorldGuardInterface;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuardUtil
implements WorldGuardInterface {
    private Residence plugin;

    public WorldGuardUtil(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public ProtectedRegion getRegion(Player player, CuboidArea area2) {
        if (area2 == null) {
            return null;
        }
        if (this.plugin.getWorldGuard() == null) {
            return null;
        }
        if (this.plugin.getWorldEdit() == null) {
            return null;
        }
        Location loc1 = area2.getLowLocation();
        Location loc2 = area2.getHighLocation();
        String id = "icp__tempregion";
        try {
            BlockVector min = new BlockVector(loc1.getX(), loc1.getY(), loc1.getZ());
            BlockVector max = new BlockVector(loc2.getX(), loc2.getY(), loc2.getZ());
            ProtectedRegion region = (ProtectedRegion)ProtectedCuboidRegion.class.getConstructor(String.class, BlockVector.class, BlockVector.class).newInstance(id, min, max);
            Method methd = this.plugin.getWorldGuard().getClass().getMethod("getRegionManager", loc1.getWorld().getClass());
            RegionManager mgr = (RegionManager)methd.invoke((Object)this.plugin.getWorldGuard(), loc1.getWorld());
            ApplicableRegionSet regions = mgr.getApplicableRegions(region);
            for (ProtectedRegion one : regions.getRegions()) {
                if (PermissionManager.ResPerm.worldguard_$1.hasPermission((CommandSender)player, one.getId())) continue;
                return one;
            }
        }
        catch (Exception | IncompatibleClassChangeError throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getWorldGuard() == null) {
            return false;
        }
        ProtectedRegion Region2 = this.getRegion(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (Region2 == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_WorldGuardOverlap, Region2.getId());
        Location lowLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)Region2.getMinimumPoint().getBlockX(), (double)Region2.getMinimumPoint().getBlockY(), (double)Region2.getMinimumPoint().getBlockZ());
        Location highLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)Region2.getMaximumPoint().getBlockX(), (double)Region2.getMaximumPoint().getBlockY(), (double)Region2.getMaximumPoint().getBlockZ());
        Visualizer v = new Visualizer(player);
        v.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        v.setErrorAreas(new CuboidArea(lowLoc, highLoc));
        this.plugin.getSelectionManager().showBounds(player, v);
        return true;
    }
}

