/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.StuckInfo;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.GetTime;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Entities.CMIEntity;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.TitleMessages.CMITitleMessage;
import net.Zrips.CMILib.Util.CMIVersionChecker;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Teleporters.CMITeleporter;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class ResidencePlayerListener
implements Listener {
    protected Map<UUID, ClaimedResidence> currentRes;
    protected Map<UUID, Long> lastUpdate;
    protected Map<UUID, Location> lastOutsideLoc;
    protected Map<UUID, StuckInfo> stuckTeleportCounter;
    protected int minUpdateTime;
    protected boolean chatenabled;
    protected Set<UUID> playerToggleChat = new HashSet<UUID>();
    private Residence plugin;
    protected Map<UUID, Long> lastCheck = new HashMap<UUID, Long>();
    protected Map<UUID, Vector> lastLocation = new HashMap<UUID, Vector>();
    private Runnable locationChangeCheck = () -> {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Long time;
            Vector locfrom = this.lastLocation.getOrDefault(player.getUniqueId(), player.getLocation().toVector());
            Vector locto = player.getLocation().toVector();
            this.lastLocation.put(player.getUniqueId(), locto);
            if (locfrom.getBlockX() == locto.getBlockX() && locfrom.getBlockY() == locto.getBlockY() && locfrom.getBlockZ() == locto.getBlockZ() || (time = this.lastCheck.getOrDefault(player.getUniqueId(), 0L)) + 1000L > System.currentTimeMillis()) continue;
            this.lastCheck.put(player.getUniqueId(), System.currentTimeMillis());
            this.handleNewLocation(player, player.getLocation(), true);
        }
    };
    HashMap<UUID, Long> informar = new HashMap();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags;

    public ResidencePlayerListener(Residence plugin) {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.plugin = plugin;
        CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.locationChangeCheck, (long)20L, (long)300L);
    }

    public void reload() {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = this.plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = this.plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.lastCheck.clear();
        this.lastLocation.clear();
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        if (!Flags.jump3.isGlobalyEnabled() && !Flags.jump2.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isFlying()) {
            return;
        }
        if (event.getTo().getY() - event.getFrom().getY() != (double)0.42f) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(player.getLocation());
        if (Flags.jump2.isGlobalyEnabled() && perms.has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.3)));
        } else if (Flags.jump3.isGlobalyEnabled() && perms.has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.6)));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        if (!Flags.itempickup.isGlobalyEnabled()) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getItem().getLocation());
        if (res == null) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!res.getPermissions().playerHas(event.getPlayer(), Flags.itempickup, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_itempickup.hasPermission((CommandSender)event.getPlayer(), 10000L, new String[0])) {
            return;
        }
        event.setCancelled(true);
        event.getItem().setPickupDelay(this.plugin.getConfigManager().getItemPickUpDelay() * 20);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        if (!Flags.itemdrop.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getPlayer().getLocation());
        if (res == null) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!res.getPermissions().playerHas(event.getPlayer(), Flags.itemdrop, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_itemdrop.hasPermission((CommandSender)event.getPlayer(), 10000L, new String[0])) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerGlobalChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().isEmpty()) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        String format = event.getFormat();
        format = format.replace("%1$s", String.valueOf(honorific) + "%1$s");
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerChatGlobalLow(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    private void processNEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void processHEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void processHHEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    private void procEvent(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        String format = event.getFormat();
        if (!format.contains("{residence}")) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res == null ? "" : res.getTopParentName());
        if (honorific.equalsIgnoreCase(" ")) {
            honorific = "";
        }
        format = format.replace("{residence}", honorific);
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackup(ResidenceFlagChangeEvent event) {
        if (!event.getFlag().equalsIgnoreCase(Flags.backup.toString())) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getConfigManager().RestoreAfterRentEnds) {
            return;
        }
        if (!this.plugin.getConfigManager().SchematicsSaveOnFlagChange) {
            return;
        }
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        if (player != null && !PermissionManager.ResPerm.backup.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
        } else {
            this.plugin.getSchematicManager().save(event.getResidence());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackupRename(ResidenceRenameEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().rename(event.getResidence(), event.getNewResidenceName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().delete(event.getResidence());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFirstLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            ResidenceBlockListener.newPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!this.plugin.getConfigManager().isRentInformOnEnding()) {
            return;
        }
        Player player = event.getPlayer();
        CMIScheduler.runTaskLater(() -> {
            if (!player.isOnline()) {
                return;
            }
            List<String> list2 = this.plugin.getRentManager().getRentedLandsList(player.getName());
            if (list2.isEmpty()) {
                return;
            }
            for (String one : list2) {
                RentedLand rentedland = this.plugin.getRentManager().getRentedLand(one);
                if (rentedland == null || rentedland.AutoPay || rentedland.endTime - System.currentTimeMillis() >= (long)(this.plugin.getConfigManager().getRentInformBefore() * 60 * 24 * 7)) continue;
                this.plugin.msg((CommandSender)player, lm.Residence_EndingRent, one, GetTime.getTime(rentedland.endTime));
            }
        }, (long)((long)this.plugin.getConfigManager().getRentInformDelay() * 20L));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent event) {
        if (!Flags.hook.isGlobalyEnabled()) {
            return;
        }
        if (event == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getCaught() == null) {
            return;
        }
        if ((Utils.isArmorStandEntity(event.getCaught().getType()) || event.getCaught() instanceof Boat || event.getCaught() instanceof LivingEntity) && !this.plugin.isResAdminOn(player)) {
            FlagPermissions perm = this.plugin.getPermsByLoc(event.getCaught().getLocation());
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getCaught().getLocation());
            if (perm.has(Flags.hook, FlagPermissions.FlagCombo.OnlyFalse)) {
                event.setCancelled(true);
                if (res != null) {
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.hook, res.getName()});
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeDayNight(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.day.toString()) && !event.getFlag().equalsIgnoreCase(Flags.night.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerTime();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.day.toString())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerTime(6000L, false);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.night.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerTime(14000L, false);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeGlow(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.glow.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                if (!Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) || !event.getFlag().equalsIgnoreCase(Flags.glow.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (!event.getFlag().equalsIgnoreCase(Flags.glow.toString()) || !Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDeleteEvent(ResidenceDeleteEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ClaimedResidence res = event.getResidence();
        if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setWalkSpeed(0.2f);
            }
        }
        if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.resetPlayerWeather();
            }
        }
        if (event.getPlayer() != null && res.getPermissions().playerHas(event.getPlayer(), Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                this.fly(one, false);
            }
        }
        if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPermissionManager().removeFromCache(player);
        this.checkSpecialFlags(player, null, this.plugin.getResidenceManager().getByLoc(player.getLocation()));
        this.plugin.getPlayerManager().getResidencePlayer(player).onQuit();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.wspeed1.toString()) && !event.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(0.2f);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.wspeed1.toString())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
                    }
                    if (!event.getResidence().getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.wspeed2.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
                }
                if (!event.getResidence().getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.wspeed1.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceOwnerChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ClaimedResidence res = event.getResidence();
        if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setWalkSpeed(0.2f);
            }
        }
        if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.resetPlayerWeather();
            }
        }
        if (res.getPermissions().has(Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                this.fly(one, false);
            }
        }
        if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeJump(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.jump2.toString()) && !event.getFlag().equalsIgnoreCase(Flags.jump3.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: 
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.jump2.toString())) {
                    if (!event.getResidence().getPermissions().has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.jump3.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.jump3.toString()) || !event.getResidence().getPermissions().has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.jump2.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeSunRain(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.sun.toString()) && !event.getFlag().equalsIgnoreCase(Flags.rain.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerWeather();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.sun.toString())) {
                    for (Player player : event.getResidence().getPlayersInResidence()) {
                        player.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.rain.toString())) break;
                for (Player player : event.getResidence().getPlayersInResidence()) {
                    player.setPlayerWeather(WeatherType.DOWNFALL);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeFly(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.fly.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    this.fly(one, false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    this.fly(one, true);
                }
                break;
            }
        }
    }

    private boolean canUseCommand(String command2, List<String> whiteListed, List<String> blackListed) {
        String t;
        int white = 0;
        for (String oneWhite : whiteListed) {
            String t2 = oneWhite.toLowerCase();
            if (!command2.startsWith("/" + t2)) continue;
            if (t2.contains("_") && t2.split("_").length > white) {
                white = t2.split("_").length;
                continue;
            }
            if (white != 0) continue;
            white = 1;
        }
        int black = 0;
        for (String oneBlack : blackListed) {
            t = oneBlack.toLowerCase();
            if (!command2.startsWith("/" + t)) continue;
            if (command2.contains("_")) {
                black = t.split("_").length;
                break;
            }
            black = 1;
            break;
        }
        if (black == 0) {
            for (String oneBlack : blackListed) {
                t = oneBlack.toLowerCase();
                if (!t.equalsIgnoreCase("*")) continue;
                if (command2.contains("_")) {
                    black = command2.split("_").length;
                    break;
                }
                black = 1;
                break;
            }
        }
        return white != 0 && white >= black || black == 0;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (!Flags.command.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        FlagPermissions globalPerm = this.plugin.getWorldFlags().getPerms(player);
        boolean globalLimited = globalPerm.playerHas(player, Flags.command, FlagPermissions.FlagCombo.OnlyFalse);
        boolean areaLimited = perms.playerHas(player, Flags.command, FlagPermissions.FlagCombo.OnlyFalse);
        if (!globalLimited && !areaLimited) {
            return;
        }
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_command.hasPermission((CommandSender)player, 10000L, new String[0])) {
            return;
        }
        ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
        String msg = event.getMessage().replace(" ", "_").toLowerCase();
        if (res == null) {
            if (!globalLimited) {
                return;
            }
            if (this.canUseCommand(msg, globalPerm.getCMDWhiteList(), globalPerm.getCMDBlackList())) {
                return;
            }
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_BaseFlagDeny, new Object[]{Flags.command});
            return;
        }
        ArrayList<String> w = new ArrayList<String>(res.getCmdWhiteList());
        ArrayList<String> b = new ArrayList<String>(res.getCmdBlackList());
        if (!areaLimited) {
            w.clear();
            b.clear();
        }
        if (globalPerm.isInheritCMDLimits()) {
            w.addAll(globalPerm.getCMDWhiteList());
            b.removeAll(globalPerm.getCMDWhiteList());
            b.addAll(globalPerm.getCMDBlackList());
        }
        if (this.canUseCommand(msg, w, b)) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.command, res.getName()});
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !CMIMaterial.isSign((Material)block.getType())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = block.getLocation();
        Signs s = this.plugin.getSignUtil().getSigns().getResSign(loc);
        if (s == null) {
            return;
        }
        ClaimedResidence res = s.getResidence();
        boolean ForSale = res.isForSell();
        boolean ForRent = res.isForRent();
        String landName = res.getName();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (ForSale) {
                Bukkit.dispatchCommand((CommandSender)player, (String)("res market buy " + landName));
                return;
            }
            if (ForRent) {
                if (res.isRented() && player.isSneaking()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market release " + landName));
                } else {
                    boolean stage = true;
                    if (player.isSneaking()) {
                        stage = false;
                    }
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market rent " + landName + " " + stage));
                }
                return;
            }
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK && ForRent && res.isRented() && this.plugin.getRentManager().getRentingPlayer(res).equals(player.getName())) {
            this.plugin.getRentManager().payRent(player, res, false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (!CMIChatColor.stripColor((String)event.getLine(0)).equalsIgnoreCase(this.plugin.msg(lm.Sign_TopLine, new Object[0]))) {
            return;
        }
        Signs signInfo = new Signs();
        Location loc = sign.getLocation();
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = null;
        if (!event.getLine(1).equalsIgnoreCase("")) {
            String resname = event.getLine(1);
            if (!event.getLine(2).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(2);
            }
            if (!event.getLine(3).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(3);
            }
            if ((res = this.plugin.getResidenceManager().getByName(resname)) == null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return;
            }
        } else {
            res = this.plugin.getResidenceManager().getByLoc(loc);
        }
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (res.getSignsInResidence().size() >= this.plugin.getConfigManager().getSignsMaxPerResidence()) {
            lm.Sign_TooMany.sendMessage((CommandSender)player, new Object[0]);
            return;
        }
        ClaimedResidence residence = res;
        signInfo.setResidence(res);
        signInfo.setLocation(loc);
        this.plugin.getSignUtil().getSigns().addSign(signInfo);
        this.plugin.getSignUtil().saveSigns();
        CMIScheduler.runTaskLater(() -> this.plugin.getSignUtil().CheckSign(residence), (long)5L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignDestroy(BlockBreakEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!CMIMaterial.isSign((Material)block.getType())) {
            return;
        }
        Location loc = block.getLocation();
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        Signs s = this.plugin.getSignUtil().getSigns().getResSign(loc);
        if (s == null) {
            return;
        }
        this.plugin.getSignUtil().getSigns().removeSign(s);
        if (s.getResidence() != null) {
            s.getResidence().getSignsInResidence().remove(s);
        }
        this.plugin.getSignUtil().saveSigns();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String pname = event.getPlayer().getName();
        this.currentRes.remove(event.getPlayer().getUniqueId());
        this.lastUpdate.remove(event.getPlayer().getUniqueId());
        this.lastOutsideLoc.remove(event.getPlayer().getUniqueId());
        this.plugin.getChatManager().removeFromChannel(pname);
        this.plugin.getPlayerListener().removePlayerResidenceChat(event.getPlayer());
        this.plugin.addOfflinePlayerToChache((OfflinePlayer)event.getPlayer());
        this.plugin.getAutoSelectionManager().getList().remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        ClaimedResidence res;
        if (!Flags.nofly.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        if (!(!player.getAllowFlight() && !player.isFlying() || !perms.has(Flags.nofly, false) || this.plugin.isResAdminOn(player) || PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0]) || (res = this.plugin.getResidenceManager().getByLoc(player.getLocation())) != null && res.isOwner(player))) {
            Location lc = player.getLocation();
            Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
            location.setPitch(lc.getPitch());
            location.setYaw(lc.getYaw());
            int from = location.getBlockY();
            int maxH = location.getWorld().getHighestBlockAt(location).getLocation().getBlockY() + 3;
            if (location.getWorld().getEnvironment() == World.Environment.NETHER) {
                maxH = 100;
            }
            int i = 0;
            while (i < maxH) {
                location.setY((double)(from - i));
                Block block = location.getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block)) {
                    location.setY((double)(from - i + 1));
                    break;
                }
                if (location.getBlockY() <= 0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location.getWorld().getName()});
                    return;
                }
                ++i;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location.getWorld().getName()});
            player.closeInventory();
            CMITeleporter.teleportAsync((Entity)player, (Location)location);
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastUpdate.put(player.getUniqueId(), 0L);
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            this.plugin.turnResAdminOn(player);
        }
        this.handleNewLocation(player, player.getLocation(), true);
        this.plugin.getPlayerManager().playerJoin(player);
        if (PermissionManager.ResPerm.versioncheck.hasPermission((CommandSender)player)) {
            CMIVersionChecker.VersionCheck((Player)player, (int)11480, (PluginDescriptionFile)this.plugin.getDescription());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSpawn(PlayerRespawnEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getRespawnLocation().getWorld())) {
            return;
        }
        Location loc = event.getRespawnLocation();
        Boolean bed = event.isBedSpawn();
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (bed.booleanValue()) {
            loc = player.getWorld().getSpawnLocation();
        }
        if ((res = this.plugin.getResidenceManager().getByLoc(loc)) != null && res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            loc = res.getOutsideFreeLoc(loc, player, true);
        }
        this.plugin.msg((CommandSender)player, lm.General_NoSpawn, new Object[0]);
        if (loc != null) {
            event.setRespawnLocation(loc);
        }
    }

    private boolean isContainer(Material mat, Block block) {
        return FlagPermissions.getMaterialUseFlagList().containsKey(mat) && FlagPermissions.getMaterialUseFlagList().get(mat).equals((Object)Flags.container) || this.plugin.getConfigManager().getCustomContainers().contains(CMIMaterial.get((Block)block));
    }

    private boolean isCanUseEntity_RClickOnly(Material mat, Block block) {
        switch (mat.name()) {
            case "REDSTONE_COMPARATOR": 
            case "DIODE_BLOCK_OFF": 
            case "CRAFTING_TABLE": 
            case "DAYLIGHT_DETECTOR": 
            case "SUSPICIOUS_GRAVEL": 
            case "REDSTONE_COMPARATOR_OFF": 
            case "REDSTONE_COMPARATOR_ON": 
            case "SUSPICIOUS_SAND": 
            case "DIODE_BLOCK_ON": 
            case "ITEM_FRAME": 
            case "WORKBENCH": 
            case "COMPARATOR": 
            case "CAKE_BLOCK": 
            case "BED_BLOCK": 
            case "DAMAGED_ANVIL": 
            case "ANVIL": 
            case "DIODE": 
            case "REPEATER": 
            case "ENCHANTING_TABLE": 
            case "LECTERN": 
            case "DAYLIGHT_DETECTOR_INVERTED": 
            case "FLOWER_POT": 
            case "BREWING_STAND": 
            case "ENCHANTMENT_TABLE": 
            case "COMMAND": 
            case "CHIPPED_ANVIL": 
            case "BEACON": {
                return true;
            }
        }
        CMIMaterial cmat = CMIMaterial.get((Material)mat);
        if (cmat != null) {
            if (cmat.isPotted()) {
                return true;
            }
            if (cmat.isCake()) {
                return true;
            }
            if (cmat.isCandle()) {
                return true;
            }
            if (cmat.isCandleCake()) {
                return true;
            }
            if (cmat.equals((Object)CMIMaterial.CAMPFIRE) || cmat.equals((Object)CMIMaterial.SOUL_CAMPFIRE)) {
                return true;
            }
        }
        return this.plugin.getConfigManager().getCustomRightClick().contains(CMIMaterial.get((Block)block));
    }

    public static boolean isCanUseEntity_BothClick(Material mat, Block block) {
        CMIMaterial m = CMIMaterial.get((Material)mat);
        if (m.isDoor()) {
            return true;
        }
        if (m.isButton()) {
            return true;
        }
        if (m.isGate()) {
            return true;
        }
        if (m.isTrapDoor()) {
            return true;
        }
        if (m.isBed()) {
            return true;
        }
        switch (m) {
            case DRAGON_EGG: 
            case LEVER: 
            case NOTE_BLOCK: 
            case PISTON: 
            case STICKY_PISTON: {
                return true;
            }
        }
        return Residence.getInstance().getConfigManager().getCustomBothClick().contains(CMIMaterial.get((Block)block));
    }

    public static boolean isEmptyBlock(Block block) {
        CMIMaterial cb = CMIMaterial.get((Block)block);
        switch (cb) {
            case NONE: 
            case COBWEB: 
            case ITEM_FRAME: 
            case PAINTING: 
            case STRING: 
            case TRIPWIRE: 
            case TRIPWIRE_HOOK: 
            case VINE: 
            case WALL_SIGN: 
            case GLOW_ITEM_FRAME: {
                return true;
            }
        }
        if (cb.isSapling()) {
            return true;
        }
        if (cb.isAir()) {
            return true;
        }
        return cb.isButton();
    }

    private boolean isCanUseEntity(Material mat, Block block) {
        return ResidencePlayerListener.isCanUseEntity_BothClick(mat, block) || this.isCanUseEntity_RClickOnly(mat, block);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerEnderCrystalInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() != Material.BEDROCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack iih = null;
        try {
            iih = event.getHand() == EquipmentSlot.HAND ? CMIItemStack.getItemInMainHand((Player)player) : CMIItemStack.getItemInOffHand((Player)player);
        }
        catch (Throwable e) {
            iih = CMIItemStack.getItemInMainHand((Player)player);
        }
        if (iih == null) {
            return;
        }
        if (!iih.getType().toString().equals("END_CRYSTAL")) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasplace = perms.playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true));
        if (hasplace) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFireInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block relativeBlock = block.getRelative(event.getBlockFace());
        if (relativeBlock == null) {
            return;
        }
        if (relativeBlock.getType() != Material.FIRE) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasplace = perms.playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true));
        if (hasplace) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlatePress(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        CMIMaterial mat = CMIMaterial.get((Block)block);
        if (!this.plugin.isResAdminOn(player)) {
            boolean hasuse = perms.playerHas(player, Flags.use, true);
            boolean haspressure = perms.playerHas(player, Flags.pressure, hasuse);
            if (!((hasuse || haspressure) && haspressure || !mat.isPlate() || PermissionManager.ResPerm.bypass_use.hasPermission((CommandSender)player, 10000L, new String[0]))) {
                event.setCancelled(true);
            }
        }
        if (!(perms.playerHas(player, Flags.trample, perms.playerHas(player, Flags.build, true)) || mat != CMIMaterial.FARMLAND && mat != CMIMaterial.SOUL_SAND)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSelection(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        CMIMaterial heldItem = CMIMaterial.get((ItemStack)player.getItemInHand());
        if (heldItem != this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (this.plugin.getWorldEditTool() == this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            event.setCancelled(true);
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        boolean resadmin2 = this.plugin.isResAdminOn(player);
        if (PermissionManager.ResPerm.select.hasPermission((CommandSender)player) || PermissionManager.ResPerm.create.hasPermission((CommandSender)player) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || group.canCreateResidences() && !PermissionManager.ResPerm.create.hasSetPermission((CommandSender)player, new String[0]) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || resadmin2) {
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc1(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_PrimaryPoint, this.plugin.msg(lm.General_CoordsTop, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && Utils.isMainHand(event)) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc2(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_SecondaryPoint, this.plugin.msg(lm.General_CoordsBottom, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            }
            if (this.plugin.getSelectionManager().hasPlacedBoth(player)) {
                this.plugin.getSelectionManager().showSelectionInfoInActionBar(player);
                this.plugin.getSelectionManager().updateLocations(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInfoCheck(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        CMIMaterial heldItem = CMIMaterial.get((ItemStack)item);
        if (heldItem != this.plugin.getConfigManager().getInfoTool()) {
            return;
        }
        if (this.isContainer(block.getType(), block)) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res != null) {
            this.plugin.getResidenceManager().printAreaInfo(res.getName(), (CommandSender)player, false);
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_NoResHere, new Object[0]);
        }
        event.setCancelled(true);
    }

    private static boolean placingMinecart(Block block, ItemStack item) {
        return block != null && block.getType().name().contains("RAIL") && item != null && item.getType().name().contains("MINECART");
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerharvest(PlayerInteractEvent event) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_16_R1)) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        try {
            if (event.getHand() != EquipmentSlot.HAND && event.getHand() != EquipmentSlot.OFF_HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res != null && res.isOwner(player)) {
            return;
        }
        CMIMaterial mat = CMIMaterial.get((Block)block);
        if (!(mat.equals((Object)CMIMaterial.SWEET_BERRY_BUSH) || mat.equals((Object)CMIMaterial.CAVE_VINES) || mat.equals((Object)CMIMaterial.CAVE_VINES_PLANT))) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        if (!perms.playerHas(player, Flags.harvest, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.harvest});
            event.setCancelled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        block31: {
            block32: {
                block35: {
                    block34: {
                        block33: {
                            if (event.getPlayer() == null) {
                                return;
                            }
                            if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
                                return;
                            }
                            player = event.getPlayer();
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            iih = event.getItem();
                            heldItem = CMIMaterial.get((ItemStack)iih);
                            mat = block.getType();
                            if (!(event.getAction() == Action.PHYSICAL || (this.isContainer(mat, block) || this.isCanUseEntity_RClickOnly(mat, block)) && event.getAction() == Action.RIGHT_CLICK_BLOCK || ResidencePlayerListener.isCanUseEntity_BothClick(mat, block) || heldItem.equals((Object)this.plugin.getConfigManager().getSelectionTool()) || heldItem.equals((Object)this.plugin.getConfigManager().getInfoTool()) || heldItem.isDye() || heldItem.equals((Object)CMIMaterial.GLOW_INK_SAC) || heldItem.equals((Object)CMIMaterial.ARMOR_STAND) || heldItem.isBoat() || ResidencePlayerListener.placingMinecart(block, iih))) {
                                return;
                            }
                            if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                                return;
                            }
                            resadmin = this.plugin.isResAdminOn(player);
                            if (resadmin) {
                                return;
                            }
                            if (!heldItem.isNone() && heldItem.isValidItem() && !this.plugin.getItemManager().isAllowed(heldItem.getMaterial(), this.plugin.getPlayerManager().getResidencePlayer(player).getGroup(), player.getWorld().getName())) {
                                this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
                                event.setCancelled(true);
                                return;
                            }
                            blockM = CMIMaterial.get((Block)block);
                            perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
                            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                                btype = CMIMaterial.get((Block)block);
                                if ((heldItem.isDye() || heldItem.equals((Object)CMIMaterial.GLOW_INK_SAC)) && (heldItem.equals((Object)CMIMaterial.BONE_MEAL) && (btype == CMIMaterial.GRASS_BLOCK || btype == CMIMaterial.GRASS || btype.isSapling()) || heldItem == CMIMaterial.COCOA_BEANS && blockM == CMIMaterial.JUNGLE_WOOD || btype == CMIMaterial.MOSS_BLOCK || btype == CMIMaterial.BIG_DRIPLEAF_STEM || btype == CMIMaterial.BIG_DRIPLEAF || btype == CMIMaterial.SMALL_DRIPLEAF) && !(tperms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                    event.setCancelled(true);
                                    return;
                                }
                                if ((heldItem.equals((Object)CMIMaterial.ARMOR_STAND) || heldItem.isBoat()) && !(tperms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                    event.setCancelled(true);
                                    return;
                                }
                                if (ResidencePlayerListener.placingMinecart(block, iih) && !perms.playerHas(player, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                    event.setCancelled(true);
                                    return;
                                }
                                if (btype.isSign() && !perms.playerHas(player, Flags.use, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
                                    event.setCancelled(true);
                                    return;
                                }
                                if (heldItem.equals((Object)CMIMaterial.BRUSH) && (res = this.plugin.getResidenceManager().getByLoc(block.getLocation())) != null && !res.getPermissions().playerHas(player, Flags.brush, FlagPermissions.FlagCombo.OnlyTrue)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.brush});
                                    event.setCancelled(true);
                                    return;
                                }
                            }
                            if (!this.isContainer(mat, block) && !this.isCanUseEntity(mat, block)) break block31;
                            hasuse = perms.playerHas(player, Flags.use, true);
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res != null && res.getRaid().isUnderRaid() && res.getRaid().isDefender(player) && !ConfigManager.RaidDefenderContainerUsage && (result = FlagPermissions.getMaterialUseFlagList().get(mat)) != null && result.equals((Object)Flags.container)) {
                                event.setCancelled(true);
                                this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
                                return;
                            }
                            if (res != null && res.isOwner(player) || (result = FlagPermissions.getMaterialUseFlagList().get(mat)) == null || perms.playerHas(player, result, hasuse)) break block32;
                            if (!hasuse && !result.equals((Object)Flags.container)) break block33;
                            if (res == null || !res.getRaid().isUnderRaid() || !res.getRaid().isAttacker(player)) {
                                if (!PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0])) {
                                    event.setCancelled(true);
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                                }
                                return;
                            }
                            break block32;
                        }
                        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) break block34;
                        if (res != null && res.getRaid().isUnderRaid() && res.getRaid().isAttacker(player)) break block32;
                        switch (ResidencePlayerListener.$SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags()[result.ordinal()]) {
                            case 39: {
                                if (!PermissionManager.ResPerm.bypass_door.hasPermission((CommandSender)player, 10000L, new String[0])) ** GOTO lbl71
                                break block32;
                            }
                            case 17: {
                                if (PermissionManager.ResPerm.bypass_button.hasPermission((CommandSender)player, 10000L, new String[0])) break block32;
                            }
lbl71:
                            // 3 sources

                            default: {
                                event.setCancelled(true);
                                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                                return;
                            }
                            {
                                break block32;
                            }
                        }
                    }
                    if (!ResidencePlayerListener.isCanUseEntity_BothClick(mat, block)) break block35;
                    if (res != null && res.getRaid().isUnderRaid() && res.getRaid().isAttacker(player)) break block32;
                    event.setCancelled(true);
                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                }
                return;
            }
            if (!(!this.plugin.getConfigManager().getCustomContainers().contains(blockM) || perms.playerHas(player, Flags.container, hasuse) && PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]))) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
                return;
            }
            if (this.plugin.getConfigManager().getCustomBothClick().contains(blockM) && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
                return;
            }
            if (this.plugin.getConfigManager().getCustomRightClick().contains(blockM) && event.getAction() == Action.RIGHT_CLICK_BLOCK && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTradeEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.VILLAGER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res != null && res.getPermissions().playerHas(player, Flags.trade, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.trade, res.getName()});
            event.setCancelled(true);
        }
    }

    private static boolean canRide(EntityType type) {
        switch (type.name().toLowerCase()) {
            case "donkey": 
            case "pig": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    private static boolean canHaveContainer(EntityType type) {
        switch (type.name().toLowerCase()) {
            case "donkey": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithHorse(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!ResidencePlayerListener.canHaveContainer(ent.getType())) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        boolean hasContainerBypass = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!hasContainerBypass && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse) && player.isSneaking()) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithRidable(PlayerInteractEntityEvent event) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!ResidencePlayerListener.canRide(ent.getType())) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.TrueOrNone)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecartStorage(PlayerInteractEntityEvent event) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART_CHEST && ent.getType() != EntityType.MINECART_HOPPER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        boolean hasContainerBypass = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!hasContainerBypass && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecart(PlayerInteractEntityEvent event) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART && ent.getType() != EntityType.BOAT) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDyeSheep(PlayerInteractEntityEvent event) {
        if (!Flags.dye.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.SHEEP) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.dye, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack iih = Utils.itemInMainHand(player);
            ItemStack iiho = CMILib.getInstance().getReflectionManager().getItemInOffHand(player);
            if (iih == null && iiho == null) {
                return;
            }
            if (iih != null && !CMIMaterial.isDye((Material)iih.getType()) && iiho != null && !CMIMaterial.isDye((Material)iiho.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.dye, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        if (!Flags.shear.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getEntity();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.shear, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack iih = Utils.itemInMainHand(player);
            ItemStack iiho = CMILib.getInstance().getReflectionManager().getItemInOffHand(player);
            if (iih == null && iiho == null) {
                return;
            }
            if (iih != null && !CMIMaterial.SHEARS.equals(iih.getType()) && iiho != null && !CMIMaterial.SHEARS.equals(iiho.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.shear, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractAtArmoStand(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (Residence.getInstance().isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        ItemStack item = CMIItemStack.getItemInMainHand((Player)player);
        try {
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                item = CMIItemStack.getItemInOffHand((Player)player);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!CMIMaterial.get((ItemStack)item).equals((Object)CMIMaterial.NAME_TAG)) {
            return;
        }
        FlagPermissions perms = Residence.getInstance().getPermsByLocForPlayer(ent.getLocation(), player);
        if (perms.playerHas(player, Flags.nametag, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.nametag});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemFrameInteract(PlayerInteractEntityEvent event) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!CMIEntity.isItemFrame((Entity)ent)) {
            return;
        }
        if (!(ent instanceof Hanging)) {
            return;
        }
        Material heldItem = Utils.itemInMainHand(player).getType();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(ent.getLocation(), player);
        String world = player.getWorld().getName();
        ResidencePlayer resPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup();
        if (!this.plugin.getItemManager().isAllowed(heldItem, group, world)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        boolean hasContainerBypass = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!hasContainerBypass && !perms.playerHas(player, Flags.container, perms.playerHas(player, Flags.use, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        FlagPermissions perms;
        ClaimedResidence res;
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getBlockClicked().getLocation().clone();
        if (Version.isCurrentHigher((Version)Version.v1_12_R1)) {
            try {
                loc.add(event.getBlockFace().getDirection());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((res = this.plugin.getResidenceManager().getByLoc(loc)) != null) {
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
            Material mat = event.getBucket();
            if (res.getPermissions().playerHas(player, Flags.build, FlagPermissions.FlagCombo.OnlyFalse) && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && (mat == Material.LAVA_BUCKET || mat == Material.WATER_BUCKET)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms = this.plugin.getPermsByLocForPlayer(loc, player)).playerHas(player, Flags.build, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
            event.setCancelled(true);
            return;
        }
        Material mat = event.getBucket();
        int level = this.plugin.getConfigManager().getPlaceLevel();
        if (res == null && this.plugin.getConfigManager().isNoLavaPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.LAVA_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceLava, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceLava, level);
            }
            event.setCancelled(true);
            return;
        }
        if (res == null && this.plugin.getConfigManager().isNoWaterPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.WATER_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceWater, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceWater, level);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getBlockClicked().getLocation());
        if (res != null && this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
            this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getBlockClicked().getLocation(), player);
        boolean hasdestroy = perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true));
        if (!hasdestroy) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = event.getTo();
        this.handleNewLocation(player, loc, false);
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            if (res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !res.isOwner(player) && !PermissionManager.ResPerm.bypass_tp.hasPermission((CommandSender)player, 10000L, new String[0]) && !PermissionManager.ResPerm.admin_move.hasPermission((CommandSender)player, 10000L, new String[0])) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, res.getName());
                return;
            }
        } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && (res.getPermissions().playerHas(player, Flags.enderpearl, FlagPermissions.FlagCombo.OnlyFalse) || res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.enderpearl, res.getName()});
            return;
        }
        if ((event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) && this.plugin.getConfigManager().isBlockAnyTeleportation() && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.General_TeleportDeny, res.getName());
            return;
        }
        if (Utils.isChorusTeleport(event.getCause()) && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.chorustp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chorustp, res.getName()});
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = player.getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (res.getPermissions().has(Flags.keepinv, false)) {
            event.setKeepInventory(true);
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_14_R1)) {
                event.getDrops().clear();
            }
        }
        if (res.getPermissions().has(Flags.keepexp, false)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
        if (res.getPermissions().has(Flags.respawn, false) && Version.isSpigot()) {
            CMIScheduler.runTaskLater(() -> {
                try {
                    event.getEntity().spigot().respawn();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, (long)20L);
        }
    }

    public static Location getSafeLocation(Location loc) {
        Block block;
        int curY = loc.getBlockY();
        int i = 0;
        while (i <= curY) {
            block = loc.clone().add(0.0, (double)(-i), 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return loc.clone().add(0.0, (double)(-i + 1), 0.0);
            }
            ++i;
        }
        i = 0;
        while (i <= loc.getWorld().getMaxHeight() - curY) {
            block = loc.clone().add(0.0, (double)i, 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return loc.clone().add(0.0, (double)(i + 1), 0.0);
            }
            ++i;
        }
        return null;
    }

    private void fly(Player player, boolean state) {
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_fly.hasPermission((CommandSender)player, 10000L, new String[0])) {
            return;
        }
        if (!state) {
            if (player.hasPermission("cmi.command.fly") || player.hasPermission("essentials.fly")) {
                return;
            }
            boolean land = player.isFlying();
            player.setFlying(false);
            player.setAllowFlight(false);
            if (land) {
                Location loc = ResidencePlayerListener.getSafeLocation(player.getLocation());
                if (loc == null && (loc = this.plugin.getConfigManager().getFlyLandLocation()) == null) {
                    loc = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
                }
                if (loc != null) {
                    player.closeInventory();
                    CMITeleporter.teleportAsync((Entity)player, (Location)loc);
                }
            }
            player.setFlying(false);
            player.setAllowFlight(false);
        } else {
            player.setAllowFlight(true);
            CMIScheduler.runAtEntityLater((Entity)player, () -> {
                ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(player.getLocation());
                if (res != null && res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && player.isOnline()) {
                    player.setAllowFlight(true);
                }
                if (res == null || !res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && player.isOnline()) {
                    if (player.hasPermission("cmi.command.fly") || player.hasPermission("essentials.fly")) {
                        return;
                    }
                    player.setFlying(false);
                    player.setAllowFlight(false);
                }
            }, (long)20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChange(ResidenceChangedEvent event) {
        ClaimedResidence newRes = event.getTo();
        ClaimedResidence oldRes = event.getFrom();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        this.checkSpecialFlags(player, newRes, oldRes);
    }

    private void checkSpecialFlags(Player player, ClaimedResidence newRes, ClaimedResidence oldRes) {
        if (newRes == null && oldRes != null) {
            if (Flags.night.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) || Flags.day.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (Flags.wspeed1.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || Flags.wspeed2.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (Flags.sun.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || Flags.rain.isGlobalyEnabled() && oldRes.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (Flags.fly.isGlobalyEnabled() && oldRes.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, false);
            }
            if (Flags.glow.isGlobalyEnabled() && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) && oldRes.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(false);
            }
            return;
        }
        if (newRes != null && oldRes != null && !newRes.equals(oldRes)) {
            if (Flags.glow.isGlobalyEnabled() && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
                if (newRes.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(true);
                } else if (oldRes.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(false);
                }
            }
            if (Flags.fly.isGlobalyEnabled()) {
                if (newRes.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                    this.fly(player, true);
                } else if (oldRes.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                    this.fly(player, false);
                }
            }
            boolean updated = false;
            if (Flags.day.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                    updated = true;
                    player.setPlayerTime(6000L, false);
                } else if (oldRes.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.resetPlayerTime();
                }
            }
            if (Flags.night.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setPlayerTime(14000L, false);
                } else if (!updated && oldRes.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.resetPlayerTime();
                }
            }
            if (Flags.wspeed1.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
                } else if (oldRes.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setWalkSpeed(0.2f);
                }
            }
            if (Flags.wspeed2.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
                } else if (oldRes.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setWalkSpeed(0.2f);
                }
            }
            if (Flags.sun.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setPlayerWeather(WeatherType.CLEAR);
                } else if (oldRes.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.resetPlayerWeather();
                }
            }
            if (Flags.rain.isGlobalyEnabled()) {
                if (newRes.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setPlayerWeather(WeatherType.DOWNFALL);
                } else if (oldRes.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue) && !newRes.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.resetPlayerWeather();
                }
            }
            return;
        }
        if (newRes != null && oldRes == null) {
            if (Flags.glow.isGlobalyEnabled() && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1) && newRes.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(true);
            }
            if (Flags.fly.isGlobalyEnabled() && newRes.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, true);
            }
            if (Flags.day.isGlobalyEnabled() && newRes.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            }
            if (Flags.night.isGlobalyEnabled() && newRes.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            }
            if (Flags.wspeed1.isGlobalyEnabled() && newRes.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            }
            if (Flags.wspeed2.isGlobalyEnabled() && newRes.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            }
            if (Flags.sun.isGlobalyEnabled() && newRes.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            }
            if (Flags.rain.isGlobalyEnabled() && newRes.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location locfrom = event.getFrom();
        Location locto = event.getTo();
        if (locfrom.getBlockX() == locto.getBlockX() && locfrom.getBlockY() == locto.getBlockY() && locfrom.getBlockZ() == locto.getBlockZ()) {
            return;
        }
        Long last = this.lastUpdate.get(player.getUniqueId());
        if (last != null && System.currentTimeMillis() - last < (long)this.plugin.getConfigManager().getMinMoveUpdateInterval()) {
            return;
        }
        this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        boolean handled = this.handleNewLocation(player, locto, true);
        if (!handled) {
            event.setCancelled(true);
        }
        if (!this.plugin.getTeleportDelayMap().isEmpty() && this.plugin.getConfigManager().getTeleportDelay() > 0 && this.plugin.getTeleportDelayMap().contains(player.getName())) {
            this.plugin.getTeleportDelayMap().remove(player.getName());
            this.plugin.msg((CommandSender)player, lm.General_TeleportCanceled, new Object[0]);
            if (this.plugin.getConfigManager().isTeleportTitleMessage()) {
                CMITitleMessage.send((Player)player, (Object)"", (Object)"");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveInVehicle(VehicleMoveEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getVehicle().getWorld())) {
            return;
        }
        if (event.getVehicle().getPassenger() == null) {
            return;
        }
        ArrayList<Entity> ent = new ArrayList<Entity>();
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            ent.addAll(event.getVehicle().getPassengers());
        } else {
            ent.add(event.getVehicle().getPassenger());
        }
        for (Entity one : ent) {
            Long last;
            Player player;
            if (!(one instanceof Player) || (player = (Player)one) == null || player.hasMetadata("NPC")) continue;
            Location locfrom = event.getFrom();
            Location locto = event.getTo();
            if (locfrom.getBlockX() == locto.getBlockX() && locfrom.getBlockY() == locto.getBlockY() && locfrom.getBlockZ() == locto.getBlockZ() || (last = this.lastUpdate.get(player.getUniqueId())) != null && System.currentTimeMillis() - last < (long)this.plugin.getConfigManager().getMinMoveUpdateInterval()) continue;
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
            boolean handled = this.handleNewLocation(player, locto, true);
            if (!handled) {
                CMITeleporter.teleportAsync((Entity)event.getVehicle(), (Location)event.getFrom());
            }
            if (this.plugin.getTeleportDelayMap().isEmpty() || this.plugin.getConfigManager().getTeleportDelay() <= 0 || !this.plugin.getTeleportDelayMap().contains(player.getName())) continue;
            this.plugin.getTeleportDelayMap().remove(player.getName());
            this.plugin.msg((CommandSender)player, lm.General_TeleportCanceled, new Object[0]);
            if (!this.plugin.getConfigManager().isTeleportTitleMessage()) continue;
            CMITitleMessage.send((Player)player, (Object)"", (Object)"");
        }
    }

    private boolean teleport(Player player, Location loc) {
        if (player == null || !player.isOnline() || loc == null) {
            return false;
        }
        if (Version.isFolia()) {
            CMITeleporter.teleportAsync((Entity)player, (Location)loc);
            return true;
        }
        return CMITeleporter.teleport((Entity)player, (Location)loc);
    }

    private boolean checkNoFly(Player player, ClaimedResidence res, ClaimedResidence orres, Location loc) {
        UUID uuid = player.getUniqueId();
        Location location = player.getLocation().clone();
        int from = location.getBlockY();
        int to = CMIWorld.getMinHeight((World)loc.getWorld());
        boolean teleported = false;
        int i = from;
        while (i > to) {
            location.setY((double)i);
            Block block = location.getBlock();
            if (!ResidencePlayerListener.isEmptyBlock(block)) break;
            --i;
        }
        int distance = (int)(player.getLocation().getY() - location.getY());
        if (distance > 4) {
            Location lastLoc = this.lastOutsideLoc.get(uuid);
            player.closeInventory();
            if (lastLoc != null) {
                res = this.plugin.getResidenceManager().getByLoc(lastLoc);
                if (res != null) {
                    if (Flags.tp.isGlobalyEnabled() && res.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                        teleported = this.teleport(player, res.getOutsideFreeLoc(lastLoc, player, true));
                    } else {
                        player.setFlying(false);
                        player.setAllowFlight(false);
                    }
                } else {
                    teleported = this.teleport(player, lastLoc);
                }
            } else {
                teleported = this.teleport(player, res.getOutsideFreeLoc(loc, player, true));
            }
            if (teleported) {
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
            return teleported;
        }
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
        player.closeInventory();
        player.setFlying(false);
        player.setAllowFlight(false);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNewLocation(Player player, Location loc, boolean move) {
        boolean cantMove;
        UUID uuid;
        ClaimedResidence ResOld;
        ClaimedResidence res;
        ClaimedResidence orres = res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res != null) {
            while (res.getSubzoneByLoc(loc) != null) {
                res = res.getSubzoneByLoc(player.getLocation());
            }
        }
        if ((ResOld = this.currentRes.get(uuid = player.getUniqueId())) == null) {
            this.currentRes.remove(uuid);
        } else if (res != null && ResOld.getName().equals(res.getName())) {
            if (!Flags.nofly.isGlobalyEnabled()) return true;
            if (!player.isFlying()) return true;
            if (!res.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue)) return true;
            if (this.plugin.isResAdminOn(player)) return true;
            if (res.isOwner(player)) return true;
            if (PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0])) return true;
            return this.checkNoFly(player, res, orres, loc);
        }
        if (!this.plugin.getAutoSelectionManager().getList().isEmpty()) {
            CMIScheduler.runTaskAsynchronously(() -> this.plugin.getAutoSelectionManager().UpdateSelection(player));
        }
        if (res == null) {
            this.lastOutsideLoc.put(uuid, loc);
            if (ResOld == null) return true;
            ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, null, player);
            this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
            this.currentRes.remove(uuid);
            return true;
        }
        boolean bl = cantMove = res != null && Flags.move.isGlobalyEnabled() && res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !this.plugin.isResAdminOn(player) && !res.isOwner(player) && !PermissionManager.ResPerm.admin_move.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (move) {
            try {
                if (res.getRaid().isUnderRaid()) {
                    Location newLoc;
                    if (res.getRaid().isAttacker(player.getUniqueId())) return true;
                    if (res.getRaid().isDefender(player.getUniqueId())) {
                        return true;
                    }
                    Location lastLoc = this.lastOutsideLoc.get(uuid);
                    if (this.plugin.getConfigManager().BounceAnimation()) {
                        Visualizer v = new Visualizer(player);
                        v.setErrorAreas(res);
                        v.setOnce(true);
                        this.plugin.getSelectionManager().showBounds(player, v);
                    }
                    ClaimedResidence preRes = this.plugin.getResidenceManager().getByLoc(lastLoc);
                    boolean teleported = false;
                    if (preRes != null && Flags.tp.isGlobalyEnabled() && preRes.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                        newLoc = res.getOutsideFreeLoc(loc, player, true);
                        player.closeInventory();
                        teleported = this.teleport(player, newLoc);
                    }
                    if (!teleported) {
                        if (lastLoc != null) {
                            StuckInfo info2 = this.updateStuckTeleport(player, loc);
                            player.closeInventory();
                            if (info2 != null && info2.getTimesTeleported() > 5) {
                                Location newLoc2 = res.getOutsideFreeLoc(loc, player, true);
                                teleported = this.teleport(player, newLoc2);
                            } else {
                                teleported = this.teleport(player, lastLoc);
                            }
                        }
                        if (!teleported) {
                            newLoc = res.getOutsideFreeLoc(loc, player, true);
                            player.closeInventory();
                            teleported = this.teleport(player, newLoc);
                        }
                    }
                    switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                        case ActionBar: 
                        case TitleBar: {
                            ResidencePermissions perms = res.getPermissions();
                            if (!((FlagPermissions)perms).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) return teleported;
                            CMIActionBar.send((Player)player, (String)this.plugin.msg(lm.Raid_cantDo, new Object[0]));
                            return teleported;
                        }
                        case ChatBox: {
                            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, orres.getName());
                            return teleported;
                        }
                    }
                    return teleported;
                }
                if (cantMove) {
                    Location newLoc;
                    Location lastLoc = this.lastOutsideLoc.get(uuid);
                    if (this.plugin.getConfigManager().BounceAnimation()) {
                        Visualizer v = new Visualizer(player);
                        v.setErrorAreas(res);
                        v.setOnce(true);
                        this.plugin.getSelectionManager().showBounds(player, v);
                    }
                    ClaimedResidence preRes = this.plugin.getResidenceManager().getByLoc(lastLoc);
                    boolean teleported = false;
                    if (preRes != null && preRes.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                        newLoc = res.getOutsideFreeLoc(loc, player, true);
                        player.closeInventory();
                        teleported = this.teleport(player, newLoc);
                    }
                    if (!teleported) {
                        if (lastLoc != null) {
                            StuckInfo info3 = this.updateStuckTeleport(player, loc);
                            player.closeInventory();
                            if (info3 != null && info3.getTimesTeleported() > 5) {
                                Location newLoc3 = res.getOutsideFreeLoc(loc, player, true);
                                teleported = this.teleport(player, newLoc3);
                            } else {
                                teleported = this.teleport(player, lastLoc);
                            }
                        }
                        if (!teleported) {
                            newLoc = res.getOutsideFreeLoc(loc, player, true);
                            player.closeInventory();
                            teleported = this.teleport(player, newLoc);
                        }
                    }
                    switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                        case ActionBar: 
                        case TitleBar: {
                            ResidencePermissions perms = res.getPermissions();
                            if (!((FlagPermissions)perms).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) return teleported;
                            CMIActionBar.send((Player)player, (String)this.plugin.msg(lm.Residence_MoveDeny, orres.getName()));
                            return teleported;
                        }
                        case ChatBox: {
                            this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, orres.getName());
                            return teleported;
                        }
                    }
                    return teleported;
                }
                if (Flags.nofly.isGlobalyEnabled() && player.isFlying() && res.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0]) && !res.isOwner(player)) {
                    return this.checkNoFly(player, res, orres, loc);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.currentRes.containsKey(uuid)) {
            if (ResOld == res) return true;
        }
        if (!cantMove) {
            this.currentRes.put(uuid, res);
            ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, res, player);
            this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
            return true;
        }
        Location lastLoc = this.lastOutsideLoc.get(uuid);
        player.closeInventory();
        if (!move) {
            return false;
        }
        if (lastLoc != null && CMIMaterial.isAir((Material)lastLoc.getBlock().getType())) {
            Long last = this.lastUpdate.get(player.getUniqueId());
            if (last != null && System.currentTimeMillis() - last < 45L) {
                this.teleport(player, res.getOutsideFreeLoc(loc, player, true));
                return false;
            }
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
            ClaimedResidence outsideRes = this.plugin.getResidenceManager().getByLoc(lastLoc);
            if (!(outsideRes == null || Flags.move.isGlobalyEnabled() || !outsideRes.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) || this.plugin.isResAdminOn(player) || outsideRes.isOwner(player) || PermissionManager.ResPerm.admin_move.hasPermission((CommandSender)player, 10000L, new String[0]))) {
                return false;
            }
            if (!this.plugin.getPermsByLoc(lastLoc).playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
                return false;
            }
            this.teleport(player, lastLoc);
            return false;
        }
        this.teleport(player, res.getOutsideFreeLoc(loc, player, true));
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChangeMessagePrint(ResidenceChangedEvent event) {
        Long time;
        Player player;
        ClaimedResidence res;
        ClaimedResidence from = event.getFrom();
        ClaimedResidence to = event.getTo();
        String message2 = null;
        ClaimedResidence claimedResidence = res = from == null ? to : from;
        if (from == null && to != null) {
            message2 = to.getEnterMessage();
            res = to;
        }
        if (from != null && to == null) {
            message2 = from.getLeaveMessage();
            res = from;
        }
        if (from != null && to != null) {
            message2 = to.getEnterMessage();
            res = to;
        }
        if ((player = event.getPlayer()).hasMetadata("NPC")) {
            return;
        }
        if (!(message2 == null || message2.isEmpty() || (time = this.informar.get(player.getUniqueId())) != null && time + 100L >= System.currentTimeMillis())) {
            if (res.getPermissions().has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) {
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: {
                        CMIActionBar.send((Player)player, (String)(ChatColor.YELLOW + this.insertMessages(player, res, message2)));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, res, message2));
                        break;
                    }
                    case TitleBar: {
                        String title = ChatColor.YELLOW + this.insertMessages(player, res, message2);
                        String subtitle = "";
                        if (title.contains("\\n")) {
                            subtitle = ChatColor.YELLOW + title.split("\\\\n", 2)[1];
                            title = title.split("\\\\n", 2)[0];
                        }
                        CMITitleMessage.send((Player)player, (Object)title, (Object)subtitle);
                        break;
                    }
                }
            }
            this.informar.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (to != null && this.plugin.getConfigManager().isEnterAnimation() && to.isTopArea() && (from == null || from.getTopParent() != to)) {
            to.showBounds(player, true);
        }
        if (from == null || res == null) {
            return;
        }
        if (res != from.getParent() && this.plugin.getConfigManager().isExtraEnterMessage() && !res.isOwner(player) && (this.plugin.getRentManager().isForRent(from) || this.plugin.getTransactionManager().isForSale(from))) {
            if (this.plugin.getRentManager().isForRent(from) && !this.plugin.getRentManager().isRented(from)) {
                RentableLand rentable = this.plugin.getRentManager().getRentableLand(from);
                if (rentable != null) {
                    CMIActionBar.send((Player)player, (String)this.plugin.msg(lm.Residence_CanBeRented, from.getName(), rentable.cost, rentable.days));
                }
            } else if (this.plugin.getTransactionManager().isForSale(from) && !res.isOwner(player)) {
                int sale = this.plugin.getTransactionManager().getSaleAmount(from);
                CMIActionBar.send((Player)player, (String)this.plugin.msg(lm.Residence_CanBeBought, from.getName(), sale));
            }
        }
    }

    private StuckInfo updateStuckTeleport(Player player, Location loc) {
        if (loc.getY() >= player.getLocation().getY()) {
            return null;
        }
        StuckInfo info2 = this.stuckTeleportCounter.get(player.getUniqueId());
        if (info2 == null) {
            info2 = new StuckInfo(player);
            this.stuckTeleportCounter.put(player.getUniqueId(), info2);
        }
        info2.updateLastTp();
        return info2;
    }

    public String insertMessages(Player player, ClaimedResidence res, String message2) {
        try {
            message2 = message2.replace("%playerDisplay", player.getDisplayName());
            message2 = message2.replace("%player", player.getName());
            message2 = message2.replace("%owner", res.getPermissions().getOwner());
            message2 = message2.replace("%residence", res.getName());
            message2 = message2.replace("%zone", res.getResidenceName());
        }
        catch (Exception ex) {
            return "";
        }
        return message2;
    }

    public void doHeals() {
        if (!Flags.healing.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                Player damage;
                double health;
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.healing, false) || !((health = (damage = player).getHealth()) < damage.getMaxHealth()) || player.isDead()) continue;
                player.setHealth(health + 1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feed() {
        if (!Flags.feed.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                int food;
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.feed, false) || (food = player.getFoodLevel()) >= 20 || player.isDead()) continue;
                player.setFoodLevel(food + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void badEffects() {
        if (!Flags.safezone.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.safezone, FlagPermissions.FlagCombo.OnlyTrue) || player.getActivePotionEffects().isEmpty()) continue;
                for (PotionEffect one : player.getActivePotionEffects()) {
                    if (!this.plugin.getConfigManager().getNegativePotionEffects().contains(one.getType().getName().toLowerCase())) continue;
                    player.removePotionEffect(one.getType());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DespawnMobs() {
        if (!Flags.nomobs.isGlobalyEnabled()) {
            return;
        }
        try {
            HashSet<ClaimedResidence> residences = new HashSet<ClaimedResidence>();
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null) continue;
                if (!res.getPermissions().has(Flags.nomobs, false)) {
                    for (ClaimedResidence sub : res.getSubzonesMap().values()) {
                        if (!sub.getPermissions().has(Flags.nomobs, false)) continue;
                        residences.add(sub);
                    }
                    continue;
                }
                residences.add(res);
            }
            for (ClaimedResidence res : residences) {
                HashSet<Entity> entities = new HashSet<Entity>();
                World world = Bukkit.getWorld((String)res.getWorld());
                if (world == null) continue;
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                    for (CuboidArea area2 : res.getAreaMap().values()) {
                        entities.addAll(world.getNearbyEntities(BoundingBox.of((Vector)area2.getLowVector(), (Vector)area2.getHighVector())));
                    }
                } else {
                    for (CuboidArea area2 : res.getAreaMap().values()) {
                        for (ResidenceManager.ChunkRef chunk : area2.getChunks()) {
                            entities.addAll(Arrays.asList(world.getChunkAt(chunk.getX(), chunk.getZ()).getEntities()));
                        }
                    }
                }
                for (Entity ent : entities) {
                    ClaimedResidence ares;
                    if (!ResidenceEntityListener.isMonster(ent) || !res.containsLoc(ent.getLocation()) || !(ares = this.plugin.getResidenceManager().getByLoc(ent.getLocation())).getPermissions().has(Flags.nomobs, FlagPermissions.FlagCombo.OnlyTrue)) continue;
                    ent.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        String pname = event.getPlayer().getName();
        if (!this.chatenabled || !this.playerToggleChat.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        ChatChannel channel = this.plugin.getChatManager().getPlayerChannel(pname);
        if (channel != null) {
            channel.chat(pname, event.getMessage());
        }
        event.setCancelled(true);
    }

    public void tooglePlayerResidenceChat(Player player, String residence) {
        this.playerToggleChat.add(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelChange, residence);
    }

    @Deprecated
    public void removePlayerResidenceChat(String pname) {
        this.removePlayerResidenceChat(Bukkit.getPlayer((String)pname));
    }

    public void removePlayerResidenceChat(Player player) {
        if (player == null) {
            return;
        }
        this.playerToggleChat.remove(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelLeave, new Object[0]);
    }

    public ClaimedResidence getCurrentResidence(UUID uuid) {
        return this.currentRes.get(uuid);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags() {
        if ($SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags != null) {
            return $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags;
        }
        int[] nArray = new int[Flags.values().length];
        try {
            nArray[Flags.admin.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.anchor.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.animalkilling.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.animals.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.anvil.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.anvilbreak.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.backup.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.bank.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.beacon.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.bed.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.brew.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.brush.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.build.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.burn.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.button.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.cake.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.canimals.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.chat.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.chorustp.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.cmonsters.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.command.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.commandblock.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.container.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.coords.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.copper.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.craft.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.creeper.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.damage.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.day.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.decay.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.destroy.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.diode.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.door.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dragongrief.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dryup.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dye.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.egg.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.elytra.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.enchant.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.enderpearl.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.explode.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.falldamage.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fallinprotection.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.feed.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fireball.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.firespread.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flow.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flowerpot.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flowinprotection.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fly.ordinal()] = 84;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.friendlyfire.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.glow.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.goathorn.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.grow.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.harvest.ordinal()] = 57;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.healing.ordinal()] = 61;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hidden.ordinal()] = 59;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.honey.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.honeycomb.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hook.ordinal()] = 60;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hotfloor.ordinal()] = 58;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.iceform.ordinal()] = 62;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.icemelt.ordinal()] = 63;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.ignite.ordinal()] = 64;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.itemdrop.ordinal()] = 65;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.itempickup.ordinal()] = 66;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.jump2.ordinal()] = 67;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.jump3.ordinal()] = 68;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.keepexp.ordinal()] = 70;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.keepinv.ordinal()] = 69;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.lavaflow.ordinal()] = 71;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.leash.ordinal()] = 72;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.lever.ordinal()] = 73;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobexpdrop.ordinal()] = 74;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobitemdrop.ordinal()] = 75;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobkilling.ordinal()] = 76;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.monsters.ordinal()] = 77;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.move.ordinal()] = 78;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nametag.ordinal()] = 79;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nanimals.ordinal()] = 80;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.night.ordinal()] = 82;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nmonsters.ordinal()] = 81;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nodurability.ordinal()] = 87;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nofly.ordinal()] = 83;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nomobs.ordinal()] = 85;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.note.ordinal()] = 86;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.overridepvp.ordinal()] = 88;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.phantomspawn.ordinal()] = 116;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.piston.ordinal()] = 90;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pistonprotection.ordinal()] = 91;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.place.ordinal()] = 92;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pressure.ordinal()] = 89;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pvp.ordinal()] = 93;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.rain.ordinal()] = 94;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.respawn.ordinal()] = 95;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.riding.ordinal()] = 96;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.safezone.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.sanimals.ordinal()] = 103;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shear.ordinal()] = 104;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shoot.ordinal()] = 97;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shop.ordinal()] = 99;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.smonsters.ordinal()] = 105;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.snowball.ordinal()] = 102;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.snowtrail.ordinal()] = 100;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.spread.ordinal()] = 101;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.subzone.ordinal()] = 106;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.sun.ordinal()] = 98;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.table.ordinal()] = 108;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.title.ordinal()] = 107;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.tnt.ordinal()] = 109;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.tp.ordinal()] = 110;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.trade.ordinal()] = 111;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.trample.ordinal()] = 112;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.use.ordinal()] = 113;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.vehicledestroy.ordinal()] = 114;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.waterflow.ordinal()] = 119;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherdamage.ordinal()] = 117;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherdestruction.ordinal()] = 118;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherspawn.ordinal()] = 115;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.wspeed1.ordinal()] = 120;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.wspeed2.ordinal()] = 121;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags = nArray;
        return nArray;
    }
}

