/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ResidencePlayerListener1_16
implements Listener {
    private Residence plugin;

    public ResidencePlayerListener1_16(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractRespawn(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && event.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Material mat = block.getType();
        if (!mat.equals((Object)Material.RESPAWN_ANCHOR)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res == null) {
            return;
        }
        if (!(res.isOwner(player) || res.getPermissions().playerHas(player, Flags.anchor, FlagPermissions.FlagCombo.OnlyTrue) || this.plugin.isResAdminOn(player))) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.anchor, res.getName()});
            event.setCancelled(true);
        }
    }
}

