/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ResidencePlayerListener1_19
implements Listener {
    private Residence plugin;

    public ResidencePlayerListener1_19(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSignInteract(PlayerInteractEvent event) {
        if (!Flags.goathorn.isGlobalyEnabled()) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ItemStack horn = event.getItem();
        if (horn == null) {
            return;
        }
        if (!horn.getType().equals((Object)Material.GOAT_HORN)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getPlayer().getLocation());
        if (res == null) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (res.getPermissions().playerHas(event.getPlayer(), Flags.goathorn, FlagPermissions.FlagCombo.TrueOrNone)) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.goathorn, res.getName()});
    }
}

