/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class CuboidArea {
    private Vector highPoints;
    private Vector lowPoints;
    protected String worldName;
    protected World world;

    public CuboidArea(Location startLoc, Location endLoc) {
        int lowz;
        int highz;
        int lowy;
        int highy;
        int lowx;
        int highx;
        if (startLoc == null || endLoc == null) {
            return;
        }
        if (startLoc.getBlockX() > endLoc.getBlockX()) {
            highx = startLoc.getBlockX();
            lowx = endLoc.getBlockX();
        } else {
            highx = endLoc.getBlockX();
            lowx = startLoc.getBlockX();
        }
        if (startLoc.getBlockY() > endLoc.getBlockY()) {
            highy = startLoc.getBlockY();
            lowy = endLoc.getBlockY();
        } else {
            highy = endLoc.getBlockY();
            lowy = startLoc.getBlockY();
        }
        if (startLoc.getBlockZ() > endLoc.getBlockZ()) {
            highz = startLoc.getBlockZ();
            lowz = endLoc.getBlockZ();
        } else {
            highz = endLoc.getBlockZ();
            lowz = startLoc.getBlockZ();
        }
        this.highPoints = new Vector(highx, highy, highz);
        this.lowPoints = new Vector(lowx, lowy, lowz);
        this.world = startLoc.getWorld() != null ? startLoc.getWorld() : (startLoc.getWorld() != null ? startLoc.getWorld() : null);
        this.worldName = this.world != null ? this.world.getName() : null;
    }

    public CuboidArea() {
    }

    public boolean isAreaWithinArea(CuboidArea area2) {
        return this.containsLoc(area2.highPoints, area2.getWorldName()) && this.containsLoc(area2.lowPoints, area2.getWorldName());
    }

    public boolean containsLoc(Location loc) {
        return this.containsLoc(loc.toVector(), loc.getWorld().getName());
    }

    public boolean containsLoc(Vector loc, String world) {
        if (loc == null) {
            return false;
        }
        if (!world.equals(this.worldName)) {
            return false;
        }
        if (this.lowPoints.getBlockX() > loc.getBlockX()) {
            return false;
        }
        if (this.highPoints.getBlockX() < loc.getBlockX()) {
            return false;
        }
        if (this.lowPoints.getBlockZ() > loc.getBlockZ()) {
            return false;
        }
        if (this.highPoints.getBlockZ() < loc.getBlockZ()) {
            return false;
        }
        if (this.lowPoints.getBlockY() > loc.getBlockY()) {
            return false;
        }
        return this.highPoints.getBlockY() >= loc.getBlockY();
    }

    public boolean checkCollision(CuboidArea area2) {
        if (!area2.getWorld().equals(this.getWorld())) {
            return false;
        }
        if (area2.containsLoc(this.lowPoints, this.getWorldName()) || area2.containsLoc(this.highPoints, this.getWorldName()) || this.containsLoc(area2.highPoints, this.getWorldName()) || this.containsLoc(area2.lowPoints, this.getWorldName())) {
            return true;
        }
        return CuboidArea.advCuboidCheckCollision(this.highPoints, this.lowPoints, area2.highPoints, area2.lowPoints);
    }

    private static boolean advCuboidCheckCollision(Vector A1High, Vector A1Low, Vector A2High, Vector A2Low) {
        int A1HX = A1High.getBlockX();
        int A1LX = A1Low.getBlockX();
        int A2HX = A2High.getBlockX();
        int A2LX = A2Low.getBlockX();
        if (A1HX >= A2LX && A1HX <= A2HX || A1LX >= A2LX && A1LX <= A2HX || A2HX >= A1LX && A2HX <= A1HX || A2LX >= A1LX && A2LX <= A1HX) {
            int A1HY = A1High.getBlockY();
            int A1LY = A1Low.getBlockY();
            int A2HY = A2High.getBlockY();
            int A2LY = A2Low.getBlockY();
            if (A1HY >= A2LY && A1HY <= A2HY || A1LY >= A2LY && A1LY <= A2HY || A2HY >= A1LY && A2HY <= A1HY || A2LY >= A1LY && A2LY <= A1HY) {
                int A1HZ = A1High.getBlockZ();
                int A1LZ = A1Low.getBlockZ();
                int A2HZ = A2High.getBlockZ();
                int A2LZ = A2Low.getBlockZ();
                if (A1HZ >= A2LZ && A1HZ <= A2HZ || A1LZ >= A2LZ && A1LZ <= A2HZ || A2HZ >= A1LZ && A2HZ <= A1HZ || A2LZ >= A1LZ && A2LZ <= A1HZ) {
                    return true;
                }
            }
        }
        return false;
    }

    public long getSize() {
        int xsize = this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
        int zsize = this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
        if (!Residence.getInstance().getConfigManager().isNoCostForYBlocks()) {
            int ysize = this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
            return xsize * ysize * zsize;
        }
        return xsize * zsize;
    }

    public int getXSize() {
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    public Vector getHighVector() {
        return this.highPoints;
    }

    public Vector getLowVector() {
        return this.lowPoints;
    }

    @Deprecated
    public Location getHighLoc() {
        return this.getHighLocation();
    }

    @Deprecated
    public Location getLowLoc() {
        return this.getLowLocation();
    }

    public Location getHighLocation() {
        return this.highPoints.toLocation(this.getWorld());
    }

    public Location getLowLocation() {
        return this.lowPoints.toLocation(this.getWorld());
    }

    public World getWorld() {
        if (this.world == null && this.worldName != null) {
            this.world = Bukkit.getWorld((String)this.worldName);
        }
        return this.world;
    }

    public String getWorldName() {
        return this.world != null ? this.world.getName() : this.worldName;
    }

    public Map<String, Object> save() {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        root.put("X1", this.highPoints.getBlockX());
        root.put("Y1", this.highPoints.getBlockY());
        root.put("Z1", this.highPoints.getBlockZ());
        root.put("X2", this.lowPoints.getBlockX());
        root.put("Y2", this.lowPoints.getBlockY());
        root.put("Z2", this.lowPoints.getBlockZ());
        return root;
    }

    public String newSave() {
        return String.valueOf(this.lowPoints.getBlockX()) + ":" + this.lowPoints.getBlockY() + ":" + this.lowPoints.getBlockZ() + ":" + this.highPoints.getBlockX() + ":" + this.highPoints.getBlockY() + ":" + this.highPoints.getBlockZ();
    }

    public static CuboidArea newLoad(String root, String world) throws Exception {
        if (root == null || !root.contains(":")) {
            throw new Exception("Invalid residence physical location...");
        }
        CuboidArea newArea = new CuboidArea();
        String[] split = root.split(":");
        try {
            int x1 = Integer.parseInt(split[0]);
            int y1 = Integer.parseInt(split[1]);
            int z1 = Integer.parseInt(split[2]);
            int x2 = Integer.parseInt(split[3]);
            int y2 = Integer.parseInt(split[4]);
            int z2 = Integer.parseInt(split[5]);
            newArea.lowPoints = new Vector(x1, y1, z1);
            newArea.highPoints = new Vector(x2, y2, z2);
            newArea.worldName = world;
        }
        catch (Exception e) {
            throw new Exception("Invalid residence physical location...");
        }
        return newArea;
    }

    public static CuboidArea load(Map<String, Object> root, String world) throws Exception {
        if (root == null) {
            throw new Exception("Invalid residence physical location...");
        }
        CuboidArea newArea = new CuboidArea();
        int x1 = (Integer)root.get("X1");
        int y1 = (Integer)root.get("Y1");
        int z1 = (Integer)root.get("Z1");
        int x2 = (Integer)root.get("X2");
        int y2 = (Integer)root.get("Y2");
        int z2 = (Integer)root.get("Z2");
        newArea.highPoints = new Vector(x1, y1, z1);
        newArea.lowPoints = new Vector(x2, y2, z2);
        newArea.worldName = world;
        newArea.world = Bukkit.getWorld((String)newArea.worldName);
        return newArea;
    }

    public List<ResidenceManager.ChunkRef> getChunks() {
        ArrayList<ResidenceManager.ChunkRef> chunks = new ArrayList<ResidenceManager.ChunkRef>();
        Vector high = this.highPoints;
        Vector low = this.lowPoints;
        int lowX = ResidenceManager.ChunkRef.getChunkCoord(low.getBlockX());
        int lowZ = ResidenceManager.ChunkRef.getChunkCoord(low.getBlockZ());
        int highX = ResidenceManager.ChunkRef.getChunkCoord(high.getBlockX());
        int highZ = ResidenceManager.ChunkRef.getChunkCoord(high.getBlockZ());
        int x = lowX;
        while (x <= highX) {
            int z = lowZ;
            while (z <= highZ) {
                chunks.add(new ResidenceManager.ChunkRef(x, z));
                ++z;
            }
            ++x;
        }
        return chunks;
    }

    public void setHighLocation(Location highLocation) {
        this.highPoints = highLocation.toVector();
        this.world = highLocation.getWorld();
    }

    public void setHighVector(Vector highLocation) {
        this.highPoints = highLocation;
    }

    public void setLowLocation(Location lowLocation) {
        this.lowPoints = lowLocation.toVector();
        this.world = lowLocation.getWorld();
    }

    public void setLowVector(Vector lowLocation) {
        this.lowPoints = lowLocation;
    }

    public double getCost(PermissionGroup group) {
        return (double)((long)((double)this.getSize() * group.getCostPerBlock() * 100.0)) / 100.0;
    }
}

