/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.module.display.filter.processer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.arasple.mc.trchat.module.display.filter.processer.BCConvert;
import me.arasple.mc.trchat.module.display.filter.processer.FilterSet;
import me.arasple.mc.trchat.module.display.filter.processer.FilteredObject;
import me.arasple.mc.trchat.module.display.filter.processer.WordNode;

public class Filter {
    private static FilterSet SET;
    private static Map<Integer, WordNode> NODES;
    private static Set<Integer> PUNCTUATIONS_SET;
    private static char SIGN;

    public static void setPunctuations(List<String> punctuations) {
        PUNCTUATIONS_SET = new HashSet<Integer>();
        Filter.addPunctuations(punctuations);
    }

    public static void setSensitiveWord(List<String> punctuations) {
        SET = new FilterSet();
        NODES = new HashMap<Integer, WordNode>();
        Filter.addSensitiveWord(punctuations);
    }

    public static void setReplacement(char sign) {
        SIGN = sign;
    }

    private static void addPunctuations(List<String> punctuations) {
        if (!punctuations.isEmpty()) {
            for (String curr : punctuations) {
                char[] chs;
                for (char c2 : chs = curr.toCharArray()) {
                    PUNCTUATIONS_SET.add(Filter.charConvert(c2));
                }
            }
        }
    }

    public static void addSensitiveWord(List<String> words) {
        if (!words.isEmpty()) {
            for (String curr : words) {
                WordNode fnode;
                char[] chs = curr.toCharArray();
                int fchar = Filter.charConvert(chs[0]);
                if (SET.contains(fchar)) {
                    SET.add(fchar);
                    fnode = new WordNode(fchar, chs.length == 1);
                    NODES.put(fchar, fnode);
                } else {
                    fnode = NODES.get(fchar);
                    if (!fnode.isLast() && chs.length == 1) {
                        fnode.setLast(true);
                    }
                }
                int lastIndex = chs.length - 1;
                for (int i = 1; i < chs.length; ++i) {
                    fnode = fnode.addIfNoExist(Filter.charConvert(chs[i]), i == lastIndex);
                }
            }
        }
    }

    public static FilteredObject doFilter(String src) {
        return Filter.doFilter(src, true);
    }

    public static FilteredObject doFilter(String src, boolean filter2) {
        if (!filter2) {
            return new FilteredObject(src, 0);
        }
        char[] chs = src.toCharArray();
        int length = chs.length;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            WordNode node;
            int curr = Filter.charConvert(chs[i]);
            if (SET.contains(curr) || (node = NODES.get(curr)) == null) continue;
            boolean couldMark = false;
            int markNum = -1;
            if (node.isLast()) {
                couldMark = true;
                markNum = 0;
            }
            int k = i;
            int curry = curr;
            while (++k < length) {
                int temp = Filter.charConvert(chs[k]);
                if (temp == curry || PUNCTUATIONS_SET.contains(temp)) continue;
                if ((node = node.querySub(temp)) == null) break;
                if (node.isLast()) {
                    couldMark = true;
                    markNum = k - i;
                }
                curry = temp;
            }
            if (!couldMark) continue;
            for (k = 0; k <= markNum; ++k) {
                if (PUNCTUATIONS_SET.contains(Filter.charConvert(chs[k + i]))) continue;
                chs[k + i] = SIGN;
            }
            ++count;
            i += markNum;
        }
        return new FilteredObject(new String(chs), count);
    }

    private static int charConvert(char src) {
        int r = BCConvert.qj2bj(src);
        return r >= 65 && r <= 90 ? r + 32 : r;
    }
}

