/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common.util;

import java.util.Objects;
import me.arasple.mc.trchat.taboolib.common.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Location
implements Cloneable {
    private String world;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public Location(@Nullable String world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public Location(@Nullable String world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    @Nullable
    public String getWorld() {
        return this.world;
    }

    public void setWorld(@NotNull String world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return Location.locToBlock(this.x);
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return Location.locToBlock(this.y);
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return Location.locToBlock(this.z);
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    @NotNull
    public Vector getDirection() {
        Vector vector = new Vector();
        double rotX = this.getYaw();
        double rotY = this.getPitch();
        vector.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        vector.setX(-xz * Math.sin(Math.toRadians(rotX)));
        vector.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return vector;
    }

    @NotNull
    public Location setDirection(@NotNull Vector vector) {
        double _2PI = Math.PI * 2;
        double x = vector.getX();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            this.pitch = vector.getY() > 0.0 ? -90.0f : 90.0f;
            return this;
        }
        double theta = Math.atan2(-x, z);
        this.yaw = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
        double x2 = Vector.square(x);
        double z2 = Vector.square(z);
        double xz = Math.sqrt(x2 + z2);
        this.pitch = (float)Math.toDegrees(Math.atan(-vector.getY() / xz));
        return this;
    }

    @NotNull
    public Location add(@NotNull Location vec) {
        if (!Objects.equals(vec.getWorld(), this.getWorld())) {
            throw new IllegalArgumentException("Cannot add Locations of differing worlds");
        }
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    @NotNull
    public Location add(@NotNull Vector vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        return this;
    }

    @NotNull
    public Location add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @NotNull
    public Location subtract(@NotNull Location vec) {
        if (!Objects.equals(vec.getWorld(), this.getWorld())) {
            throw new IllegalArgumentException("Cannot add Locations of differing worlds");
        }
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    @NotNull
    public Location subtract(@NotNull Vector vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        return this;
    }

    @NotNull
    public Location subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public double length() {
        return Math.sqrt(Vector.square(this.x) + Vector.square(this.y) + Vector.square(this.z));
    }

    public double lengthSquared() {
        return Vector.square(this.x) + Vector.square(this.y) + Vector.square(this.z);
    }

    public double distance(@NotNull Location o) {
        return Math.sqrt(this.distanceSquared(o));
    }

    public double distanceSquared(@NotNull Location o) {
        if (o.getWorld() == null || this.getWorld() == null) {
            throw new IllegalArgumentException("Cannot measure distance to a null world");
        }
        if (!o.getWorld().equals(this.getWorld())) {
            throw new IllegalArgumentException("Cannot measure distance between " + this.getWorld() + " and " + o.getWorld());
        }
        return Vector.square(this.x - o.x) + Vector.square(this.y - o.y) + Vector.square(this.z - o.z);
    }

    @NotNull
    public Location multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    @NotNull
    public Location zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return Double.compare(location.getX(), this.getX()) == 0 && Double.compare(location.getY(), this.getY()) == 0 && Double.compare(location.getZ(), this.getZ()) == 0 && Float.compare(location.getPitch(), this.getPitch()) == 0 && Float.compare(location.getYaw(), this.getYaw()) == 0 && Objects.equals(this.getWorld(), location.getWorld());
    }

    public int hashCode() {
        return Objects.hash(this.getWorld(), this.getX(), this.getY(), this.getZ(), Float.valueOf(this.getPitch()), Float.valueOf(this.getYaw()));
    }

    public String toString() {
        return "Location{world='" + this.world + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + '}';
    }

    @NotNull
    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    @NotNull
    public Location clone() {
        try {
            return (Location)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void checkFinite() throws IllegalArgumentException {
        Vector.checkFinite(this.x, "x not finite");
        Vector.checkFinite(this.y, "y not finite");
        Vector.checkFinite(this.z, "z not finite");
        Vector.checkFinite(this.pitch, "pitch not finite");
        Vector.checkFinite(this.yaw, "yaw not finite");
    }

    public Location referTo(float yaw, float offset, double multiply, double height) {
        Location referLoc = this.clone();
        referLoc.yaw = yaw + offset;
        Vector vectorAdd = referLoc.getDirection().normalize().multiply(multiply);
        referLoc.add(vectorAdd);
        referLoc.add(0.0, height, 0.0);
        return referLoc;
    }

    public static int locToBlock(double loc) {
        return Vector.floor(loc);
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        } else if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public static float normalizePitch(float pitch) {
        if (pitch > 90.0f) {
            pitch = 90.0f;
        } else if (pitch < -90.0f) {
            pitch = -90.0f;
        }
        return pitch;
    }
}

