/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.jarrelocator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import me.arasple.mc.trchat.taboolib.library.jarrelocator.JarRelocatorTask;
import me.arasple.mc.trchat.taboolib.library.jarrelocator.RelocatingRemapper;
import me.arasple.mc.trchat.taboolib.library.jarrelocator.Relocation;

public final class JarRelocator {
    private final File input;
    private final File output;
    private final RelocatingRemapper remapper;
    private final AtomicBoolean used = new AtomicBoolean(false);

    public JarRelocator(File input, File output, Collection<Relocation> relocations) {
        this.input = input;
        this.output = output;
        this.remapper = new RelocatingRemapper(relocations);
    }

    public JarRelocator(File input, File output, Map<String, String> relocations) {
        this.input = input;
        this.output = output;
        ArrayList<Relocation> c2 = new ArrayList<Relocation>(relocations.size());
        for (Map.Entry<String, String> entry : relocations.entrySet()) {
            c2.add(new Relocation(entry.getKey(), entry.getValue()));
        }
        this.remapper = new RelocatingRemapper(c2);
    }

    public void run() throws IOException {
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException("#run has already been called on this instance");
        }
        try (JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.output)));
             JarFile in = new JarFile(this.input);){
            JarRelocatorTask task = new JarRelocatorTask(this.remapper, out, in);
            task.processEntries();
        }
    }
}

