/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether.actions;

import java.util.concurrent.CompletableFuture;
import me.arasple.mc.trchat.taboolib.common5.Coerce;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import org.jetbrains.annotations.NotNull;

final class WhileAction
extends QuestAction<Void> {
    private final ParsedAction<?> condition;
    private final ParsedAction<?> action;

    public WhileAction(ParsedAction<?> condition, ParsedAction<?> action) {
        this.condition = condition;
        this.action = action;
    }

    @Override
    public CompletableFuture<Void> process(@NotNull QuestContext.Frame frame) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.process(frame, future);
        return future;
    }

    private void process(QuestContext.Frame frame, CompletableFuture<Void> future) {
        frame.newFrame(this.condition).run().thenAcceptAsync(t -> {
            if (Coerce.toBoolean(t)) {
                frame.newFrame(this.action).run().thenRunAsync(() -> this.process(frame, future), frame.context().getExecutor());
            } else {
                future.complete(null);
            }
        }, frame.context().getExecutor());
    }

    public static QuestActionParser parser(QuestService<?> service) {
        return QuestActionParser.of(resolver -> {
            ParsedAction condition = resolver.nextAction();
            resolver.expect("then");
            ParsedAction action = resolver.nextAction();
            return new WhileAction(condition, action);
        });
    }
}

