/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.nms;

import java.util.Arrays;
import me.arasple.mc.trchat.taboolib.common.Isolated;
import me.arasple.mc.trchat.taboolib.common.reflect.Reflex;
import me.arasple.mc.trchat.taboolib.module.nms.MinecraftServerUtilKt;

@Isolated
public enum BukkitAttribute {
    MAX_HEALTH("generic.maxHealth", new String[]{"health", "maxHealth"}),
    FOLLOW_RANGE("generic.followRange", new String[]{"follow", "followRange"}),
    KNOCKBACK_RESISTANCE("generic.knockbackResistance", new String[]{"knockback", "knockbackResistance"}),
    MOVEMENT_SPEED("generic.movementSpeed", new String[]{"speed", "movementSpeed", "walkSpeed"}),
    FLYING_SPEED("generic.flyingSpeed", new String[]{"flySpeed", "flyingSpeed"}),
    ATTACK_DAMAGE("generic.attackDamage", new String[]{"damage", "attackDamage"}),
    ATTACK_KNOCKBACK("generic.attackKnockback", new String[]{"damageKnockback", "attackKnockback"}),
    ATTACK_SPEED("generic.attackSpeed", new String[]{"damageSpeed", "attackSpeed"}),
    ARMOR("generic.armor", new String[]{"armor"}),
    ARMOR_TOUGHNESS("generic.armorToughness", new String[]{"toughness", "armorToughness"}),
    LUCK("generic.luck", new String[]{"luck"});

    String minecraftKey;
    String[] simplifiedKey;

    private BukkitAttribute(String minecraftKey, String[] simplifiedKey) {
        this.minecraftKey = minecraftKey;
        this.simplifiedKey = simplifiedKey;
    }

    public String getMinecraftKey() {
        return this.minecraftKey;
    }

    public String[] getSimplifiedKey() {
        return this.simplifiedKey;
    }

    public Object toNMS() {
        return new Reflex(MinecraftServerUtilKt.nmsClass("GenericAttributes")).get(this.name());
    }

    public boolean match(String source) {
        return this.name().equalsIgnoreCase(source) || this.minecraftKey.equalsIgnoreCase(source) || Arrays.stream(this.simplifiedKey).anyMatch(key -> key.equalsIgnoreCase(source));
    }

    public static BukkitAttribute parse(String source) {
        return Arrays.stream(BukkitAttribute.values()).filter(attribute -> attribute.match(source)).findFirst().orElse(null);
    }
}

