/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.platform;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import me.arasple.mc.trchat.taboolib.common.LifeCycle;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.io.Project1Kt;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformSide;
import me.arasple.mc.trchat.taboolib.common.platform.function.ExecutorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Plugin(id="implementation-velocity", name="implementation-velocity", version="2.0.0-PRE-19")
@PlatformSide(value={Platform.VELOCITY})
public class VelocityPlugin {
    @Nullable
    private static me.arasple.mc.trchat.taboolib.common.platform.Plugin pluginInstance;
    private static VelocityPlugin instance;
    private final ProxyServer server;
    private final Logger logger;
    private final Path configDirectory;

    @Inject
    public VelocityPlugin(ProxyServer server, Logger logger, @DataDirectory Path configDirectory) {
        this.logger = logger;
        this.server = server;
        this.configDirectory = configDirectory;
        instance = this;
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
    }

    @Subscribe
    public void e(ProxyInitializeEvent e2) {
        if (!TabooLibCommon.isStopped()) {
            TabooLibCommon.lifeCycle(LifeCycle.LOAD);
            if (pluginInstance == null) {
                pluginInstance = Project1Kt.findImplementation(me.arasple.mc.trchat.taboolib.common.platform.Plugin.class);
            }
            if (pluginInstance != null) {
                pluginInstance.onLoad();
            }
        }
        if (!TabooLibCommon.isStopped()) {
            TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
            if (pluginInstance != null) {
                pluginInstance.onEnable();
            }
            try {
                ExecutorKt.startExecutor();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!TabooLibCommon.isStopped()) {
            this.server.getScheduler().buildTask((Object)this, new Runnable(){

                @Override
                public void run() {
                    TabooLibCommon.lifeCycle(LifeCycle.ACTIVE);
                    if (pluginInstance != null) {
                        pluginInstance.onActive();
                    }
                }
            }).schedule();
        }
    }

    @Subscribe
    public void e(ProxyShutdownEvent e2) {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
        if (pluginInstance != null && !TabooLibCommon.isStopped()) {
            pluginInstance.onDisable();
        }
    }

    @NotNull
    public static VelocityPlugin getInstance() {
        return instance;
    }

    @Nullable
    public static me.arasple.mc.trchat.taboolib.common.platform.Plugin getPluginInstance() {
        return pluginInstance;
    }

    @NotNull
    public ProxyServer getServer() {
        return this.server;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    static {
        TabooLibCommon.lifeCycle(LifeCycle.CONST, Platform.VELOCITY);
        if (TabooLibCommon.isKotlinEnvironment()) {
            pluginInstance = Project1Kt.findImplementation(me.arasple.mc.trchat.taboolib.common.platform.Plugin.class);
        }
    }
}

