/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber;

import com.songoda.ultimatetimber.commands.CommandGiveAxe;
import com.songoda.ultimatetimber.commands.CommandReload;
import com.songoda.ultimatetimber.commands.CommandToggle;
import com.songoda.ultimatetimber.core.SongodaCore;
import com.songoda.ultimatetimber.core.SongodaPlugin;
import com.songoda.ultimatetimber.core.commands.CommandManager;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.configuration.Config;
import com.songoda.ultimatetimber.core.hooks.LogManager;
import com.songoda.ultimatetimber.manager.ChoppingManager;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import com.songoda.ultimatetimber.manager.PlacedBlockManager;
import com.songoda.ultimatetimber.manager.SaplingManager;
import com.songoda.ultimatetimber.manager.TreeAnimationManager;
import com.songoda.ultimatetimber.manager.TreeDefinitionManager;
import com.songoda.ultimatetimber.manager.TreeDetectionManager;
import com.songoda.ultimatetimber.manager.TreeFallManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public class UltimateTimber
extends SongodaPlugin {
    private static UltimateTimber INSTANCE;
    private Set<Manager> managers;
    private ChoppingManager choppingManager;
    private ConfigurationManager configurationManager;
    private CommandManager commandManager;
    private PlacedBlockManager placedBlockManager;
    private SaplingManager saplingManager;
    private TreeAnimationManager treeAnimationManager;
    private TreeDefinitionManager treeDefinitionManager;
    private TreeDetectionManager treeDetectionManager;
    private TreeFallManager treeFallManager;

    public static UltimateTimber getInstance() {
        return INSTANCE;
    }

    @Override
    public void onPluginLoad() {
        INSTANCE = this;
    }

    @Override
    public void onPluginEnable() {
        SongodaCore.registerPlugin((JavaPlugin)this, 18, CompatibleMaterial.IRON_AXE);
        LogManager.load();
        this.commandManager = new CommandManager(this);
        this.commandManager.addMainCommand("ut").addSubCommands(new CommandReload(this), new CommandToggle(this), new CommandGiveAxe(this));
        this.managers = new HashSet<Manager>();
        this.choppingManager = this.registerManager(ChoppingManager.class);
        this.configurationManager = new ConfigurationManager(this);
        this.placedBlockManager = this.registerManager(PlacedBlockManager.class);
        this.saplingManager = this.registerManager(SaplingManager.class);
        this.treeAnimationManager = this.registerManager(TreeAnimationManager.class);
        this.treeDefinitionManager = this.registerManager(TreeDefinitionManager.class);
        this.treeDetectionManager = this.registerManager(TreeDetectionManager.class);
        this.treeFallManager = this.registerManager(TreeFallManager.class);
        this.reloadConfig();
    }

    @Override
    public void onPluginDisable() {
        this.disable();
    }

    @Override
    public void onDataLoad() {
    }

    @Override
    public void onConfigReload() {
        this.configurationManager.reload();
        this.managers.forEach(Manager::reload);
        this.setLocale(this.getConfig().getString("locale"), true);
    }

    @Override
    public List<Config> getExtraConfig() {
        return null;
    }

    public void disable() {
        this.configurationManager.disable();
        this.managers.forEach(Manager::disable);
    }

    private <T extends Manager> T registerManager(Class<T> managerClass) {
        try {
            Manager newManager = (Manager)managerClass.getConstructor(UltimateTimber.class).newInstance(new Object[]{this});
            this.managers.add(newManager);
            return (T)newManager;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ChoppingManager getChoppingManager() {
        return this.choppingManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public PlacedBlockManager getPlacedBlockManager() {
        return this.placedBlockManager;
    }

    public SaplingManager getSaplingManager() {
        return this.saplingManager;
    }

    public TreeAnimationManager getTreeAnimationManager() {
        return this.treeAnimationManager;
    }

    public TreeDefinitionManager getTreeDefinitionManager() {
        return this.treeDefinitionManager;
    }

    public TreeDetectionManager getTreeDetectionManager() {
        return this.treeDetectionManager;
    }

    public TreeFallManager getTreeFallManager() {
        return this.treeFallManager;
    }
}

