/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.animation;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.animation.TreeAnimation;
import com.songoda.ultimatetimber.animation.TreeAnimationType;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.tree.DetectedTree;
import com.songoda.ultimatetimber.tree.FallingTreeBlock;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockSet;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import com.songoda.ultimatetimber.utils.BlockUtils;
import com.songoda.ultimatetimber.utils.ParticleUtils;
import com.songoda.ultimatetimber.utils.SoundUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TreeAnimationCrumble
extends TreeAnimation {
    public TreeAnimationCrumble(DetectedTree detectedTree, Player player) {
        super(TreeAnimationType.CRUMBLE, detectedTree, player);
    }

    @Override
    public void playAnimation(final Runnable whenFinished) {
        UltimateTimber ultimateTimber = UltimateTimber.getInstance();
        final boolean useCustomSound = ConfigurationManager.Setting.USE_CUSTOM_SOUNDS.getBoolean();
        final boolean useCustomParticles = ConfigurationManager.Setting.USE_CUSTOM_PARTICLES.getBoolean();
        int currentY = -1;
        final ArrayList treeBlocks = new ArrayList();
        ArrayList<ITreeBlock> currentPartition = new ArrayList<ITreeBlock>();
        ArrayList<ITreeBlock<Block>> orderedDetectedTreeBlocks = new ArrayList<ITreeBlock<Block>>(this.detectedTree.getDetectedTreeBlocks().getAllTreeBlocks());
        orderedDetectedTreeBlocks.sort(Comparator.comparingInt(x -> x.getLocation().getBlockY()));
        for (ITreeBlock iTreeBlock : orderedDetectedTreeBlocks) {
            if (currentY != iTreeBlock.getLocation().getBlockY()) {
                Collections.shuffle(currentPartition);
                treeBlocks.add(new ArrayList(currentPartition));
                currentPartition.clear();
                currentY = iTreeBlock.getLocation().getBlockY();
            }
            currentPartition.add(iTreeBlock);
        }
        Collections.shuffle(currentPartition);
        treeBlocks.add(new ArrayList(currentPartition));
        final TreeDefinition td = this.detectedTree.getTreeDefinition();
        new BukkitRunnable(){

            public void run() {
                if (!treeBlocks.isEmpty()) {
                    List partition = (List)treeBlocks.get(0);
                    for (int i = 0; i < 3 && !partition.isEmpty(); ++i) {
                        ITreeBlock treeBlock = (ITreeBlock)partition.remove(0);
                        if (!treeBlock.getTreeBlockType().equals((Object)TreeBlockType.LOG) ? treeBlock.getTreeBlockType().equals((Object)TreeBlockType.LEAF) && td.getLeafMaterial().stream().noneMatch(x -> x.equals((Object)CompatibleMaterial.getMaterial((Block)treeBlock.getBlock()))) : td.getLogMaterial().stream().noneMatch(x -> x.equals((Object)CompatibleMaterial.getMaterial((Block)treeBlock.getBlock())))) continue;
                        FallingTreeBlock fallingTreeBlock = TreeAnimationCrumble.this.convertToFallingBlock((TreeBlock)treeBlock);
                        if (fallingTreeBlock == null) continue;
                        BlockUtils.toggleGravityFallingBlock(fallingTreeBlock.getBlock(), true);
                        fallingTreeBlock.getBlock().setVelocity(Vector.getRandom().setY(0).subtract(new Vector(0.5, 0.0, 0.5)).multiply(0.15));
                        TreeAnimationCrumble.this.fallingTreeBlocks.add(fallingTreeBlock);
                        if (TreeAnimationCrumble.this.fallingTreeBlocks == null) {
                            TreeAnimationCrumble.this.fallingTreeBlocks = new TreeBlockSet<FallingBlock>(fallingTreeBlock);
                        }
                        if (useCustomSound) {
                            SoundUtils.playLandingSound(treeBlock);
                        }
                        if (!useCustomParticles) continue;
                        ParticleUtils.playFallingParticles(treeBlock);
                    }
                    if (partition.isEmpty()) {
                        treeBlocks.remove(0);
                    }
                }
                if (treeBlocks.isEmpty() && TreeAnimationCrumble.this.fallingTreeBlocks.getAllTreeBlocks().isEmpty()) {
                    whenFinished.run();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ultimateTimber, 0L, 1L);
    }
}

