/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.commands;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.core.commands.AbstractCommand;
import com.songoda.ultimatetimber.core.utils.PlayerUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandGiveAxe
extends AbstractCommand {
    private final UltimateTimber plugin;

    public CommandGiveAxe(UltimateTimber plugin) {
        super(AbstractCommand.CommandType.CONSOLE_OK, true, "give");
        this.plugin = plugin;
    }

    @Override
    protected AbstractCommand.ReturnType runCommand(CommandSender sender, String ... args) {
        ItemStack axe;
        if (args.length < 1) {
            return AbstractCommand.ReturnType.SYNTAX_ERROR;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        if (player == null) {
            if (args[0].trim().equalsIgnoreCase("me")) {
                if (!(sender instanceof Player)) {
                    return AbstractCommand.ReturnType.NEEDS_PLAYER;
                }
                player = (Player)sender;
            } else {
                this.plugin.getLocale().getMessageOrDefault("command.give.not-a-player", "&cNot a player.").sendPrefixedMessage(sender);
                return AbstractCommand.ReturnType.FAILURE;
            }
        }
        if ((axe = this.plugin.getTreeDefinitionManager().getRequiredAxe()) == null) {
            this.plugin.getLocale().getMessageOrDefault("command.give.no-axe", "&cThe axe could not be loaded.").sendPrefixedMessage(sender);
            return AbstractCommand.ReturnType.FAILURE;
        }
        player.getInventory().addItem(new ItemStack[]{axe});
        this.plugin.getLocale().getMessageOrDefault("command.give.given", "&fAxe given to &a%player%").processPlaceholder("player", player.getName()).sendPrefixedMessage(sender);
        return AbstractCommand.ReturnType.SUCCESS;
    }

    @Override
    protected List<String> onTab(CommandSender commandSender, String ... args) {
        List<String> suggestions = null;
        if (args.length == 1) {
            suggestions = PlayerUtils.getVisiblePlayerNames(commandSender, args[0]);
            suggestions.add("me");
        }
        return suggestions;
    }

    @Override
    public String getPermissionNode() {
        return "ultimatetimber.give";
    }

    @Override
    public String getSyntax() {
        return "give <player/me>";
    }

    @Override
    public String getDescription() {
        return "Give a required axe.";
    }
}

