/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core;

import com.songoda.ultimatetimber.core.commands.CommandManager;
import com.songoda.ultimatetimber.core.compatibility.ClientVersion;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.core.LocaleModule;
import com.songoda.ultimatetimber.core.core.PluginInfo;
import com.songoda.ultimatetimber.core.core.PluginInfoModule;
import com.songoda.ultimatetimber.core.core.SongodaCoreCommand;
import com.songoda.ultimatetimber.core.core.SongodaCoreDiagCommand;
import com.songoda.ultimatetimber.core.core.SongodaCoreIPCommand;
import com.songoda.ultimatetimber.core.core.SongodaCoreUUIDCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SongodaCore {
    private static final Logger logger = Logger.getLogger("SongodaCore");
    private static final int coreRevision = 9;
    private static final String coreVersion = "2.6.18";
    private static final int updaterVersion = 1;
    private static final Set<PluginInfo> registeredPlugins = new HashSet<PluginInfo>();
    private static SongodaCore INSTANCE = null;
    private JavaPlugin piggybackedPlugin;
    private CommandManager commandManager;
    private EventListener loginListener;
    private ShadedEventListener shadingListener;
    private ArrayList<BukkitTask> tasks = new ArrayList();

    public static boolean hasShading() {
        return !SongodaCore.class.getPackage().getName().equals(new String(new char[]{'c', 'o', 'm', '.', 's', 'o', 'n', 'g', 'o', 'd', 'a', '.', 'c', 'o', 'r', 'e'}));
    }

    public static void registerPlugin(JavaPlugin plugin, int pluginID, CompatibleMaterial icon) {
        SongodaCore.registerPlugin(plugin, pluginID, icon == null ? "STONE" : icon.name(), coreVersion);
    }

    public static void registerPlugin(JavaPlugin plugin, int pluginID, String icon) {
        SongodaCore.registerPlugin(plugin, pluginID, icon, "?");
    }

    public static void registerPlugin(JavaPlugin plugin, int pluginID, String icon, String coreVersion) {
        if (INSTANCE == null) {
            for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
                if (!clazz.getSimpleName().equals("SongodaCore")) continue;
                try {
                    int otherVersion;
                    try {
                        otherVersion = (Integer)clazz.getMethod("getCoreVersion", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception ignore) {
                        otherVersion = -1;
                    }
                    if (otherVersion >= SongodaCore.getCoreVersion()) {
                        clazz.getMethod("registerPlugin", JavaPlugin.class, Integer.TYPE, String.class, String.class).invoke(null, plugin, pluginID, icon, coreVersion);
                        if (SongodaCore.hasShading()) {
                            INSTANCE = new SongodaCore();
                            new SongodaCore().piggybackedPlugin = plugin;
                            SongodaCore.INSTANCE.shadingListener = new ShadedEventListener();
                            Bukkit.getPluginManager().registerEvents((Listener)SongodaCore.INSTANCE.shadingListener, (Plugin)plugin);
                        }
                        return;
                    }
                    List otherPlugins = (List)clazz.getMethod("getPlugins", new Class[0]).invoke(null, new Object[0]);
                    Object oldCore = clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Method destruct = clazz.getDeclaredMethod("destroy", new Class[0]);
                    destruct.setAccessible(true);
                    destruct.invoke(oldCore, new Object[0]);
                    INSTANCE = new SongodaCore(plugin);
                    INSTANCE.init();
                    INSTANCE.register(plugin, pluginID, icon, coreVersion);
                    Bukkit.getServicesManager().register(SongodaCore.class, (Object)INSTANCE, (Plugin)plugin, ServicePriority.Normal);
                    if (!otherPlugins.isEmpty()) {
                        Object testSubject = otherPlugins.get(0);
                        Class<?> otherPluginInfo = testSubject.getClass();
                        Method otherPluginInfo_getJavaPlugin = otherPluginInfo.getMethod("getJavaPlugin", new Class[0]);
                        Method otherPluginInfo_getSongodaId = otherPluginInfo.getMethod("getSongodaId", new Class[0]);
                        Method otherPluginInfo_getCoreIcon = otherPluginInfo.getMethod("getCoreIcon", new Class[0]);
                        Method otherPluginInfo_getCoreLibraryVersion = otherVersion >= 6 ? otherPluginInfo.getMethod("getCoreLibraryVersion", new Class[0]) : null;
                        for (Object other : otherPlugins) {
                            INSTANCE.register((JavaPlugin)otherPluginInfo_getJavaPlugin.invoke(other, new Object[0]), (Integer)otherPluginInfo_getSongodaId.invoke(other, new Object[0]), (String)otherPluginInfo_getCoreIcon.invoke(other, new Object[0]), otherPluginInfo_getCoreLibraryVersion != null ? (String)otherPluginInfo_getCoreLibraryVersion.invoke(other, new Object[0]) : "?");
                        }
                    }
                    return;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    plugin.getLogger().log(Level.WARNING, "Error registering core service", ex);
                }
            }
            INSTANCE = new SongodaCore(plugin);
            INSTANCE.init();
            Bukkit.getServicesManager().register(SongodaCore.class, (Object)INSTANCE, (Plugin)plugin, ServicePriority.Normal);
        }
        INSTANCE.register(plugin, pluginID, icon, coreVersion);
    }

    SongodaCore() {
        this.commandManager = null;
    }

    SongodaCore(JavaPlugin javaPlugin) {
        this.piggybackedPlugin = javaPlugin;
        this.commandManager = new CommandManager(this.piggybackedPlugin);
        this.loginListener = new EventListener();
    }

    private void init() {
        this.shadingListener = new ShadedEventListener();
        this.commandManager.registerCommandDynamically(new SongodaCoreCommand()).addSubCommands(new SongodaCoreDiagCommand(), new SongodaCoreIPCommand(), new SongodaCoreUUIDCommand());
        Bukkit.getPluginManager().registerEvents((Listener)this.loginListener, (Plugin)this.piggybackedPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.shadingListener, (Plugin)this.piggybackedPlugin);
        this.tasks.add(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.piggybackedPlugin, () -> CommandManager.registerCommandDynamically((Plugin)this.piggybackedPlugin, "songoda", this.commandManager, this.commandManager), 600L));
        this.tasks.add(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.piggybackedPlugin, () -> CommandManager.registerCommandDynamically((Plugin)this.piggybackedPlugin, "songoda", this.commandManager, this.commandManager), 1200L));
        this.tasks.add(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.piggybackedPlugin, () -> CommandManager.registerCommandDynamically((Plugin)this.piggybackedPlugin, "songoda", this.commandManager, this.commandManager), 2400L));
    }

    private void destroy() {
        Bukkit.getServicesManager().unregister(SongodaCore.class, (Object)INSTANCE);
        this.tasks.stream().filter(Objects::nonNull).forEach(task -> Bukkit.getScheduler().cancelTask(task.getTaskId()));
        HandlerList.unregisterAll((Listener)this.loginListener);
        if (!SongodaCore.hasShading()) {
            HandlerList.unregisterAll((Listener)this.shadingListener);
        }
        registeredPlugins.clear();
        this.commandManager = null;
        this.loginListener = null;
    }

    private void register(JavaPlugin plugin, int pluginID, String icon, String libraryVersion) {
        logger.info(SongodaCore.getPrefix() + "Hooked " + plugin.getName() + ".");
        PluginInfo info = new PluginInfo(plugin, pluginID, icon, libraryVersion);
        info.addModule(new LocaleModule());
        registeredPlugins.add(info);
        this.tasks.add(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.update(info), 60L));
    }

    private void update(PluginInfo plugin) {
        try {
            int numCharsRead;
            URL url = new URL("https://update.songoda.com/index.php?plugin=" + plugin.getSongodaId() + "&version=" + plugin.getJavaPlugin().getDescription().getVersion() + "&updaterVersion=" + 1);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            urlConnection.setRequestProperty("Accept", "*/*");
            urlConnection.setConnectTimeout(5000);
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            char[] charArray = new char[1024];
            StringBuilder sb = new StringBuilder();
            while ((numCharsRead = isr.read(charArray)) > 0) {
                sb.append(charArray, 0, numCharsRead);
            }
            urlConnection.disconnect();
            String jsonString = sb.toString();
            JSONObject json = (JSONObject)new JSONParser().parse(jsonString);
            plugin.setLatestVersion((String)json.get((Object)"latestVersion"));
            plugin.setMarketplaceLink((String)json.get((Object)"link"));
            plugin.setNotification((String)json.get((Object)"notification"));
            plugin.setChangeLog((String)json.get((Object)"changeLog"));
            plugin.setJson(json);
            for (PluginInfoModule module : plugin.getModules()) {
                module.run(plugin);
            }
        }
        catch (IOException ex) {
            String er = ex.getMessage();
            logger.log(Level.FINE, "Connection with Songoda servers failed: " + (er.contains("URL") ? er.substring(0, er.indexOf("URL") + 3) : er));
        }
        catch (ParseException ex) {
            logger.log(Level.FINE, "Failed to parse json for " + plugin.getJavaPlugin().getName() + " update check");
        }
    }

    public static List<PluginInfo> getPlugins() {
        return new ArrayList<PluginInfo>(registeredPlugins);
    }

    public static int getCoreVersion() {
        return 9;
    }

    public static String getCoreLibraryVersion() {
        return coreVersion;
    }

    public static int getUpdaterVersion() {
        return 1;
    }

    public static String getPrefix() {
        return "[SongodaCore] ";
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean isRegistered(String plugin) {
        return registeredPlugins.stream().anyMatch(p -> p.getJavaPlugin().getName().equalsIgnoreCase(plugin));
    }

    public static JavaPlugin getHijackedPlugin() {
        return INSTANCE == null ? null : SongodaCore.INSTANCE.piggybackedPlugin;
    }

    public static SongodaCore getInstance() {
        return INSTANCE;
    }

    private static class ShadedEventListener
    implements Listener {
        boolean via = Bukkit.getPluginManager().isPluginEnabled("ViaVersion");
        boolean proto = false;

        ShadedEventListener() {
            if (this.via) {
                Bukkit.getOnlinePlayers().forEach(p -> ClientVersion.onLoginVia(p, SongodaCore.getHijackedPlugin()));
                return;
            }
            this.proto = Bukkit.getPluginManager().isPluginEnabled("ProtocolSupport");
            if (this.proto) {
                Bukkit.getOnlinePlayers().forEach(p -> ClientVersion.onLoginProtocol(p, SongodaCore.getHijackedPlugin()));
            }
        }

        @EventHandler
        void onLogin(PlayerLoginEvent event) {
            if (this.via) {
                ClientVersion.onLoginVia(event.getPlayer(), SongodaCore.getHijackedPlugin());
                return;
            }
            if (this.proto) {
                ClientVersion.onLoginProtocol(event.getPlayer(), SongodaCore.getHijackedPlugin());
            }
        }

        @EventHandler
        void onLogout(PlayerQuitEvent event) {
            if (this.via) {
                ClientVersion.onLogout(event.getPlayer());
            }
        }

        @EventHandler
        void onEnable(PluginEnableEvent event) {
            if (!this.via && (this.via = event.getPlugin().getName().equals("ViaVersion"))) {
                Bukkit.getOnlinePlayers().forEach(p -> ClientVersion.onLoginVia(p, SongodaCore.getHijackedPlugin()));
            } else if (!this.proto && (this.proto = event.getPlugin().getName().equals("ProtocolSupport"))) {
                Bukkit.getOnlinePlayers().forEach(p -> ClientVersion.onLoginProtocol(p, SongodaCore.getHijackedPlugin()));
            }
        }
    }

    private class EventListener
    implements Listener {
        final HashMap<UUID, Long> lastCheck = new HashMap();

        private EventListener() {
        }

        @EventHandler
        void onLogin(PlayerLoginEvent event) {
            Player player = event.getPlayer();
            long now = System.currentTimeMillis();
            Long last = this.lastCheck.get(player.getUniqueId());
            if (last != null && now - 10000L < last) {
                return;
            }
            this.lastCheck.put(player.getUniqueId(), now);
            if (!event.getPlayer().isOp() && !player.hasPermission("songoda.updatecheck")) {
                return;
            }
            for (PluginInfo plugin : SongodaCore.getPlugins()) {
                if (plugin.getNotification() == null || !plugin.getJavaPlugin().isEnabled()) continue;
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin.getJavaPlugin(), () -> player.sendMessage("[" + plugin.getJavaPlugin().getName() + "] " + plugin.getNotification()), 10L);
            }
        }

        @EventHandler
        void onDisable(PluginDisableEvent event) {
            PluginInfo pi = registeredPlugins.stream().filter(p -> event.getPlugin() == p.getJavaPlugin()).findFirst().orElse(null);
            if (pi != null) {
                registeredPlugins.remove(pi);
            }
            if (event.getPlugin() == SongodaCore.this.piggybackedPlugin) {
                Bukkit.getServicesManager().unregisterAll((Plugin)SongodaCore.this.piggybackedPlugin);
                pi = registeredPlugins.stream().findFirst().orElse(null);
                if (pi != null) {
                    SongodaCore.this.piggybackedPlugin = pi.getJavaPlugin();
                    Bukkit.getServicesManager().register(SongodaCore.class, (Object)INSTANCE, (Plugin)SongodaCore.this.piggybackedPlugin, ServicePriority.Normal);
                    Bukkit.getPluginManager().registerEvents((Listener)SongodaCore.this.loginListener, (Plugin)SongodaCore.this.piggybackedPlugin);
                    Bukkit.getPluginManager().registerEvents((Listener)SongodaCore.this.shadingListener, (Plugin)SongodaCore.this.piggybackedPlugin);
                    CommandManager.registerCommandDynamically((Plugin)SongodaCore.this.piggybackedPlugin, "songoda", SongodaCore.this.commandManager, SongodaCore.this.commandManager);
                }
            }
        }
    }
}

