/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core;

import com.songoda.ultimatetimber.core.SongodaCore;
import com.songoda.ultimatetimber.core.configuration.Config;
import com.songoda.ultimatetimber.core.database.DataManagerAbstract;
import com.songoda.ultimatetimber.core.locale.Locale;
import com.songoda.ultimatetimber.core.third_party.de.tr7zw.nbtapi.utils.MinecraftVersion;
import com.songoda.ultimatetimber.core.utils.Metrics;
import com.songoda.ultimatetimber.core.utils.SongodaAuth;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SongodaPlugin
extends JavaPlugin {
    protected Locale locale;
    protected Config config = new Config((Plugin)this);
    protected long dataLoadDelay = 20L;
    protected ConsoleCommandSender console = Bukkit.getConsoleSender();
    private boolean emergencyStop = false;

    public abstract void onPluginLoad();

    public abstract void onPluginEnable();

    public abstract void onPluginDisable();

    public abstract void onDataLoad();

    public abstract void onConfigReload();

    public abstract List<Config> getExtraConfig();

    public FileConfiguration getConfig() {
        return this.config.getFileConfig();
    }

    public Config getCoreConfig() {
        return this.config;
    }

    public void reloadConfig() {
        this.config.load();
        this.onConfigReload();
    }

    public void saveConfig() {
        this.config.save();
    }

    public final void onLoad() {
        try {
            this.onPluginLoad();
        }
        catch (Throwable th) {
            this.criticalErrorOnPluginStartup(th);
        }
    }

    public final void onEnable() {
        if (this.emergencyStop) {
            this.setEnabled(false);
            return;
        }
        if (!SongodaAuth.isAuthorized(true)) {
            Thread thread = new Thread(() -> {
                this.console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                this.console.sendMessage(ChatColor.RED + "You do not have access to this plugin.");
                this.console.sendMessage(ChatColor.YELLOW + "Please purchase a license at https://sngda.to/marketplace");
                this.console.sendMessage(ChatColor.YELLOW + "or set up your license at https://sngda.to/licenses");
                this.console.sendMessage(ChatColor.YELLOW + "License setup steps:");
                this.console.sendMessage(ChatColor.YELLOW + "Visit the link mentioned above and click the 'Create License button'");
                this.console.sendMessage(ChatColor.YELLOW + "Copy the following ip and uuid and click create.");
                this.console.sendMessage(ChatColor.YELLOW + "IP: " + SongodaAuth.getIP());
                this.console.sendMessage(ChatColor.YELLOW + "UUID: " + SongodaAuth.getUUID());
                this.console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            });
            thread.start();
            this.emergencyStop();
            return;
        }
        this.console.sendMessage(" ");
        this.console.sendMessage(ChatColor.GREEN + "=============================");
        this.console.sendMessage(String.format("%s%s %s by %sSongoda <3!", ChatColor.GRAY, this.getDescription().getName(), this.getDescription().getVersion(), ChatColor.DARK_PURPLE));
        this.console.sendMessage(String.format("%sAction: %s%s%s...", ChatColor.GRAY, ChatColor.GREEN, "Enabling", ChatColor.GRAY));
        try {
            this.locale = Locale.loadDefaultLocale(this, "en_US");
            this.onPluginEnable();
            Bukkit.getScheduler().runTaskLater((Plugin)this, this::onDataLoad, this.dataLoadDelay);
            if (this.emergencyStop) {
                this.console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                this.console.sendMessage(" ");
                return;
            }
            Metrics.start((Plugin)this);
        }
        catch (Throwable th) {
            this.criticalErrorOnPluginStartup(th);
            this.console.sendMessage(ChatColor.RED + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            this.console.sendMessage(" ");
            return;
        }
        this.console.sendMessage(ChatColor.GREEN + "=============================");
        this.console.sendMessage(" ");
    }

    public final void onDisable() {
        if (this.emergencyStop) {
            return;
        }
        this.console.sendMessage(" ");
        this.console.sendMessage(ChatColor.GREEN + "=============================");
        this.console.sendMessage(String.format("%s%s %s by %sSongoda <3!", ChatColor.GRAY, this.getDescription().getName(), this.getDescription().getVersion(), ChatColor.DARK_PURPLE));
        this.console.sendMessage(String.format("%sAction: %s%s%s...", ChatColor.GRAY, ChatColor.RED, "Disabling", ChatColor.GRAY));
        this.onPluginDisable();
        this.console.sendMessage(ChatColor.GREEN + "=============================");
        this.console.sendMessage(" ");
    }

    public ConsoleCommandSender getConsole() {
        return this.console;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean setLocale(String localeName, boolean reload) {
        if (this.locale != null && this.locale.getName().equals(localeName)) {
            return !reload || this.locale.reloadMessages();
        }
        Locale l = Locale.loadLocale(this, localeName);
        if (l != null) {
            this.locale = l;
            return true;
        }
        return false;
    }

    protected void shutdownDataManager(DataManagerAbstract dataManager) {
        this.shutdownDataManager(dataManager, 15, TimeUnit.MINUTES.toSeconds(3L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownDataManager(DataManagerAbstract dataManager, int reportInterval, long secondsUntilForceShutdown) {
        int unfinishedTasks;
        dataManager.shutdownTaskQueue();
        while (!dataManager.isTaskQueueTerminated() && secondsUntilForceShutdown > 0L) {
            long secondsToWait = Math.min((long)reportInterval, secondsUntilForceShutdown);
            try {
                if (dataManager.waitForShutdown(secondsToWait, TimeUnit.SECONDS)) break;
                this.getLogger().info(String.format("A DataManager is currently working on %d tasks... We are giving him another %d seconds until we forcefully shut him down (continuing to report in %d second intervals)", dataManager.getTaskQueueSize(), secondsUntilForceShutdown, reportInterval));
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                secondsUntilForceShutdown -= secondsToWait;
            }
        }
        if (!dataManager.isTaskQueueTerminated() && (unfinishedTasks = dataManager.forceShutdownTaskQueue().size()) > 0) {
            this.getLogger().log(Level.WARNING, String.format("A DataManager has been forcefully terminated with %d unfinished tasks - This can be a serious problem, please report it to us (Songoda)!", unfinishedTasks));
        }
    }

    protected void emergencyStop() {
        this.emergencyStop = true;
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    protected void criticalErrorOnPluginStartup(Throwable th) {
        Bukkit.getLogger().log(Level.SEVERE, String.format("Unexpected error while loading %s v%s c%s: Disabling plugin!", this.getDescription().getName(), this.getDescription().getVersion(), SongodaCore.getCoreLibraryVersion()), th);
        this.emergencyStop();
    }

    static {
        MinecraftVersion.getLogger().setLevel(Level.WARNING);
        MinecraftVersion.disableUpdateCheck();
    }
}

