/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.songoda.ultimatetimber.core.chat.ColorCode;
import com.songoda.ultimatetimber.core.chat.ColorContainer;
import com.songoda.ultimatetimber.core.compatibility.ClassMapping;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.core.nms.NmsManager;
import com.songoda.ultimatetimber.core.utils.TextUtils;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatMessage {
    private static final Gson gson = new GsonBuilder().create();
    private final List<JsonObject> textList = new ArrayList<JsonObject>();
    private static boolean enabled = ServerVersion.isServerVersionAtLeast(ServerVersion.V1_8);
    private static Class<?> mc_ChatMessageType;
    private static Method mc_IChatBaseComponent_ChatSerializer_a;
    private static Method cb_craftPlayer_getHandle;
    private static Constructor mc_PacketPlayOutChat_new;
    private static Field mc_entityPlayer_playerConnection;
    private static Field mc_chatMessageType_Chat;
    private static boolean mc_PacketPlayOutChat_new_1_19_0;

    public void clear() {
        this.textList.clear();
    }

    public ChatMessage fromText(String text) {
        return this.fromText(text, false);
    }

    public ChatMessage fromText(String text, boolean noHex) {
        Pattern pattern = Pattern.compile("(.*?)(?!&([omnlk]))(?=(&([123456789abcdefr#])|$)|#([a-f]|[A-F]|[0-9]){6})", 2);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            ColorContainer color = null;
            String match1 = matcher.group(1);
            if (matcher.groupCount() == 0 || match1.length() == 0) continue;
            int colorChar = 45;
            if (matcher.start() != 0) {
                colorChar = text.substring(matcher.start() - 1, matcher.start()).charAt(0);
            }
            if (colorChar != 45) {
                if (colorChar == 35) {
                    color = new ColorContainer(match1.substring(0, 6), noHex);
                    match1 = match1.substring(5);
                } else if (colorChar == 38) {
                    color = new ColorContainer(ColorCode.getByChar(Character.toLowerCase(match1.charAt(0))));
                }
            }
            Pattern subPattern = Pattern.compile("(.*?)(?=&([omnlk])|$)");
            Matcher subMatcher = subPattern.matcher(match1);
            ArrayList<ColorCode> stackedCodes = new ArrayList<ColorCode>();
            while (subMatcher.find()) {
                String match2 = subMatcher.group(1);
                if (match2.length() == 0) continue;
                ColorCode code = ColorCode.getByChar(Character.toLowerCase(match2.charAt(0)));
                if (code != null && code != ColorCode.RESET) {
                    stackedCodes.add(code);
                }
                if (color != null) {
                    match2 = match2.substring(1);
                }
                if (match2.length() == 0) continue;
                this.addMessage(match2, color, stackedCodes);
            }
        }
        return this;
    }

    public String toText() {
        return this.toText(false);
    }

    public String toText(boolean noHex) {
        StringBuilder text = new StringBuilder();
        for (JsonObject object : this.textList) {
            if (object.has("color")) {
                String color = object.get("color").getAsString();
                text.append("&");
                if (color.length() == 7) {
                    text.append(new ColorContainer(color, noHex).getColor().getCode());
                } else {
                    text.append(ColorCode.valueOf(color.toUpperCase()).getCode());
                }
            }
            for (ColorCode code : ColorCode.values()) {
                String c;
                if (code.isColor() || !object.has(c = code.name().toLowerCase()) || !object.get(c).getAsBoolean()) continue;
                text.append("&").append(code.getCode());
            }
            text.append(object.get("text").getAsString());
        }
        return text.toString();
    }

    public ChatMessage addMessage(String s) {
        JsonObject txt = new JsonObject();
        txt.addProperty("text", s);
        this.textList.add(txt);
        return this;
    }

    public ChatMessage addMessage(String text, ColorContainer color) {
        return this.addMessage(text, color, Collections.emptyList());
    }

    public ChatMessage addMessage(String text, ColorContainer color, List<ColorCode> colorCodes) {
        JsonObject txt = new JsonObject();
        txt.addProperty("text", text);
        if (color != null) {
            txt.addProperty("color", color.getHexCode() != null ? "#" + color.getHexCode() : color.getColorCode().name().toLowerCase());
        }
        for (ColorCode code : ColorCode.values()) {
            if (code.isColor()) continue;
            txt.addProperty(code.name().toLowerCase(), Boolean.valueOf(colorCodes.contains((Object)code)));
        }
        this.textList.add(txt);
        return this;
    }

    public ChatMessage addRunCommand(String text, String hoverText, String cmd) {
        JsonObject txt = new JsonObject();
        txt.addProperty("text", text);
        JsonObject hover = new JsonObject();
        hover.addProperty("action", "show_text");
        hover.addProperty("value", hoverText);
        txt.add("hoverEvent", (JsonElement)hover);
        JsonObject click = new JsonObject();
        click.addProperty("action", "run_command");
        click.addProperty("value", cmd);
        txt.add("clickEvent", (JsonElement)click);
        this.textList.add(txt);
        return this;
    }

    public ChatMessage addPromptCommand(String text, String hoverText, String cmd) {
        JsonObject txt = new JsonObject();
        txt.addProperty("text", text);
        JsonObject hover = new JsonObject();
        hover.addProperty("action", "show_text");
        hover.addProperty("value", hoverText);
        txt.add("hoverEvent", (JsonElement)hover);
        JsonObject click = new JsonObject();
        click.addProperty("action", "suggest_command");
        click.addProperty("value", cmd);
        txt.add("clickEvent", (JsonElement)click);
        this.textList.add(txt);
        return this;
    }

    public ChatMessage addURL(String text, String hoverText, String url) {
        JsonObject txt = new JsonObject();
        txt.addProperty("text", text);
        JsonObject hover = new JsonObject();
        hover.addProperty("action", "show_text");
        hover.addProperty("value", hoverText);
        txt.add("hoverEvent", (JsonElement)hover);
        JsonObject click = new JsonObject();
        click.addProperty("action", "open_url");
        click.addProperty("value", url);
        txt.add("clickEvent", (JsonElement)hover);
        this.textList.add(txt);
        return this;
    }

    public String toString() {
        return gson.toJson(this.textList);
    }

    public void sendTo(CommandSender sender) {
        this.sendTo(null, sender);
    }

    public void sendTo(ChatMessage prefix, CommandSender sender) {
        if (sender instanceof Player && enabled) {
            try {
                ArrayList<JsonObject> textList = prefix == null ? new ArrayList<JsonObject>() : new ArrayList<JsonObject>(prefix.textList);
                textList.addAll(this.textList);
                Object packet = ServerVersion.isServerVersionAtLeast(ServerVersion.V1_19) ? mc_PacketPlayOutChat_new.newInstance(mc_IChatBaseComponent_ChatSerializer_a.invoke(null, gson.toJson(textList)), mc_PacketPlayOutChat_new_1_19_0 ? (Constable)Integer.valueOf(1) : (Constable)Boolean.valueOf(true)) : (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_16) ? mc_PacketPlayOutChat_new.newInstance(mc_IChatBaseComponent_ChatSerializer_a.invoke(null, gson.toJson(textList)), mc_chatMessageType_Chat.get(null), ((Player)sender).getUniqueId()) : mc_PacketPlayOutChat_new.newInstance(mc_IChatBaseComponent_ChatSerializer_a.invoke(null, gson.toJson(textList))));
                NmsManager.getPlayer().sendPacket((Player)sender, packet);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Problem preparing raw chat packets (disabling further packets)", ex);
                enabled = false;
            }
            return;
        }
        sender.sendMessage(TextUtils.formatText((prefix == null ? "" : prefix.toText(true) + " ") + this.toText(true)));
    }

    static void init() {
        if (enabled) {
            try {
                Class<?> mc_PacketPlayOutChat;
                String version = ServerVersion.getServerVersionString();
                Class<?> cb_craftPlayerClazz = ClassMapping.CRAFT_PLAYER.getClazz();
                cb_craftPlayer_getHandle = cb_craftPlayerClazz.getDeclaredMethod("getHandle", new Class[0]);
                Class<?> mc_entityPlayerClazz = ClassMapping.ENTITY_PLAYER.getClazz();
                mc_entityPlayer_playerConnection = mc_entityPlayerClazz.getDeclaredField(ServerVersion.isServerVersionAtLeast(ServerVersion.V1_17) ? "b" : "playerConnection");
                Class<?> mc_IChatBaseComponent = ClassMapping.I_CHAT_BASE_COMPONENT.getClazz();
                Class<?> mc_IChatBaseComponent_ChatSerializer = ClassMapping.I_CHAT_BASE_COMPONENT.getClazz("ChatSerializer");
                mc_IChatBaseComponent_ChatSerializer_a = mc_IChatBaseComponent_ChatSerializer.getMethod("a", String.class);
                Class<?> clazz = mc_PacketPlayOutChat = ServerVersion.isServerVersionAtLeast(ServerVersion.V1_19) ? ClassMapping.CLIENTBOUND_SYSTEM_CHAT.getClazz() : ClassMapping.PACKET_PLAY_OUT_CHAT.getClazz();
                if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_19)) {
                    try {
                        mc_PacketPlayOutChat_new = mc_PacketPlayOutChat.getConstructor(mc_IChatBaseComponent, Boolean.TYPE);
                    }
                    catch (NoSuchMethodException ex) {
                        mc_PacketPlayOutChat_new = mc_PacketPlayOutChat.getConstructor(mc_IChatBaseComponent, Integer.TYPE);
                        mc_PacketPlayOutChat_new_1_19_0 = true;
                    }
                } else if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_16)) {
                    mc_ChatMessageType = ClassMapping.CHAT_MESSAGE_TYPE.getClazz();
                    mc_chatMessageType_Chat = mc_ChatMessageType.getField(ServerVersion.isServerVersionAtLeast(ServerVersion.V1_17) ? "a" : "CHAT");
                    mc_PacketPlayOutChat_new = mc_PacketPlayOutChat.getConstructor(mc_IChatBaseComponent, mc_ChatMessageType, UUID.class);
                } else {
                    mc_PacketPlayOutChat_new = mc_PacketPlayOutChat.getConstructor(mc_IChatBaseComponent);
                }
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(Level.WARNING, "Problem preparing raw chat packets (disabling further packets)", ex);
                enabled = false;
            }
        }
    }

    public ChatMessage replaceAll(String toReplace, String replaceWith) {
        for (JsonObject object : this.textList) {
            String text = object.get("text").getAsString().replaceAll(toReplace, replaceWith);
            object.remove("text");
            object.addProperty("text", text);
        }
        return this;
    }

    static {
        mc_PacketPlayOutChat_new_1_19_0 = false;
        ChatMessage.init();
    }
}

