/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.commands;

import com.songoda.ultimatetimber.core.commands.AbstractCommand;
import com.songoda.ultimatetimber.core.commands.MainCommand;
import com.songoda.ultimatetimber.core.commands.SimpleNestedCommand;
import com.songoda.ultimatetimber.core.compatibility.ServerProject;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final HashMap<String, SimpleNestedCommand> commands = new HashMap();
    private String msg_noConsole = ChatColor.RED + "You must be a player to use this command.";
    private String msg_noPerms = ChatColor.RED + "You do not have permission to do that.";
    private String msg_noCommand = ChatColor.GRAY + "The command you entered does not exist or is spelt incorrectly.";
    private List<String> msg_syntaxError = Arrays.asList(ChatColor.RED + "Invalid Syntax!", ChatColor.GRAY + "The valid syntax is: " + ChatColor.GOLD + "%syntax%" + ChatColor.GRAY + ".");
    private boolean allowLooseCommands = false;

    public CommandManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void setNoConsoleMessage(String msg_noConsole) {
        this.msg_noConsole = msg_noConsole;
    }

    public void setNoPermsMessage(String msg_noPerms) {
        this.msg_noPerms = msg_noPerms;
    }

    public void setNoCommandMessage(String msg_noCommand) {
        this.msg_noCommand = msg_noCommand;
    }

    public void setSyntaxErrorMessage(List<String> msg_syntaxError) {
        this.msg_syntaxError = msg_syntaxError;
    }

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public List<String> getSubCommands(String command) {
        SimpleNestedCommand nested;
        SimpleNestedCommand simpleNestedCommand = nested = command == null ? null : this.commands.get(command.toLowerCase());
        if (nested == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(nested.children.keySet());
    }

    public Set<AbstractCommand> getAllCommands() {
        HashSet<AbstractCommand> all = new HashSet<AbstractCommand>();
        this.commands.values().stream().filter(c -> c.parent != null && !all.contains(c.parent)).forEach(c -> {
            all.add(c.parent);
            c.children.values().stream().filter(s -> !all.contains(s)).forEach(all::add);
        });
        return all;
    }

    public CommandManager registerCommandDynamically(String command) {
        CommandManager.registerCommandDynamically((Plugin)this.plugin, command, this, this);
        return this;
    }

    public SimpleNestedCommand registerCommandDynamically(AbstractCommand abstractCommand) {
        SimpleNestedCommand nested = new SimpleNestedCommand(abstractCommand);
        abstractCommand.getCommands().forEach(cmd -> {
            CommandManager.registerCommandDynamically((Plugin)this.plugin, cmd, this, this);
            this.commands.put(cmd.toLowerCase(), nested);
            PluginCommand pcmd = this.plugin.getCommand(cmd);
            if (pcmd != null) {
                pcmd.setExecutor((CommandExecutor)this);
                pcmd.setTabCompleter((TabCompleter)this);
            } else {
                this.plugin.getLogger().warning("Failed to register command: /" + cmd);
            }
        });
        return nested;
    }

    public SimpleNestedCommand addCommand(AbstractCommand abstractCommand) {
        SimpleNestedCommand nested = new SimpleNestedCommand(abstractCommand);
        abstractCommand.getCommands().forEach(cmd -> {
            this.commands.put(cmd.toLowerCase(), nested);
            PluginCommand pcmd = this.plugin.getCommand(cmd);
            if (pcmd == null) {
                this.plugin.getLogger().warning("Failed to register command: /" + cmd);
                return;
            }
            pcmd.setExecutor((CommandExecutor)this);
            pcmd.setTabCompleter((TabCompleter)this);
        });
        return nested;
    }

    public MainCommand addMainCommand(String command) {
        MainCommand nested = new MainCommand((Plugin)this.plugin, command);
        this.commands.put(command.toLowerCase(), nested.nestedCommands);
        PluginCommand pcmd = this.plugin.getCommand(command);
        if (pcmd != null) {
            pcmd.setExecutor((CommandExecutor)this);
            pcmd.setTabCompleter((TabCompleter)this);
        } else {
            this.plugin.getLogger().warning("Failed to register command: /" + command);
        }
        return nested;
    }

    public MainCommand getMainCommand(String command) {
        SimpleNestedCommand nested;
        SimpleNestedCommand simpleNestedCommand = nested = command == null ? null : this.commands.get(command.toLowerCase());
        if (nested != null && nested.parent instanceof MainCommand) {
            return (MainCommand)nested.parent;
        }
        return null;
    }

    public CommandManager addCommands(AbstractCommand ... abstractCommands) {
        for (AbstractCommand abstractCommand : abstractCommands) {
            this.addCommand(abstractCommand);
        }
        return this;
    }

    public CommandManager setExecutor(String command) {
        PluginCommand pcmd;
        PluginCommand pluginCommand = pcmd = command == null ? null : this.plugin.getCommand(command);
        if (pcmd != null) {
            pcmd.setExecutor((CommandExecutor)this);
        } else {
            this.plugin.getLogger().warning("Failed to register command: /" + command);
        }
        return this;
    }

    public CommandManager setUseClosestCommand(boolean bool) {
        this.allowLooseCommands = bool;
        return this;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String label, String[] args) {
        SimpleNestedCommand nested = this.commands.get(command.getName().toLowerCase());
        if (nested != null) {
            String subCmd;
            if (args.length != 0 && !nested.children.isEmpty() && (subCmd = this.getSubCommand(nested, args)) != null) {
                AbstractCommand sub = nested.children.get(subCmd);
                int i = subCmd.indexOf(32) == -1 ? 1 : 2;
                String[] newArgs = new String[args.length - i];
                System.arraycopy(args, i, newArgs, 0, newArgs.length);
                this.processRequirements(sub, commandSender, newArgs);
                return true;
            }
            if (nested.parent != null) {
                this.processRequirements(nested.parent, commandSender, args);
                return true;
            }
        }
        commandSender.sendMessage(this.msg_noCommand);
        return true;
    }

    private String getSubCommand(SimpleNestedCommand nested, String[] args) {
        String cmd = args[0].toLowerCase();
        if (nested.children.containsKey(cmd)) {
            return cmd;
        }
        String match = null;
        if (args.length >= 2 && nested.children.keySet().stream().anyMatch(k -> k.indexOf(32) != -1)) {
            for (int len = args.length; len > 1; --len) {
                String cmd2 = String.join((CharSequence)" ", Arrays.copyOf(args, len)).toLowerCase();
                if (!nested.children.containsKey(cmd2)) continue;
                return cmd2;
            }
        }
        if (this.allowLooseCommands) {
            int count = 0;
            for (String c : nested.children.keySet()) {
                if (!c.startsWith(cmd)) continue;
                match = c;
                if (++count <= 1) continue;
                match = null;
                break;
            }
        }
        return match;
    }

    private void processRequirements(AbstractCommand command, CommandSender sender, String[] args) {
        if (!(sender instanceof Player) && command.isNoConsole()) {
            sender.sendMessage(this.msg_noConsole);
            return;
        }
        if (command.getPermissionNode() == null || sender.hasPermission(command.getPermissionNode())) {
            AbstractCommand.ReturnType returnType = command.runCommand(sender, args);
            if (returnType == AbstractCommand.ReturnType.NEEDS_PLAYER) {
                sender.sendMessage(this.msg_noConsole);
                return;
            }
            if (returnType == AbstractCommand.ReturnType.SYNTAX_ERROR) {
                for (String s : this.msg_syntaxError) {
                    sender.sendMessage(s.replace("%syntax%", command.getSyntax()));
                }
            }
            return;
        }
        sender.sendMessage(this.msg_noPerms);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        SimpleNestedCommand nested = this.commands.get(command.getName().toLowerCase());
        if (nested != null) {
            AbstractCommand sub;
            boolean console;
            if (args.length == 0 || nested.children.isEmpty()) {
                return nested.parent != null ? nested.parent.onTab(sender, args) : null;
            }
            boolean op = sender.isOp();
            boolean bl = console = !(sender instanceof Player);
            if (args.length == 1) {
                String arg = args[0].toLowerCase();
                return nested.children.entrySet().stream().filter(e -> !console || !((AbstractCommand)e.getValue()).isNoConsole()).filter(e -> ((String)e.getKey()).startsWith(arg)).filter(e -> op || ((AbstractCommand)e.getValue()).getPermissionNode() == null || sender.hasPermission(((AbstractCommand)e.getValue()).getPermissionNode())).map(Map.Entry::getKey).collect(Collectors.toList());
            }
            String subCmd = this.getSubCommand(nested, args);
            if (!(subCmd == null || (sub = nested.children.get(subCmd)) == null || console && sub.isNoConsole() || !op && sub.getPermissionNode() != null && !sender.hasPermission(sub.getPermissionNode()))) {
                int i = subCmd.indexOf(32) == -1 ? 1 : 2;
                String[] newArgs = new String[args.length - i];
                System.arraycopy(args, i, newArgs, 0, newArgs.length);
                return this.fetchList(sub, newArgs, sender);
            }
        }
        return Collections.emptyList();
    }

    private List<String> fetchList(AbstractCommand abstractCommand, String[] args, CommandSender sender) {
        List<String> list = abstractCommand.onTab(sender, args);
        if (args.length != 0) {
            String str = args[args.length - 1];
            if (list != null && str != null && str.length() >= 1) {
                try {
                    list.removeIf(s -> !s.toLowerCase().startsWith(str.toLowerCase()));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public static void registerCommandDynamically(Plugin plugin, String command, CommandExecutor executor, TabCompleter tabManager) {
        try {
            Class<?> clazzCraftServer = Bukkit.getServer().getClass();
            Object craftServer = clazzCraftServer.cast(Bukkit.getServer());
            SimpleCommandMap commandMap = (SimpleCommandMap)craftServer.getClass().getDeclaredMethod("getCommandMap", new Class[0]).invoke(craftServer, new Object[0]);
            Constructor constructorPluginCommand = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructorPluginCommand.setAccessible(true);
            PluginCommand commandObject = (PluginCommand)constructorPluginCommand.newInstance(command, plugin);
            if (ServerProject.isServer(ServerProject.PAPER, ServerProject.TACO) && ServerVersion.isServerVersionBelow(ServerVersion.V1_9)) {
                Class<?> clazz = Class.forName("co.aikar.timings.TimingsManager");
                Method method = clazz.getMethod("getCommandTiming", String.class, Command.class);
                Field field = PluginCommand.class.getField("timings");
                field.set(commandObject, method.invoke(null, plugin.getName().toLowerCase(), commandObject));
            }
            commandObject.setExecutor(executor);
            commandObject.setTabCompleter(tabManager);
            Field fieldKnownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            fieldKnownCommands.setAccessible(true);
            Map knownCommands = (Map)fieldKnownCommands.get(commandMap);
            knownCommands.put(command, commandObject);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }
}

