/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.compatibility;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum CompatibleHand {
    MAIN_HAND,
    OFF_HAND;

    private static final Map<String, Method> methodCache;

    public static CompatibleHand getHand(Object event) {
        try {
            Method method;
            Class<?> clazz = event.getClass();
            String className = clazz.getName();
            if (methodCache.containsKey(className)) {
                method = methodCache.get(className);
            } else {
                method = clazz.getDeclaredMethod("getHand", new Class[0]);
                methodCache.put(className, method);
            }
            EquipmentSlot slot = (EquipmentSlot)method.invoke(event, new Object[0]);
            if (slot == EquipmentSlot.OFF_HAND) {
                return OFF_HAND;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return MAIN_HAND;
    }

    public static CompatibleHand getHand(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.HAND ? MAIN_HAND : OFF_HAND;
    }

    public void takeItem(Player player) {
        this.takeItem(player, 1);
    }

    public void takeItem(Player player, int amount) {
        ItemStack item = this == MAIN_HAND ? player.getInventory().getItemInHand() : player.getInventory().getItemInOffHand();
        int result = item.getAmount() - amount;
        item.setAmount(result);
        if (this == MAIN_HAND) {
            player.setItemInHand((ItemStack)(result > 0 ? item : null));
            return;
        }
        player.getInventory().setItemInOffHand((ItemStack)(result > 0 ? item : null));
    }

    public ItemStack getItem(Player player) {
        if (this == MAIN_HAND) {
            return player.getItemInHand();
        }
        return player.getInventory().getItemInOffHand();
    }

    public void setItem(Player player, ItemStack item) {
        if (this == MAIN_HAND) {
            player.setItemInHand(item);
            return;
        }
        player.getInventory().setItemInOffHand(item);
    }

    static {
        methodCache = new HashMap<String, Method>();
    }
}

