/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.configuration;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.configuration.Comment;
import com.songoda.ultimatetimber.core.configuration.ConfigFormattingRules;
import com.songoda.ultimatetimber.core.configuration.ConfigOptionsAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemoryConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigSection
extends MemoryConfiguration {
    final String fullPath;
    final String nodeKey;
    final ConfigSection root;
    final ConfigSection parent;
    protected int indentation = 2;
    protected char pathChar = (char)46;
    final HashMap<String, Comment> configComments;
    final HashMap<String, Comment> defaultComments;
    final LinkedHashMap<String, Object> defaults;
    final LinkedHashMap<String, Object> values;
    boolean changed = false;
    final boolean isDefault;
    final Object lock = new Object();

    ConfigSection() {
        this.root = this;
        this.parent = null;
        this.isDefault = false;
        this.fullPath = "";
        this.nodeKey = "";
        this.configComments = new HashMap();
        this.defaultComments = new HashMap();
        this.defaults = new LinkedHashMap();
        this.values = new LinkedHashMap();
    }

    ConfigSection(ConfigSection root, ConfigSection parent, String nodeKey, boolean isDefault) {
        this.root = root;
        this.parent = parent;
        this.nodeKey = nodeKey;
        this.fullPath = nodeKey != null ? parent.fullPath + nodeKey + root.pathChar : parent.fullPath;
        this.isDefault = isDefault;
        this.defaultComments = null;
        this.configComments = null;
        this.defaults = null;
        this.values = null;
    }

    public int getIndent() {
        return this.root.indentation;
    }

    public void setIndent(int indentation) {
        this.root.indentation = indentation;
    }

    protected void onChange() {
        if (this.parent != null) {
            this.root.onChange();
        }
    }

    public void setPathSeparator(char pathChar) {
        if (!this.root.values.isEmpty() || !this.root.defaults.isEmpty()) {
            throw new RuntimeException("Path change after config initialization");
        }
        this.root.pathChar = pathChar;
    }

    public char getPathSeparator() {
        return this.root.pathChar;
    }

    public String getKey() {
        return !this.fullPath.endsWith(String.valueOf(this.root.pathChar)) ? this.fullPath : this.fullPath.substring(0, this.fullPath.length() - 1);
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNodePath(@NotNull String path, boolean useDefault) {
        if (path.indexOf(this.root.pathChar) != -1) {
            String[] pathParts = path.split(Pattern.quote(String.valueOf(this.root.pathChar)));
            StringBuilder nodePath = new StringBuilder(this.fullPath);
            LinkedHashMap<String, Object> writeTo = useDefault ? this.root.defaults : this.root.values;
            ConfigSection travelNode = this;
            Object object = this.root.lock;
            synchronized (object) {
                for (int i = 0; i < pathParts.length - 1; ++i) {
                    String node = (i != 0 ? nodePath.append(this.root.pathChar) : nodePath).append(pathParts[i]).toString();
                    if (!(writeTo.get(node) instanceof ConfigSection)) {
                        travelNode = new ConfigSection(this.root, travelNode, pathParts[i], useDefault);
                        writeTo.put(node, (Object)travelNode);
                        continue;
                    }
                    travelNode = (ConfigSection)((Object)writeTo.get(node));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createDefaultSection(@NotNull String path) {
        this.createNodePath(path, true);
        ConfigSection section = new ConfigSection(this.root, this, path, true);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaults.put(this.fullPath + path, (Object)section);
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createDefaultSection(@NotNull String path, String ... comment) {
        this.createNodePath(path, true);
        ConfigSection section = new ConfigSection(this.root, this, path, true);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaults.put(this.fullPath + path, (Object)section);
            this.root.defaultComments.put(this.fullPath + path, new Comment(comment));
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createDefaultSection(@NotNull String path, ConfigFormattingRules.CommentStyle commentStyle, String ... comment) {
        this.createNodePath(path, true);
        ConfigSection section = new ConfigSection(this.root, this, path, true);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaults.put(this.fullPath + path, (Object)section);
            this.root.defaultComments.put(this.fullPath + path, new Comment(commentStyle, comment));
        }
        return section;
    }

    @NotNull
    public ConfigSection setComment(@NotNull String path, @Nullable ConfigFormattingRules.CommentStyle commentStyle, String ... lines) {
        return this.setComment(path, lines != null ? new Comment(commentStyle, lines) : null);
    }

    @NotNull
    public ConfigSection setComment(@NotNull String path, @Nullable ConfigFormattingRules.CommentStyle commentStyle, @Nullable List<String> lines) {
        return this.setComment(path, lines != null ? new Comment(commentStyle, lines) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection setComment(@NotNull String path, @Nullable Comment comment) {
        Object object = this.root.lock;
        synchronized (object) {
            if (this.isDefault) {
                this.root.defaultComments.put(this.fullPath + path, comment);
            } else {
                this.root.configComments.put(this.fullPath + path, comment);
            }
        }
        return this;
    }

    @NotNull
    public ConfigSection setDefaultComment(@NotNull String path, String ... lines) {
        return this.setDefaultComment(path, lines.length == 0 ? null : Arrays.asList(lines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection setDefaultComment(@NotNull String path, @Nullable List<String> lines) {
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaultComments.put(this.fullPath + path, new Comment(lines));
        }
        return this;
    }

    @NotNull
    public ConfigSection setDefaultComment(@NotNull String path, ConfigFormattingRules.CommentStyle commentStyle, String ... lines) {
        return this.setDefaultComment(path, commentStyle, lines.length == 0 ? null : Arrays.asList(lines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection setDefaultComment(@NotNull String path, ConfigFormattingRules.CommentStyle commentStyle, @Nullable List<String> lines) {
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaultComments.put(this.fullPath + path, new Comment(commentStyle, lines));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection setDefaultComment(@NotNull String path, @Nullable Comment comment) {
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaultComments.put(this.fullPath + path, comment);
        }
        return this;
    }

    @Nullable
    public Comment getComment(@NotNull String path) {
        Comment result = this.root.configComments.get(this.fullPath + path);
        if (result == null) {
            result = this.root.defaultComments.get(this.fullPath + path);
        }
        return result;
    }

    @Nullable
    public String getCommentString(@NotNull String path) {
        Comment result = this.root.configComments.get(this.fullPath + path);
        if (result == null) {
            result = this.root.defaultComments.get(this.fullPath + path);
        }
        return result != null ? result.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefault(@NotNull String path, @Nullable Object value) {
        this.createNodePath(path, true);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.defaults.put(this.fullPath + path, value);
        }
    }

    public void addDefaults(@NotNull Map<String, Object> defaults) {
        defaults.entrySet().forEach(m -> this.addDefault((String)m.getKey(), m.getValue()));
    }

    public void setDefaults(Configuration c) {
        if (this.fullPath.isEmpty()) {
            this.root.defaults.clear();
        } else {
            this.root.defaults.keySet().stream().filter(k -> k.startsWith(this.fullPath)).forEach(this.root.defaults::remove);
        }
        this.addDefaults(c);
    }

    public ConfigSection getDefaults() {
        return new ConfigSection(this.root, this, null, true);
    }

    public ConfigSection getDefaultSection() {
        return new ConfigSection(this.root, this, null, true);
    }

    public ConfigOptionsAdapter options() {
        return new ConfigOptionsAdapter(this.root);
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int pathIndex = this.fullPath.lastIndexOf(this.root.pathChar);
        if (deep) {
            result.addAll(this.root.defaults.keySet().stream().filter(k -> k.startsWith(this.fullPath)).map(k -> !k.endsWith(String.valueOf(this.root.pathChar)) ? k.substring(pathIndex + 1) : k.substring(pathIndex + 1, k.length() - 1)).collect(Collectors.toCollection(LinkedHashSet::new)));
            result.addAll(this.root.values.keySet().stream().filter(k -> k.startsWith(this.fullPath)).map(k -> !k.endsWith(String.valueOf(this.root.pathChar)) ? k.substring(pathIndex + 1) : k.substring(pathIndex + 1, k.length() - 1)).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else {
            result.addAll(this.root.defaults.keySet().stream().filter(k -> k.startsWith(this.fullPath) && k.lastIndexOf(this.root.pathChar) == pathIndex).map(k -> !k.endsWith(String.valueOf(this.root.pathChar)) ? k.substring(pathIndex + 1) : k.substring(pathIndex + 1, k.length() - 1)).collect(Collectors.toCollection(LinkedHashSet::new)));
            result.addAll(this.root.values.keySet().stream().filter(k -> k.startsWith(this.fullPath) && k.lastIndexOf(this.root.pathChar) == pathIndex).map(k -> !k.endsWith(String.valueOf(this.root.pathChar)) ? k.substring(pathIndex + 1) : k.substring(pathIndex + 1, k.length() - 1)).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return result;
    }

    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int pathIndex = this.fullPath.lastIndexOf(this.root.pathChar);
        if (deep) {
            result.putAll(this.root.defaults.entrySet().stream().filter(k -> ((String)k.getKey()).startsWith(this.fullPath)).collect(Collectors.toMap(e -> !((String)e.getKey()).endsWith(String.valueOf(this.root.pathChar)) ? ((String)e.getKey()).substring(pathIndex + 1) : ((String)e.getKey()).substring(pathIndex + 1, ((String)e.getKey()).length() - 1), Map.Entry::getValue, (v1, v2) -> {
                throw new IllegalStateException();
            }, LinkedHashMap::new)));
            result.putAll(this.root.values.entrySet().stream().filter(k -> ((String)k.getKey()).startsWith(this.fullPath)).collect(Collectors.toMap(e -> !((String)e.getKey()).endsWith(String.valueOf(this.root.pathChar)) ? ((String)e.getKey()).substring(pathIndex + 1) : ((String)e.getKey()).substring(pathIndex + 1, ((String)e.getKey()).length() - 1), Map.Entry::getValue, (v1, v2) -> {
                throw new IllegalStateException();
            }, LinkedHashMap::new)));
        } else {
            result.putAll(this.root.defaults.entrySet().stream().filter(k -> ((String)k.getKey()).startsWith(this.fullPath) && ((String)k.getKey()).lastIndexOf(this.root.pathChar) == pathIndex).collect(Collectors.toMap(e -> !((String)e.getKey()).endsWith(String.valueOf(this.root.pathChar)) ? ((String)e.getKey()).substring(pathIndex + 1) : ((String)e.getKey()).substring(pathIndex + 1, ((String)e.getKey()).length() - 1), Map.Entry::getValue, (v1, v2) -> {
                throw new IllegalStateException();
            }, LinkedHashMap::new)));
            result.putAll(this.root.values.entrySet().stream().filter(k -> ((String)k.getKey()).startsWith(this.fullPath) && ((String)k.getKey()).lastIndexOf(this.root.pathChar) == pathIndex).collect(Collectors.toMap(e -> !((String)e.getKey()).endsWith(String.valueOf(this.root.pathChar)) ? ((String)e.getKey()).substring(pathIndex + 1) : ((String)e.getKey()).substring(pathIndex + 1, ((String)e.getKey()).length() - 1), Map.Entry::getValue, (v1, v2) -> {
                throw new IllegalStateException();
            }, LinkedHashMap::new)));
        }
        return result;
    }

    @NotNull
    public List<ConfigSection> getSections(String path) {
        ConfigSection rootSection = this.getConfigurationSection(path);
        if (rootSection == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSection> result = new ArrayList<ConfigSection>();
        rootSection.getKeys(false).stream().map(rootSection::get).filter(ConfigSection.class::isInstance).forEachOrdered(object -> result.add((ConfigSection)((Object)((Object)object))));
        return result;
    }

    public boolean contains(@NotNull String path) {
        return this.root.defaults.containsKey(this.fullPath + path) || this.root.values.containsKey(this.fullPath + path);
    }

    public boolean contains(@NotNull String path, boolean ignoreDefault) {
        return !ignoreDefault && this.root.defaults.containsKey(this.fullPath + path) || this.root.values.containsKey(this.fullPath + path);
    }

    public boolean isSet(@NotNull String path) {
        return this.root.defaults.get(this.fullPath + path) != null || this.root.values.get(this.fullPath + path) != null;
    }

    public String getCurrentPath() {
        return this.fullPath.isEmpty() ? "" : this.fullPath.substring(0, this.fullPath.length() - 1);
    }

    public String getName() {
        if (this.fullPath.isEmpty()) {
            return "";
        }
        String[] parts = this.fullPath.split(Pattern.quote(String.valueOf(this.root.pathChar)));
        return parts[parts.length - 1];
    }

    public ConfigSection getRoot() {
        return this.root;
    }

    public ConfigSection getParent() {
        return this.parent;
    }

    @Nullable
    public Object get(@NotNull String path) {
        Object result = this.root.values.get(this.fullPath + path);
        if (result == null) {
            result = this.root.defaults.get(this.fullPath + path);
        }
        return result;
    }

    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        Object result = this.root.values.get(this.fullPath + path);
        return result != null ? result : def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(@NotNull String path, @Nullable Object value) {
        Object last;
        if (this.isDefault) {
            this.addDefault(path, value);
            return;
        }
        this.createNodePath(path, false);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.changed = value != null ? this.root.changed | (last = this.root.values.put(this.fullPath + path, value)) != value : this.root.changed | (last = this.root.values.remove(this.fullPath + path)) != null;
        }
        if (last != value && last instanceof ConfigSection) {
            String trim = this.fullPath + path + this.root.pathChar;
            Object object2 = this.root.lock;
            synchronized (object2) {
                this.root.values.keySet().stream().filter(k -> k.startsWith(trim)).collect(Collectors.toSet()).forEach(this.root.values::remove);
            }
        }
        this.onChange();
    }

    @NotNull
    public ConfigSection set(@NotNull String path, @Nullable Object value, String ... comment) {
        this.set(path, value);
        return this.setComment(path, null, comment);
    }

    @NotNull
    public ConfigSection set(@NotNull String path, @Nullable Object value, List<String> comment) {
        this.set(path, value);
        return this.setComment(path, null, comment);
    }

    @NotNull
    public ConfigSection set(@NotNull String path, @Nullable Object value, @Nullable ConfigFormattingRules.CommentStyle commentStyle, String ... comment) {
        this.set(path, value);
        return this.setComment(path, commentStyle, comment);
    }

    @NotNull
    public ConfigSection set(@NotNull String path, @Nullable Object value, @Nullable ConfigFormattingRules.CommentStyle commentStyle, List<String> comment) {
        this.set(path, value);
        return this.setComment(path, commentStyle, comment);
    }

    @NotNull
    public ConfigSection setDefault(@NotNull String path, @Nullable Object value) {
        this.addDefault(path, value);
        return this;
    }

    @NotNull
    public ConfigSection setDefault(@NotNull String path, @Nullable Object value, String ... comment) {
        this.addDefault(path, value);
        return this.setDefaultComment(path, comment);
    }

    @NotNull
    public ConfigSection setDefault(@NotNull String path, @Nullable Object value, List<String> comment) {
        this.addDefault(path, value);
        return this.setDefaultComment(path, comment);
    }

    @NotNull
    public ConfigSection setDefault(@NotNull String path, @Nullable Object value, ConfigFormattingRules.CommentStyle commentStyle, String ... comment) {
        this.addDefault(path, value);
        return this.setDefaultComment(path, commentStyle, comment);
    }

    @NotNull
    public ConfigSection setDefault(@NotNull String path, @Nullable Object value, ConfigFormattingRules.CommentStyle commentStyle, List<String> comment) {
        this.addDefault(path, value);
        return this.setDefaultComment(path, commentStyle, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createSection(@NotNull String path) {
        this.createNodePath(path, false);
        ConfigSection section = new ConfigSection(this.root, this, path, false);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.values.put(this.fullPath + path, (Object)section);
        }
        this.root.changed = true;
        this.onChange();
        return section;
    }

    @NotNull
    public ConfigSection createSection(@NotNull String path, String ... comment) {
        return this.createSection(path, null, comment.length == 0 ? null : Arrays.asList(comment));
    }

    @NotNull
    public ConfigSection createSection(@NotNull String path, @Nullable List<String> comment) {
        return this.createSection(path, null, comment);
    }

    @NotNull
    public ConfigSection createSection(@NotNull String path, @Nullable ConfigFormattingRules.CommentStyle commentStyle, String ... comment) {
        return this.createSection(path, commentStyle, comment.length == 0 ? null : Arrays.asList(comment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createSection(@NotNull String path, @Nullable ConfigFormattingRules.CommentStyle commentStyle, @Nullable List<String> comment) {
        this.createNodePath(path, false);
        ConfigSection section = new ConfigSection(this.root, this, path, false);
        Object object = this.root.lock;
        synchronized (object) {
            this.root.values.put(this.fullPath + path, (Object)section);
        }
        this.setComment(path, commentStyle, comment);
        this.root.changed = true;
        this.onChange();
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ConfigSection createSection(@NotNull String path, Map<?, ?> map) {
        this.createNodePath(path, false);
        ConfigSection section = new ConfigSection(this.root, this, path, false);
        Iterator<Map.Entry<?, ?>> iterator = this.root.lock;
        synchronized (iterator) {
            this.root.values.put(this.fullPath + path, (Object)section);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createSection(entry.getKey().toString(), (Map)entry.getValue());
                continue;
            }
            section.set(entry.getKey().toString(), entry.getValue());
        }
        this.root.changed = true;
        this.onChange();
        return section;
    }

    @Nullable
    public String getString(@NotNull String path) {
        Object result = this.get(path);
        return result != null ? result.toString() : null;
    }

    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        Object result = this.get(path);
        return result != null ? result.toString() : def;
    }

    public char getChar(@NotNull String path) {
        Object result = this.get(path);
        return result != null && !result.toString().isEmpty() ? result.toString().charAt(0) : (char)'\u0000';
    }

    public char getChar(@NotNull String path, char def) {
        Object result = this.get(path);
        return result != null && !result.toString().isEmpty() ? result.toString().charAt(0) : def;
    }

    public int getInt(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).intValue() : 0;
    }

    public int getInt(@NotNull String path, int def) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).intValue() : def;
    }

    public boolean getBoolean(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof Boolean ? (Boolean)result : false;
    }

    public boolean getBoolean(@NotNull String path, boolean def) {
        Object result = this.get(path);
        return result instanceof Boolean ? (Boolean)result : def;
    }

    public double getDouble(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).doubleValue() : 0.0;
    }

    public double getDouble(@NotNull String path, double def) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).doubleValue() : def;
    }

    public long getLong(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).longValue() : 0L;
    }

    public long getLong(@NotNull String path, long def) {
        Object result = this.get(path);
        return result instanceof Number ? ((Number)result).longValue() : def;
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof List ? (List)result : null;
    }

    @Nullable
    public List<?> getList(@NotNull String path, @Nullable List<?> def) {
        Object result = this.get(path);
        return result instanceof List ? (List)result : def;
    }

    @Nullable
    public CompatibleMaterial getMaterial(@NotNull String path) {
        String val = this.getString(path);
        return val != null ? CompatibleMaterial.getMaterial(val) : null;
    }

    @Nullable
    public CompatibleMaterial getMaterial(@NotNull String path, @Nullable CompatibleMaterial def) {
        String val = this.getString(path);
        CompatibleMaterial mat = val != null ? CompatibleMaterial.getMaterial(val) : null;
        return mat != null ? mat : def;
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz) {
        Object result = this.get(path);
        return clazz.isInstance(result) ? (T)clazz.cast(result) : null;
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        Object result = this.get(path);
        return clazz.isInstance(result) ? clazz.cast(result) : def;
    }

    public ConfigSection getConfigurationSection(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof ConfigSection ? (ConfigSection)((Object)result) : null;
    }

    @NotNull
    public ConfigSection getOrCreateConfigurationSection(@NotNull String path) {
        Object result = this.get(path);
        return result instanceof ConfigSection ? (ConfigSection)((Object)result) : this.createSection(path);
    }
}

