/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.core;

import com.songoda.ultimatetimber.core.core.PluginInfo;
import com.songoda.ultimatetimber.core.core.PluginInfoModule;
import com.songoda.ultimatetimber.core.locale.Locale;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LocaleModule
implements PluginInfoModule {
    @Override
    public void run(PluginInfo plugin) {
        if (plugin.getJavaPlugin() == null || plugin.getSongodaId() <= 0) {
            return;
        }
        try {
            JSONObject json = plugin.getJson();
            JSONArray files = (JSONArray)json.get((Object)"neededFiles");
            for (Object o : files) {
                JSONObject file = (JSONObject)o;
                if (!file.get((Object)"type").equals("locale")) continue;
                this.downloadLocale(plugin, (String)file.get((Object)"link"), (String)file.get((Object)"name"));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LocaleModule.class.getName()).log(Level.INFO, "Failed to check for locale files: " + ex.getMessage());
        }
    }

    void downloadLocale(PluginInfo plugin, String link, String fileName) throws IOException {
        URL url = new URL(link);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        urlConnection.setRequestProperty("Accept", "*/*");
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setConnectTimeout(5000);
        int status = urlConnection.getResponseCode();
        if (status == 302 || status == 301 || status == 303) {
            String newUrl = urlConnection.getHeaderField("Location");
            String cookies = urlConnection.getHeaderField("Set-Cookie");
            urlConnection = (HttpURLConnection)new URL(newUrl).openConnection();
            urlConnection.setRequestProperty("Cookie", cookies);
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            urlConnection.setRequestProperty("Accept", "*/*");
            urlConnection.setConnectTimeout(5000);
        }
        Locale.saveLocale((Plugin)plugin.getJavaPlugin(), urlConnection.getInputStream(), fileName);
        urlConnection.disconnect();
    }
}

