/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.hooks.economies;

import com.songoda.ultimatetimber.core.hooks.economies.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEconomy
extends Economy {
    private final net.milkbowl.vault.economy.Economy vault;

    public VaultEconomy() {
        RegisteredServiceProvider v = Bukkit.getServicesManager().getRegistration(net.milkbowl.vault.economy.Economy.class);
        this.vault = v != null ? (net.milkbowl.vault.economy.Economy)v.getProvider() : null;
    }

    @Override
    public boolean isEnabled() {
        return this.vault != null;
    }

    @Override
    public String getName() {
        return "Vault";
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        if (this.vault == null) {
            return 0.0;
        }
        return this.vault.getBalance(player);
    }

    @Override
    public boolean hasBalance(OfflinePlayer player, double cost) {
        return this.vault != null && this.vault.has(player, cost);
    }

    @Override
    public boolean withdrawBalance(OfflinePlayer player, double cost) {
        return this.vault != null && this.vault.withdrawPlayer(player, cost).transactionSuccess();
    }

    @Override
    public boolean deposit(OfflinePlayer player, double amount) {
        return this.vault != null && this.vault.depositPlayer(player, amount).transactionSuccess();
    }
}

