/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.hooks.stackers;

import com.songoda.ultimatestacker.stackable.entity.EntityStack;
import com.songoda.ultimatestacker.utils.Methods;
import com.songoda.ultimatetimber.core.hooks.stackers.Stacker;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;

public class UltimateStacker
extends Stacker {
    private final com.songoda.ultimatestacker.UltimateStacker plugin = com.songoda.ultimatestacker.UltimateStacker.getInstance();

    @Override
    public String getName() {
        return "UltimateStacker";
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    @Override
    public boolean supportsItemStacking() {
        return true;
    }

    @Override
    public boolean supportsEntityStacking() {
        return true;
    }

    @Override
    public void setItemAmount(Item item, int amount) {
        com.songoda.ultimatestacker.UltimateStacker.updateItemAmount((Item)item, (int)amount);
    }

    @Override
    public int getItemAmount(Item item) {
        return Methods.getActualItemAmount((Item)item);
    }

    @Override
    public boolean isStacked(LivingEntity entity) {
        return this.plugin.getEntityStackManager().isStackedAndLoaded(entity);
    }

    @Override
    public int getSize(LivingEntity entity) {
        return this.isStacked(entity) ? this.plugin.getEntityStackManager().getStack(entity).getAmount() : 0;
    }

    @Override
    public void remove(LivingEntity entity, int amount) {
        EntityStack stack = this.plugin.getEntityStackManager().getStack(entity);
        stack.takeEntities(amount);
        stack.updateStack();
    }

    @Override
    public void add(LivingEntity entity, int amount) {
        this.plugin.getEntityStackManager().addStack(entity, amount);
    }

    @Override
    public int getMinStackSize(EntityType type) {
        return this.plugin.getConfig().getInt("Entities.Min Stack Amount");
    }
}

