/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.v1_14_R1.world.spawner;

import com.songoda.ultimatetimber.core.nms.ReflectionUtils;
import com.songoda.ultimatetimber.core.nms.world.BBaseSpawner;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.server.v1_14_R1.AxisAlignedBB;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityInsentient;
import net.minecraft.server.v1_14_R1.EntityPositionTypes;
import net.minecraft.server.v1_14_R1.EntityTypes;
import net.minecraft.server.v1_14_R1.EnumMobSpawn;
import net.minecraft.server.v1_14_R1.GeneratorAccess;
import net.minecraft.server.v1_14_R1.IWorldReader;
import net.minecraft.server.v1_14_R1.MobSpawnerAbstract;
import net.minecraft.server.v1_14_R1.MobSpawnerData;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NBTTagList;
import net.minecraft.server.v1_14_R1.ParticleParam;
import net.minecraft.server.v1_14_R1.Particles;
import net.minecraft.server.v1_14_R1.WeightedRandom;
import net.minecraft.server.v1_14_R1.World;
import org.bukkit.craftbukkit.v1_14_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BBaseSpawnerImpl
implements BBaseSpawner {
    private final MobSpawnerAbstract spawner;

    public BBaseSpawnerImpl(MobSpawnerAbstract spawner) {
        this.spawner = spawner;
    }

    @Override
    public boolean isNearPlayer() {
        BlockPosition blockposition = this.spawner.b();
        return this.spawner.a().isPlayerNearby((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.5, (double)blockposition.getZ() + 0.5, (double)this.spawner.requiredPlayerRange);
    }

    @Override
    public void tick() throws NoSuchFieldException, IllegalAccessException {
        World world = this.spawner.a();
        BlockPosition blockposition = this.spawner.b();
        if (world.isClientSide) {
            double d0 = (float)blockposition.getX() + world.random.nextFloat();
            double d1 = (float)blockposition.getY() + world.random.nextFloat();
            double d2 = (float)blockposition.getZ() + world.random.nextFloat();
            world.addParticle((ParticleParam)Particles.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle((ParticleParam)Particles.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawner.spawnDelay > 0) {
                --this.spawner.spawnDelay;
            }
            double spawnerE = (Double)ReflectionUtils.getFieldValue(this.spawner, "e");
            ReflectionUtils.setFieldValue(this.spawner, "f", spawnerE);
            ReflectionUtils.setFieldValue(this.spawner, "e", (spawnerE + (double)(1000.0f / ((float)this.spawner.spawnDelay + 200.0f))) % 360.0);
            return;
        }
        if (this.spawner.spawnDelay == -1) {
            this.delay(this.spawner);
        }
        if (this.spawner.spawnDelay > 0) {
            --this.spawner.spawnDelay;
            return;
        }
        boolean flag = false;
        int i = 0;
        while (true) {
            block19: {
                Entity entity;
                block20: {
                    double d5;
                    if (i >= this.spawner.spawnCount) {
                        if (!flag) break;
                        this.delay(this.spawner);
                        break;
                    }
                    NBTTagCompound nbttagcompound = this.spawner.spawnData.getEntity();
                    Optional optional = EntityTypes.a((NBTTagCompound)nbttagcompound);
                    if (!optional.isPresent()) {
                        this.delay(this.spawner);
                        return;
                    }
                    NBTTagList nbttaglist = nbttagcompound.getList("Pos", 6);
                    int j = nbttaglist.size();
                    double d3 = j >= 1 ? nbttaglist.h(0) : (double)blockposition.getX() + (world.random.nextDouble() - world.random.nextDouble()) * (double)this.spawner.spawnRange + 0.5;
                    double d4 = j >= 2 ? nbttaglist.h(1) : (double)(blockposition.getY() + world.random.nextInt(3) - 1);
                    double d = d5 = j >= 3 ? nbttaglist.h(2) : (double)blockposition.getZ() + (world.random.nextDouble() - world.random.nextDouble()) * (double)this.spawner.spawnRange + 0.5;
                    if (!world.c(((EntityTypes)optional.get()).a(d3, d4, d5)) || !EntityPositionTypes.a((EntityTypes)((EntityTypes)optional.get()), (GeneratorAccess)world.getMinecraftWorld(), (EnumMobSpawn)EnumMobSpawn.SPAWNER, (BlockPosition)new BlockPosition(d3, d4, d5), (Random)world.getRandom())) break block19;
                    entity = EntityTypes.a((NBTTagCompound)nbttagcompound, (World)world, entity1 -> {
                        entity1.setPositionRotation(d3, d4, d5, entity1.yaw, entity1.pitch);
                        return entity1;
                    });
                    if (entity == null) {
                        this.delay(this.spawner);
                        return;
                    }
                    int k = world.a(entity.getClass(), new AxisAlignedBB((double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), (double)(blockposition.getX() + 1), (double)(blockposition.getY() + 1), (double)(blockposition.getZ() + 1)).g((double)this.spawner.spawnRange)).size();
                    if (k >= this.spawner.maxNearbyEntities) {
                        this.delay(this.spawner);
                        return;
                    }
                    entity.setPositionRotation(entity.locX, entity.locY, entity.locZ, world.random.nextFloat() * 360.0f, 0.0f);
                    if (!(entity instanceof EntityInsentient)) break block20;
                    EntityInsentient entityinsentient = (EntityInsentient)entity;
                    if (!entityinsentient.a((GeneratorAccess)world, EnumMobSpawn.SPAWNER) || !entityinsentient.a((IWorldReader)world)) break block19;
                    if (this.spawner.spawnData.getEntity().d() == 1 && this.spawner.spawnData.getEntity().hasKeyOfType("id", 8)) {
                        ((EntityInsentient)entity).prepare((GeneratorAccess)world, world.getDamageScaler(new BlockPosition(entity)), EnumMobSpawn.SPAWNER, null, null);
                    }
                }
                if (entity.world.spigotConfig.nerfSpawnerMobs) {
                    entity.fromMobSpawner = true;
                }
                if (CraftEventFactory.callSpawnerSpawnEvent((Entity)entity, (BlockPosition)blockposition).isCancelled()) {
                    Entity vehicle = entity.getVehicle();
                    if (vehicle != null) {
                        vehicle.dead = true;
                    }
                    for (Entity passenger : entity.getAllPassengers()) {
                        passenger.dead = true;
                    }
                } else {
                    BBaseSpawnerImpl.addWithPassengers(this.spawner, entity);
                    world.triggerEffect(2004, blockposition, 0);
                    if (entity instanceof EntityInsentient) {
                        ((EntityInsentient)entity).doSpawnEffect();
                    }
                    flag = true;
                }
            }
            ++i;
        }
    }

    private void delay(MobSpawnerAbstract spawner) {
        if (spawner.maxSpawnDelay <= spawner.minSpawnDelay) {
            spawner.spawnDelay = spawner.minSpawnDelay;
        } else {
            int i = spawner.maxSpawnDelay - spawner.minSpawnDelay;
            spawner.spawnDelay = spawner.minSpawnDelay + spawner.a().random.nextInt(i);
        }
        if (!spawner.mobs.isEmpty()) {
            spawner.setSpawnData((MobSpawnerData)WeightedRandom.a((Random)spawner.a().random, (List)spawner.mobs));
        }
        spawner.a(1);
    }

    static void addWithPassengers(MobSpawnerAbstract spawner, Entity entity) {
        if (spawner.a().addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            for (Entity value : entity.getPassengers()) {
                BBaseSpawnerImpl.addWithPassengers(spawner, value);
            }
        }
    }
}

