/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.v1_17_R1.world;

import com.songoda.ultimatetimber.core.nms.ReflectionUtils;
import com.songoda.ultimatetimber.core.nms.v1_17_R1.world.SItemStackImpl;
import com.songoda.ultimatetimber.core.nms.v1_17_R1.world.SSpawnerImpl;
import com.songoda.ultimatetimber.core.nms.v1_17_R1.world.SWorldImpl;
import com.songoda.ultimatetimber.core.nms.v1_17_R1.world.spawner.BBaseSpawnerImpl;
import com.songoda.ultimatetimber.core.nms.world.BBaseSpawner;
import com.songoda.ultimatetimber.core.nms.world.SItemStack;
import com.songoda.ultimatetimber.core.nms.world.SSpawner;
import com.songoda.ultimatetimber.core.nms.world.SWorld;
import com.songoda.ultimatetimber.core.nms.world.WorldCore;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.inventory.ItemStack;

public class WorldCoreImpl
implements WorldCore {
    @Override
    public SSpawner getSpawner(CreatureSpawner spawner) {
        return new SSpawnerImpl(spawner.getLocation());
    }

    @Override
    public SSpawner getSpawner(Location location) {
        return new SSpawnerImpl(location);
    }

    @Override
    public SItemStack getItemStack(ItemStack item) {
        return new SItemStackImpl(item);
    }

    @Override
    public SWorld getWorld(org.bukkit.World world) {
        return new SWorldImpl(world);
    }

    @Override
    public BBaseSpawner getBaseSpawner(CreatureSpawner spawner) throws NoSuchFieldException, IllegalAccessException {
        Object cTileEntity = ReflectionUtils.getFieldValue(spawner, "tileEntity");
        return new BBaseSpawnerImpl(spawner, (MobSpawnerAbstract)ReflectionUtils.getFieldValue(cTileEntity, "a"));
    }

    @Override
    public void randomTickChunk(org.bukkit.Chunk bukkitChunk, int tickAmount) {
        Chunk chunk = ((CraftChunk)bukkitChunk).getHandle();
        WorldServer world = (WorldServer)chunk.getWorld();
        if (tickAmount <= 0) {
            return;
        }
        GameProfilerFiller profiler = world.getMethodProfiler();
        ChunkCoordIntPair chunkPos = chunk.getPos();
        int minBlockX = chunkPos.d();
        int minBlockZ = chunkPos.e();
        profiler.enter("tickBlocks");
        for (ChunkSection cSection : chunk.getSections()) {
            if (cSection == Chunk.a || !cSection.d()) continue;
            int bottomBlockY = cSection.getYPosition();
            for (int k1 = 0; k1 < tickAmount; ++k1) {
                Fluid fluid;
                BlockPosition bPos = world.a(minBlockX, bottomBlockY, minBlockZ, 15);
                profiler.enter("randomTick");
                IBlockData blockState = cSection.getType(bPos.getX() - minBlockX, bPos.getY() - bottomBlockY, bPos.getZ() - minBlockZ);
                if (blockState.isTicking()) {
                    blockState.b(world, bPos, chunk.getWorld().w);
                }
                if ((fluid = blockState.getFluid()).f()) {
                    fluid.b((World)world, bPos, chunk.getWorld().w);
                }
                profiler.exit();
            }
        }
        profiler.exit();
    }
}

