/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.v1_8_R3.nbt;

import com.songoda.ultimatetimber.core.nms.nbt.NBTCompound;
import com.songoda.ultimatetimber.core.nms.nbt.NBTObject;
import com.songoda.ultimatetimber.core.nms.v1_8_R3.nbt.NBTObjectImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_8_R3.NBTTagCompound;

public class NBTCompoundImpl
implements NBTCompound {
    protected NBTTagCompound compound;

    protected NBTCompoundImpl(NBTTagCompound compound) {
        this.compound = compound;
    }

    public NBTCompoundImpl() {
        this.compound = new NBTTagCompound();
    }

    @Override
    public NBTCompound set(String tag, String s) {
        this.compound.setString(tag, s);
        return this;
    }

    @Override
    public NBTCompound set(String tag, boolean b2) {
        this.compound.setBoolean(tag, b2);
        return this;
    }

    @Override
    public NBTCompound set(String tag, int i) {
        this.compound.setInt(tag, i);
        return this;
    }

    @Override
    public NBTCompound set(String tag, double i) {
        this.compound.setDouble(tag, i);
        return this;
    }

    @Override
    public NBTCompound set(String tag, long l) {
        this.compound.setLong(tag, l);
        return this;
    }

    @Override
    public NBTCompound set(String tag, short s) {
        this.compound.setShort(tag, s);
        return this;
    }

    @Override
    public NBTCompound set(String tag, byte b2) {
        this.compound.setByte(tag, b2);
        return this;
    }

    @Override
    public NBTCompound set(String tag, int[] i) {
        this.compound.setIntArray(tag, i);
        return this;
    }

    @Override
    public NBTCompound set(String tag, byte[] b2) {
        this.compound.setByteArray(tag, b2);
        return this;
    }

    @Override
    public NBTCompound set(String tag, UUID u) {
        this.set(tag + "Most", u.getMostSignificantBits());
        this.set(tag + "Least", u.getLeastSignificantBits());
        return this;
    }

    @Override
    public NBTCompound remove(String tag) {
        this.compound.remove(tag);
        return this;
    }

    @Override
    public boolean has(String tag) {
        return this.compound.hasKey(tag);
    }

    @Override
    public NBTObject getNBTObject(String tag) {
        return new NBTObjectImpl(this.compound, tag);
    }

    @Override
    public String getString(String tag) {
        return this.getNBTObject(tag).asString();
    }

    @Override
    public boolean getBoolean(String tag) {
        return this.getNBTObject(tag).asBoolean();
    }

    @Override
    public int getInt(String tag) {
        return this.getNBTObject(tag).asInt();
    }

    @Override
    public double getDouble(String tag) {
        return this.getNBTObject(tag).asDouble();
    }

    @Override
    public long getLong(String tag) {
        return this.getNBTObject(tag).asLong();
    }

    @Override
    public short getShort(String tag) {
        return this.getNBTObject(tag).asShort();
    }

    @Override
    public byte getByte(String tag) {
        return this.getNBTObject(tag).asByte();
    }

    @Override
    public int[] getIntArray(String tag) {
        return this.getNBTObject(tag).asIntArray();
    }

    @Override
    public byte[] getByteArray(String tag) {
        return new byte[0];
    }

    @Override
    public NBTCompound getCompound(String tag) {
        if (this.has(tag)) {
            return this.getNBTObject(tag).asCompound();
        }
        NBTTagCompound newCompound = new NBTTagCompound();
        this.compound.set(tag, (NBTBase)newCompound);
        return new NBTCompoundImpl(newCompound);
    }

    @Override
    public Set<String> getKeys() {
        return this.compound.c();
    }

    @Override
    public Set<String> getKeys(String tag) {
        return this.getNBTObject(tag).getKeys();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(String ... exclusions) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream dataOutput = new ObjectOutputStream(outputStream);){
                this.addExtras();
                NBTTagCompound compound = (NBTTagCompound)this.compound.clone();
                for (String exclusion : exclusions) {
                    compound.remove(exclusion);
                }
                NBTCompressedStreamTools.a((NBTTagCompound)compound, (OutputStream)dataOutput);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void deSerialize(byte[] serialized) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serialized);
             ObjectInputStream dataInput = new ObjectInputStream(inputStream);){
            this.compound = NBTCompressedStreamTools.a((InputStream)dataInput);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addExtras() {
    }

    public String toString() {
        return this.compound.toString();
    }
}

