/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.world;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.nms.world.SpawnedEntity;
import com.songoda.ultimatetimber.core.third_party.org.apache.commons.text.WordUtils;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public interface SSpawner {
    public LivingEntity spawnEntity(EntityType var1, Location var2);

    public LivingEntity spawnEntity(EntityType var1, String var2, SpawnedEntity var3, Set<CompatibleMaterial> var4);

    default public String translateName(EntityType type, boolean capital) {
        return capital ? TypeTranslations.getUpperFromType(type) : TypeTranslations.getLowerFromType(type);
    }

    public static enum TypeTranslations {
        VINDICATOR("vindication_illager", "VindicationIllager"),
        SNOWMAN("snowman", "SnowMan"),
        PIG_ZOMBIE("zombie_pigman", "PigZombie"),
        EVOKER("evocation_illager", "EvocationIllager"),
        ILLUSIONER("illusion_illager", "IllusionIllager"),
        IRON_GOLEM("villager_golem", "VillagerGolem"),
        MUSHROOM_COW("mooshroom", "MushroomCow"),
        MAGMA_CUBE("magma_cube", "LavaSlime"),
        CAVE_SPIDER("cave_spider", "CaveSpider");

        private final String lower;
        private final String upper;

        private TypeTranslations(String lower, String upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public static String getLowerFromType(EntityType type) {
            try {
                TypeTranslations typeTranslation = TypeTranslations.valueOf(type.name());
                return typeTranslation.lower;
            }
            catch (Exception exception) {
                return type.name().toLowerCase();
            }
        }

        public static String getUpperFromType(EntityType type) {
            try {
                TypeTranslations typeTranslation = TypeTranslations.valueOf(type.name());
                return typeTranslation.upper;
            }
            catch (Exception exception) {
                return WordUtils.capitalize(type.name().toLowerCase()).replace(" ", "");
            }
        }
    }
}

