/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.utils;

import com.songoda.ultimatetimber.core.chat.ColorCode;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ColorUtils {
    private static Map<ColorCode, ColorSet<Integer, Integer, Integer>> colorMap = new HashMap<ColorCode, ColorSet<Integer, Integer, Integer>>();

    public static ColorCode fromRGB(int r, int g, int b2) {
        TreeMap closest = new TreeMap();
        colorMap.forEach((color, set) -> {
            int red = Math.abs(r - (Integer)set.getRed());
            int green = Math.abs(g - (Integer)set.getGreen());
            int blue = Math.abs(b2 - (Integer)set.getBlue());
            closest.put(red + green + blue, color);
        });
        return (ColorCode)((Object)closest.firstEntry().getValue());
    }

    static {
        colorMap.put(ColorCode.BLACK, new ColorSet<Integer, Integer, Integer>(0, 0, 0));
        colorMap.put(ColorCode.DARK_BLUE, new ColorSet<Integer, Integer, Integer>(0, 0, 170));
        colorMap.put(ColorCode.DARK_GREEN, new ColorSet<Integer, Integer, Integer>(0, 170, 0));
        colorMap.put(ColorCode.DARK_AQUA, new ColorSet<Integer, Integer, Integer>(0, 170, 170));
        colorMap.put(ColorCode.DARK_RED, new ColorSet<Integer, Integer, Integer>(170, 0, 0));
        colorMap.put(ColorCode.DARK_PURPLE, new ColorSet<Integer, Integer, Integer>(170, 0, 170));
        colorMap.put(ColorCode.GOLD, new ColorSet<Integer, Integer, Integer>(255, 170, 0));
        colorMap.put(ColorCode.GRAY, new ColorSet<Integer, Integer, Integer>(170, 170, 170));
        colorMap.put(ColorCode.DARK_GRAY, new ColorSet<Integer, Integer, Integer>(85, 85, 85));
        colorMap.put(ColorCode.BLUE, new ColorSet<Integer, Integer, Integer>(85, 85, 255));
        colorMap.put(ColorCode.GREEN, new ColorSet<Integer, Integer, Integer>(85, 255, 85));
        colorMap.put(ColorCode.AQUA, new ColorSet<Integer, Integer, Integer>(85, 255, 255));
        colorMap.put(ColorCode.RED, new ColorSet<Integer, Integer, Integer>(255, 85, 85));
        colorMap.put(ColorCode.LIGHT_PURPLE, new ColorSet<Integer, Integer, Integer>(255, 85, 255));
        colorMap.put(ColorCode.YELLOW, new ColorSet<Integer, Integer, Integer>(255, 255, 85));
        colorMap.put(ColorCode.WHITE, new ColorSet<Integer, Integer, Integer>(255, 255, 255));
    }

    private static class ColorSet<R, G, B> {
        R red;
        G green;
        B blue;

        ColorSet(R red, G green, B blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public R getRed() {
            return this.red;
        }

        public G getGreen() {
            return this.green;
        }

        public B getBlue() {
            return this.blue;
        }
    }
}

