/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SongodaAuth {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAuthorized(boolean allowOffline) {
        String productId = "18";
        try {
            Integer.parseInt(productId);
        }
        catch (NumberFormatException e) {
            return true;
        }
        UUID uuid = SongodaAuth.getUUID();
        try {
            URL url = new URL("https://marketplace.songoda.com/api/v2/products/license/validate");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            con.setDoOutput(true);
            String jsonInputString = "{\"product_id\":" + productId + ",\"license\":\"" + uuid + "\",\"user_id\":\"-1\"}";
            try (OutputStream os = con.getOutputStream();){
                byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                StringBuilder response = new StringBuilder();
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(response.toString());
                if (jsonObject.get((Object)"error") != null) {
                    Bukkit.getLogger().warning("Error validating license: " + jsonObject.get((Object)"error"));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = (Boolean)jsonObject.get((Object)"valid");
                return bl;
            }
        }
        catch (Exception e) {
            return allowOffline;
        }
    }

    public static UUID getUUID() {
        File serverProperties = new File(new File("."), "server.properties");
        Properties prop = new Properties();
        try {
            prop.load(new FileReader(serverProperties));
            String uuid = prop.getProperty("uuid");
            if (uuid == null || uuid.isEmpty()) {
                UUID newUUID = UUID.randomUUID();
                prop.setProperty("uuid", newUUID.toString());
                prop.store(new FileWriter(serverProperties), null);
                return newUUID;
            }
            return UUID.fromString(uuid);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not fetch UUID for server", ex);
        }
    }

    public static String getIP() {
        String string;
        URL url = new URL("https://marketplace.songoda.com/api/v2/products/license/ip");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
        try {
            StringBuilder response = new StringBuilder();
            String responseLine = null;
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            JSONParser parser = new JSONParser();
            JSONObject jsonObject = (JSONObject)parser.parse(response.toString());
            string = jsonObject.get((Object)"ip").toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not fetch IP address", ex);
            }
        }
        br.close();
        return string;
    }
}

