/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.animation.TreeAnimation;
import com.songoda.ultimatetimber.animation.TreeAnimationCrumble;
import com.songoda.ultimatetimber.animation.TreeAnimationDisintegrate;
import com.songoda.ultimatetimber.animation.TreeAnimationFancy;
import com.songoda.ultimatetimber.animation.TreeAnimationNone;
import com.songoda.ultimatetimber.animation.TreeAnimationType;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import com.songoda.ultimatetimber.manager.TreeDefinitionManager;
import com.songoda.ultimatetimber.tree.DetectedTree;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import com.songoda.ultimatetimber.utils.ParticleUtils;
import com.songoda.ultimatetimber.utils.SoundUtils;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

public class TreeAnimationManager
extends Manager
implements Listener,
Runnable {
    private final Set<TreeAnimation> activeAnimations = new HashSet<TreeAnimation>();
    private final int taskId;

    public TreeAnimationManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
        this.taskId = -1;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ultimateTimber);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, (Runnable)this, 0L, 1L);
    }

    @Override
    public void reload() {
        this.activeAnimations.clear();
    }

    @Override
    public void disable() {
        this.activeAnimations.clear();
        Bukkit.getScheduler().cancelTask(this.taskId);
    }

    @Override
    public void run() {
        for (TreeAnimation treeAnimation : this.activeAnimations) {
            HashSet<ITreeBlock<FallingBlock>> groundedBlocks = new HashSet<ITreeBlock<FallingBlock>>();
            for (ITreeBlock<FallingBlock> iTreeBlock : treeAnimation.getFallingTreeBlocks().getAllTreeBlocks()) {
                FallingBlock fallingBlock = iTreeBlock.getBlock();
                if (!fallingBlock.isDead() && (!ServerVersion.isServerVersionAtLeast(ServerVersion.V1_17) || !fallingBlock.isOnGround())) continue;
                groundedBlocks.add(iTreeBlock);
            }
            for (ITreeBlock<Object> iTreeBlock : groundedBlocks) {
                this.runFallingBlockImpact(treeAnimation, iTreeBlock);
                if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_17)) {
                    ((FallingBlock)iTreeBlock.getBlock()).remove();
                }
                treeAnimation.getFallingTreeBlocks().remove(iTreeBlock);
            }
        }
    }

    public void runAnimation(DetectedTree detectedTree, Player player) {
        switch (TreeAnimationType.fromString(ConfigurationManager.Setting.TREE_ANIMATION_TYPE.getString())) {
            case FANCY: {
                this.registerTreeAnimation(new TreeAnimationFancy(detectedTree, player));
                break;
            }
            case DISINTEGRATE: {
                this.registerTreeAnimation(new TreeAnimationDisintegrate(detectedTree, player));
                break;
            }
            case CRUMBLE: {
                this.registerTreeAnimation(new TreeAnimationCrumble(detectedTree, player));
                break;
            }
            case NONE: {
                this.registerTreeAnimation(new TreeAnimationNone(detectedTree, player));
            }
        }
    }

    public boolean isBlockInAnimation(Block block) {
        for (TreeAnimation treeAnimation : this.activeAnimations) {
            for (ITreeBlock<Block> treeBlock : treeAnimation.getDetectedTree().getDetectedTreeBlocks().getAllTreeBlocks()) {
                if (!treeBlock.getBlock().equals(block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBlockInAnimation(FallingBlock fallingBlock) {
        for (TreeAnimation treeAnimation : this.activeAnimations) {
            for (ITreeBlock<FallingBlock> treeBlock : treeAnimation.getFallingTreeBlocks().getAllTreeBlocks()) {
                if (!treeBlock.getBlock().equals(fallingBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private TreeAnimation getAnimationForBlock(FallingBlock fallingBlock) {
        for (TreeAnimation treeAnimation : this.activeAnimations) {
            for (ITreeBlock<FallingBlock> treeBlock : treeAnimation.getFallingTreeBlocks().getAllTreeBlocks()) {
                if (!treeBlock.getBlock().equals(fallingBlock)) continue;
                return treeAnimation;
            }
        }
        return null;
    }

    private void registerTreeAnimation(TreeAnimation treeAnimation) {
        this.activeAnimations.add(treeAnimation);
        treeAnimation.playAnimation(() -> this.activeAnimations.remove(treeAnimation));
    }

    public void runFallingBlockImpact(TreeAnimation treeAnimation, ITreeBlock<FallingBlock> treeBlock) {
        TreeDefinitionManager treeDefinitionManager = this.plugin.getTreeDefinitionManager();
        boolean useCustomSound = ConfigurationManager.Setting.USE_CUSTOM_SOUNDS.getBoolean();
        boolean useCustomParticles = ConfigurationManager.Setting.USE_CUSTOM_PARTICLES.getBoolean();
        TreeDefinition treeDefinition = treeAnimation.getDetectedTree().getTreeDefinition();
        if (useCustomParticles) {
            ParticleUtils.playLandingParticles(treeBlock);
        }
        if (useCustomSound) {
            SoundUtils.playLandingSound(treeBlock);
        }
        Block block = treeBlock.getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        if (ConfigurationManager.Setting.FRAGILE_BLOCKS.getStringList().contains(block.getType().toString())) {
            block.getWorld().dropItemNaturally(block.getLocation(), CompatibleMaterial.getMaterial(block).getItem());
            block.breakNaturally();
        }
        treeDefinitionManager.dropTreeLoot(treeDefinition, treeBlock, treeAnimation.getPlayer(), treeAnimation.hasSilkTouch(), false);
        this.plugin.getSaplingManager().replantSaplingWithChance(treeDefinition, treeBlock);
        treeAnimation.getFallingTreeBlocks().remove(treeBlock);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFallingBlockLand(EntityChangeBlockEvent event) {
        TreeAnimation treeAnimation;
        if (!event.getEntityType().equals((Object)EntityType.FALLING_BLOCK)) {
            return;
        }
        FallingBlock fallingBlock = (FallingBlock)event.getEntity();
        if (!this.isBlockInAnimation(fallingBlock)) {
            return;
        }
        if (ConfigurationManager.Setting.FALLING_BLOCKS_DEAL_DAMAGE.getBoolean()) {
            int damage = ConfigurationManager.Setting.FALLING_BLOCK_DAMAGE.getInt();
            for (Entity entity : fallingBlock.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).damage((double)damage, (Entity)fallingBlock);
            }
        }
        if (ConfigurationManager.Setting.SCATTER_TREE_BLOCKS_ON_GROUND.getBoolean() && (treeAnimation = this.getAnimationForBlock(fallingBlock)) != null) {
            treeAnimation.removeFallingBlock(fallingBlock);
            return;
        }
        event.setCancelled(true);
    }
}

