/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import com.songoda.ultimatetimber.manager.PlacedBlockManager;
import com.songoda.ultimatetimber.manager.TreeDefinitionManager;
import com.songoda.ultimatetimber.tree.DetectedTree;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockSet;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class TreeDetectionManager
extends Manager {
    private final Set<Vector> VALID_TRUNK_OFFSETS;
    private final Set<Vector> VALID_BRANCH_OFFSETS = new HashSet<Vector>();
    private final Set<Vector> VALID_LEAF_OFFSETS;
    private TreeDefinitionManager treeDefinitionManager;
    private PlacedBlockManager placedBlockManager;
    private int numLeavesRequiredForTree;
    private boolean onlyBreakLogsUpwards;
    private boolean entireTreeBase;
    private boolean destroyLeaves;

    public TreeDetectionManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
        int z;
        int x;
        int y;
        this.VALID_TRUNK_OFFSETS = new HashSet<Vector>();
        this.VALID_LEAF_OFFSETS = new HashSet<Vector>();
        for (y = 0; y <= 1; ++y) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    this.VALID_BRANCH_OFFSETS.add(new Vector(x, y, z));
                }
            }
        }
        for (y = -1; y <= 1; ++y) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    this.VALID_TRUNK_OFFSETS.add(new Vector(x, y, z));
                }
            }
        }
        for (int i = -1; i <= 1; i += 2) {
            this.VALID_LEAF_OFFSETS.add(new Vector(i, 0, 0));
            this.VALID_LEAF_OFFSETS.add(new Vector(0, i, 0));
            this.VALID_LEAF_OFFSETS.add(new Vector(0, 0, i));
        }
    }

    @Override
    public void reload() {
        this.treeDefinitionManager = this.plugin.getTreeDefinitionManager();
        this.placedBlockManager = this.plugin.getPlacedBlockManager();
        this.numLeavesRequiredForTree = ConfigurationManager.Setting.LEAVES_REQUIRED_FOR_TREE.getInt();
        this.onlyBreakLogsUpwards = ConfigurationManager.Setting.ONLY_DETECT_LOGS_UPWARDS.getBoolean();
        this.entireTreeBase = ConfigurationManager.Setting.BREAK_ENTIRE_TREE_BASE.getBoolean();
        this.destroyLeaves = ConfigurationManager.Setting.DESTROY_LEAVES.getBoolean();
    }

    @Override
    public void disable() {
    }

    public DetectedTree detectTree(Block initialBlock) {
        TreeDefinitionManager treeDefinitionManager = this.plugin.getTreeDefinitionManager();
        TreeBlock initialTreeBlock = new TreeBlock(initialBlock, TreeBlockType.LOG);
        TreeBlockSet<Block> detectedTreeBlocks = new TreeBlockSet<Block>(initialTreeBlock);
        Set<TreeDefinition> possibleTreeDefinitions = this.treeDefinitionManager.getTreeDefinitionsForLog(initialBlock);
        if (possibleTreeDefinitions.isEmpty()) {
            return null;
        }
        ArrayList<Block> trunkBlocks = new ArrayList<Block>();
        trunkBlocks.add(initialBlock);
        Block targetBlock = initialBlock;
        while (this.isValidLogType(possibleTreeDefinitions, null, targetBlock = targetBlock.getRelative(BlockFace.UP))) {
            trunkBlocks.add(targetBlock);
            possibleTreeDefinitions.retainAll(this.treeDefinitionManager.narrowTreeDefinition(possibleTreeDefinitions, targetBlock, TreeBlockType.LOG));
        }
        if (!this.onlyBreakLogsUpwards) {
            targetBlock = initialBlock;
            while (this.isValidLogType(possibleTreeDefinitions, null, targetBlock = targetBlock.getRelative(BlockFace.DOWN))) {
                trunkBlocks.add(targetBlock);
                possibleTreeDefinitions.retainAll(this.treeDefinitionManager.narrowTreeDefinition(possibleTreeDefinitions, targetBlock, TreeBlockType.LOG));
            }
        }
        Collections.reverse(trunkBlocks);
        for (Block block : trunkBlocks) {
            this.recursiveBranchSearch(possibleTreeDefinitions, trunkBlocks, detectedTreeBlocks, block, initialBlock.getLocation().getBlockY());
        }
        HashSet<ITreeBlock<Block>> branchBlocks = new HashSet<ITreeBlock<Block>>(detectedTreeBlocks.getLogBlocks());
        for (ITreeBlock iTreeBlock : branchBlocks) {
            this.recursiveLeafSearch(possibleTreeDefinitions, detectedTreeBlocks, (Block)iTreeBlock.getBlock(), new HashSet<Block>());
        }
        TreeDefinition treeDefinition = possibleTreeDefinitions.iterator().next();
        if (detectedTreeBlocks.getLeafBlocks().size() < this.numLeavesRequiredForTree) {
            return null;
        }
        if (!this.destroyLeaves) {
            detectedTreeBlocks.removeAll(TreeBlockType.LEAF);
        }
        if (this.entireTreeBase) {
            HashSet<Block> hashSet = new HashSet<Block>();
            for (ITreeBlock<Block> treeBlock : detectedTreeBlocks.getLogBlocks()) {
                if (treeBlock == detectedTreeBlocks.getInitialLogBlock() || treeBlock.getLocation().getBlockY() != initialBlock.getLocation().getBlockY()) continue;
                hashSet.add(treeBlock.getBlock());
            }
            for (Block block : hashSet) {
                Block blockBelow = block.getRelative(BlockFace.DOWN);
                boolean blockBelowIsLog = this.isValidLogType(possibleTreeDefinitions, null, blockBelow);
                boolean blockBelowIsSoil = false;
                for (CompatibleMaterial material : treeDefinitionManager.getPlantableSoilMaterial(treeDefinition)) {
                    if (!material.equals((Object)CompatibleMaterial.getMaterial(blockBelow))) continue;
                    blockBelowIsSoil = true;
                    break;
                }
                if (!blockBelowIsLog && !blockBelowIsSoil) continue;
                return null;
            }
        }
        return new DetectedTree(treeDefinition, detectedTreeBlocks);
    }

    private void recursiveBranchSearch(Set<TreeDefinition> treeDefinitions, List<Block> trunkBlocks, TreeBlockSet<Block> treeBlocks, Block block, int startingBlockY) {
        for (Vector offset : this.onlyBreakLogsUpwards ? this.VALID_BRANCH_OFFSETS : this.VALID_TRUNK_OFFSETS) {
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            TreeBlock treeBlock = new TreeBlock(targetBlock, TreeBlockType.LOG);
            if (!this.isValidLogType(treeDefinitions, trunkBlocks, targetBlock) || treeBlocks.contains(treeBlock)) continue;
            treeBlocks.add(treeBlock);
            treeDefinitions.retainAll(this.treeDefinitionManager.narrowTreeDefinition(treeDefinitions, targetBlock, TreeBlockType.LOG));
            if (this.onlyBreakLogsUpwards && targetBlock.getLocation().getBlockY() <= startingBlockY) continue;
            this.recursiveBranchSearch(treeDefinitions, trunkBlocks, treeBlocks, targetBlock, startingBlockY);
        }
    }

    private void recursiveLeafSearch(Set<TreeDefinition> treeDefinitions, TreeBlockSet<Block> treeBlocks, Block block, Set<Block> visitedBlocks) {
        boolean detectLeavesDiagonally = treeDefinitions.stream().anyMatch(TreeDefinition::shouldDetectLeavesDiagonally);
        for (Vector offset : !detectLeavesDiagonally ? this.VALID_LEAF_OFFSETS : this.VALID_TRUNK_OFFSETS) {
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            if (visitedBlocks.contains(targetBlock)) continue;
            visitedBlocks.add(targetBlock);
            TreeBlock treeBlock = new TreeBlock(targetBlock, TreeBlockType.LEAF);
            if (!this.isValidLeafType(treeDefinitions, treeBlocks, targetBlock) || treeBlocks.contains(treeBlock) || this.doesLeafBorderInvalidLog(treeDefinitions, treeBlocks, targetBlock)) continue;
            treeBlocks.add(treeBlock);
            treeDefinitions.retainAll(this.treeDefinitionManager.narrowTreeDefinition(treeDefinitions, targetBlock, TreeBlockType.LEAF));
            this.recursiveLeafSearch(treeDefinitions, treeBlocks, targetBlock, visitedBlocks);
        }
    }

    private boolean doesLeafBorderInvalidLog(Set<TreeDefinition> treeDefinitions, TreeBlockSet<Block> treeBlocks, Block block) {
        for (Vector offset : this.VALID_TRUNK_OFFSETS) {
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            if (!this.isValidLogType(treeDefinitions, null, targetBlock) || treeBlocks.contains(new TreeBlock(targetBlock, TreeBlockType.LOG))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidLogType(Set<TreeDefinition> treeDefinitions, List<Block> trunkBlocks, Block block) {
        if (this.placedBlockManager.isBlockPlaced(block)) {
            return false;
        }
        boolean isCorrectType = false;
        block0: for (TreeDefinition treeDefinition : treeDefinitions) {
            for (CompatibleMaterial material : treeDefinition.getLogMaterial()) {
                if (!material.equals((Object)CompatibleMaterial.getMaterial(block))) continue;
                isCorrectType = true;
                continue block0;
            }
        }
        if (!isCorrectType) {
            return false;
        }
        if (trunkBlocks == null || trunkBlocks.isEmpty()) {
            return true;
        }
        Location location = block.getLocation();
        for (TreeDefinition treeDefinition : treeDefinitions) {
            double maxDistance = treeDefinition.getMaxLogDistanceFromTrunk() * treeDefinition.getMaxLogDistanceFromTrunk();
            if (!this.onlyBreakLogsUpwards) {
                maxDistance *= 1.5;
            }
            for (Block trunkBlock : trunkBlocks) {
                if (!(location.distanceSquared(trunkBlock.getLocation()) < maxDistance)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidLeafType(Set<TreeDefinition> treeDefinitions, TreeBlockSet<Block> treeBlocks, Block block) {
        if (this.placedBlockManager.isBlockPlaced(block)) {
            return false;
        }
        boolean isCorrectType = false;
        block0: for (TreeDefinition treeDefinition : treeDefinitions) {
            for (CompatibleMaterial material : treeDefinition.getLeafMaterial()) {
                if (!material.equals((Object)CompatibleMaterial.getMaterial(block))) continue;
                isCorrectType = true;
                continue block0;
            }
        }
        if (!isCorrectType) {
            return false;
        }
        if (treeBlocks == null || treeBlocks.isEmpty()) {
            return true;
        }
        int maxDistanceFromLog = treeDefinitions.stream().map(TreeDefinition::getMaxLeafDistanceFromLog).max(Integer::compareTo).orElse(0);
        return treeBlocks.getLogBlocks().stream().anyMatch(x -> x.getLocation().distanceSquared(block.getLocation()) < (double)(maxDistanceFromLog * maxDistanceFromLog));
    }
}

