/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.tree;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.tree.TreeLoot;
import java.util.Collections;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class TreeDefinition {
    private final String key;
    private final Set<CompatibleMaterial> logMaterial;
    private final Set<CompatibleMaterial> leafMaterial;
    private final Set<CompatibleMaterial> plantableSoilMaterial;
    private final CompatibleMaterial saplingMaterial;
    private final double maxLogDistanceFromTrunk;
    private final int maxLeafDistanceFromLog;
    private final boolean detectLeavesDiagonally;
    private final boolean dropOriginalLog;
    private final boolean dropOriginalLeaf;
    private final Set<TreeLoot> logLoot;
    private final Set<TreeLoot> leafLoot;
    private final Set<TreeLoot> entireTreeLoot;
    private final Set<ItemStack> requiredTools;
    private final boolean requiredAxe;

    public TreeDefinition(String key, Set<CompatibleMaterial> logMaterial, Set<CompatibleMaterial> leafMaterial, CompatibleMaterial saplingMaterial, Set<CompatibleMaterial> plantableSoilMaterial, double maxLogDistanceFromTrunk, int maxLeafDistanceFromLog, boolean detectLeavesDiagonally, boolean dropOriginalLog, boolean dropOriginalLeaf, Set<TreeLoot> logLoot, Set<TreeLoot> leafLoot, Set<TreeLoot> entireTreeLoot, Set<ItemStack> requiredTools, boolean requiredAxe) {
        this.key = key;
        this.logMaterial = logMaterial;
        this.leafMaterial = leafMaterial;
        this.saplingMaterial = saplingMaterial;
        this.plantableSoilMaterial = plantableSoilMaterial;
        this.maxLogDistanceFromTrunk = maxLogDistanceFromTrunk;
        this.maxLeafDistanceFromLog = maxLeafDistanceFromLog;
        this.detectLeavesDiagonally = detectLeavesDiagonally;
        this.dropOriginalLog = dropOriginalLog;
        this.dropOriginalLeaf = dropOriginalLeaf;
        this.logLoot = logLoot;
        this.leafLoot = leafLoot;
        this.entireTreeLoot = entireTreeLoot;
        this.requiredTools = requiredTools;
        this.requiredAxe = requiredAxe;
    }

    public String getKey() {
        return this.key;
    }

    public Set<CompatibleMaterial> getLogMaterial() {
        return Collections.unmodifiableSet(this.logMaterial);
    }

    public Set<CompatibleMaterial> getLeafMaterial() {
        return Collections.unmodifiableSet(this.leafMaterial);
    }

    public CompatibleMaterial getSaplingMaterial() {
        return this.saplingMaterial;
    }

    public Set<CompatibleMaterial> getPlantableSoilMaterial() {
        return Collections.unmodifiableSet(this.plantableSoilMaterial);
    }

    public double getMaxLogDistanceFromTrunk() {
        return this.maxLogDistanceFromTrunk;
    }

    public int getMaxLeafDistanceFromLog() {
        return this.maxLeafDistanceFromLog;
    }

    public boolean shouldDetectLeavesDiagonally() {
        return this.detectLeavesDiagonally;
    }

    public boolean shouldDropOriginalLog() {
        return this.dropOriginalLog;
    }

    public boolean shouldDropOriginalLeaf() {
        return this.dropOriginalLeaf;
    }

    public Set<TreeLoot> getLogLoot() {
        return Collections.unmodifiableSet(this.logLoot);
    }

    public Set<TreeLoot> getLeafLoot() {
        return Collections.unmodifiableSet(this.leafLoot);
    }

    public Set<TreeLoot> getEntireTreeLoot() {
        return Collections.unmodifiableSet(this.entireTreeLoot);
    }

    public Set<ItemStack> getRequiredTools() {
        return Collections.unmodifiableSet(this.requiredTools);
    }

    public boolean isRequiredAxe() {
        return this.requiredAxe;
    }
}

