/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.davidml16.acubelets.MetricsLite;
import me.davidml16.acubelets.PlaceholderHook;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.api.CubeletsAPI;
import me.davidml16.acubelets.api.PointsAPI;
import me.davidml16.acubelets.commands.cubelets.CoreCommand;
import me.davidml16.acubelets.database.DatabaseHandler;
import me.davidml16.acubelets.events.Event_Block;
import me.davidml16.acubelets.events.Event_Damage;
import me.davidml16.acubelets.events.Event_Interact;
import me.davidml16.acubelets.events.Event_JoinQuit;
import me.davidml16.acubelets.events.Event_Menus;
import me.davidml16.acubelets.handlers.ConversationHandler;
import me.davidml16.acubelets.handlers.CubeletBoxHandler;
import me.davidml16.acubelets.handlers.CubeletCraftingHandler;
import me.davidml16.acubelets.handlers.CubeletOpenHandler;
import me.davidml16.acubelets.handlers.CubeletRarityHandler;
import me.davidml16.acubelets.handlers.CubeletRewardHandler;
import me.davidml16.acubelets.handlers.CubeletTypesHandler;
import me.davidml16.acubelets.handlers.EconomyHandler;
import me.davidml16.acubelets.handlers.LanguageHandler;
import me.davidml16.acubelets.handlers.LayoutHandler;
import me.davidml16.acubelets.handlers.MenuHandler;
import me.davidml16.acubelets.handlers.PlayerDataHandler;
import me.davidml16.acubelets.handlers.PluginHandler;
import me.davidml16.acubelets.handlers.TransactionHandler;
import me.davidml16.acubelets.holograms.HologramHandler;
import me.davidml16.acubelets.holograms.HologramImplementation;
import me.davidml16.acubelets.tasks.DataCacheTask;
import me.davidml16.acubelets.tasks.DataSaveTask;
import me.davidml16.acubelets.tasks.HologramTask;
import me.davidml16.acubelets.tasks.LiveGuiTask;
import me.davidml16.acubelets.utils.ConfigUpdater;
import me.davidml16.acubelets.utils.FireworkUtil;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main main;
    public static ConsoleCommandSender log;
    private MetricsLite metrics;
    private CubeletsAPI cubeletsAPI;
    private PointsAPI pointsAPI;
    private ProtocolManager protocolManager;
    private HologramTask hologramTask;
    private DataSaveTask dataSaveTask;
    private LiveGuiTask liveGuiTask;
    private DataCacheTask dataCacheTask;
    private LanguageHandler languageHandler;
    private DatabaseHandler databaseHandler;
    private PlayerDataHandler playerDataHandler;
    private CubeletTypesHandler cubeletTypesHandler;
    private CubeletRarityHandler cubeletRarityHandler;
    private CubeletRewardHandler cubeletRewardHandler;
    private CubeletBoxHandler cubeletBoxHandler;
    private HologramHandler hologramHandler;
    private CubeletOpenHandler cubeletOpenHandler;
    private AnimationHandler animationHandler;
    private CubeletCraftingHandler cubeletCraftingHandler;
    private EconomyHandler economyHandler;
    private LayoutHandler layoutHandler;
    private ConversationHandler conversationHandler;
    private TransactionHandler transactionHandler;
    private MenuHandler menuHandler;
    private FireworkUtil fireworkUtil;
    private PluginHandler pluginHandler;
    private int playerCount;
    private Map<String, Boolean> settings;
    private String noCubeletsCommand;
    private String noCubeletsCommandExecutor;
    private String duplicationPermissionCommand;
    private String duplicationPointsCommand;
    private CommandMap commandMap;
    private List<String> templates = Arrays.asList("normal", "super", "uber", "old", "summer", "easter", "halloween", "christmas");

    public void onEnable() {
        Main.loadConfig0();
        main = this;
        log = Bukkit.getConsoleSender();
        this.metrics = new MetricsLite((Plugin)this, 7349);
        this.settings = new HashMap<String, Boolean>();
        this.saveDefaultConfig();
        try {
            ConfigUpdater.update((Plugin)this, "config.yml", new File(main.getDataFolder(), "config.yml"), Collections.emptyList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.reloadConfig();
        if (!Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.getLogger().severe("*** ProtocolLib is not installed or not enabled. ***");
            this.getLogger().severe("*** This plugin will be disabled. ***");
            this.setEnabled(false);
            return;
        }
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.settings.put("Crafting", this.getConfig().getBoolean("Crafting"));
        this.settings.put("BroadcastReward", this.getConfig().getBoolean("BroadcastReward"));
        this.settings.put("LoginReminder", this.getConfig().getBoolean("LoginReminder"));
        this.settings.put("CubeletsCommand", this.getConfig().getBoolean("NoCubelets.ExecuteCommand"));
        this.noCubeletsCommand = this.getConfig().getString("NoCubelets.Command");
        this.noCubeletsCommandExecutor = this.getConfig().getString("NoCubelets.Executor");
        this.pluginHandler = new PluginHandler(this);
        this.transactionHandler = new TransactionHandler(this);
        this.languageHandler = new LanguageHandler(this, this.getConfig().getString("Language").toLowerCase());
        this.languageHandler.pushMessages();
        this.databaseHandler = new DatabaseHandler(this);
        this.databaseHandler.openConnection();
        this.databaseHandler.loadTables();
        this.animationHandler = new AnimationHandler(this);
        this.animationHandler.loadAnimations();
        this.settings.put("AnimationsByPlayer", this.getConfig().getBoolean("AnimationsByPlayer"));
        this.cubeletBoxHandler = new CubeletBoxHandler(this);
        this.cubeletBoxHandler.loadBoxes();
        this.settings.put("NoGuiMode", this.getConfig().getBoolean("NoGuiMode"));
        this.settings.put("SerializeBase64", this.getConfig().getBoolean("SerializeBase64"));
        this.settings.put("RewardAutoSorting", this.getConfig().getBoolean("RewardAutoSorting"));
        this.settings.put("UseKeys", this.getConfig().getBoolean("UseKeys"));
        this.cubeletTypesHandler = new CubeletTypesHandler(this);
        this.cubeletTypesHandler.loadTypes();
        this.cubeletRarityHandler = new CubeletRarityHandler(this);
        this.cubeletRarityHandler.loadRarities();
        this.cubeletRewardHandler = new CubeletRewardHandler(this);
        this.cubeletRewardHandler.loadRewards();
        this.cubeletTypesHandler.printLog();
        this.settings.put("RewardsDuplication", this.getConfig().getBoolean("RewardsDuplication.Enabled"));
        this.settings.put("duplicationPermissionCommand", this.getConfig().getBoolean("RewardsDuplication.Enabled"));
        this.duplicationPermissionCommand = this.getConfig().getString("RewardsDuplication.PermissionCommand");
        this.duplicationPointsCommand = this.getConfig().getString("RewardsDuplication.PointsCommand");
        this.economyHandler = new EconomyHandler();
        this.economyHandler.load();
        this.cubeletCraftingHandler = new CubeletCraftingHandler(this);
        this.cubeletCraftingHandler.loadCrafting();
        this.playerDataHandler = new PlayerDataHandler(this);
        this.hologramHandler = new HologramHandler(this);
        if (this.hologramHandler.getImplementation() == null) {
            this.getLogger().severe("*** HolographicDisplays or Decent Holograms is not installed or not enabled. ***");
            this.getLogger().severe("*** Now the plugin will be disabled. ***");
            this.setEnabled(false);
            return;
        }
        int n = this.getConfig().getInt("Holograms.VisibilityDistance");
        this.hologramHandler.setVisibilityDistance(n * n);
        this.hologramHandler.getColorAnimation().setColors(this.getConfig().getStringList("Holograms.ColorAnimation"));
        this.hologramHandler.getImplementation().loadHolograms();
        this.settings.put("HDVisibleToAllPlayers", this.getConfig().getBoolean("Holograms.Duplication.VisibleToAllPlayers"));
        this.playerDataHandler.loadAllPlayerData();
        this.hologramTask = new HologramTask(this);
        this.hologramTask.start();
        this.dataSaveTask = new DataSaveTask(this);
        this.dataSaveTask.start();
        this.dataCacheTask = new DataCacheTask(this);
        this.dataCacheTask.start();
        this.cubeletOpenHandler = new CubeletOpenHandler(this);
        this.settings.put("LiveGuiUpdates", this.getConfig().getBoolean("LiveGuiUpdates"));
        this.liveGuiTask = new LiveGuiTask(this);
        if (this.isLiveGuiUpdates()) {
            this.liveGuiTask.start();
        }
        this.layoutHandler = new LayoutHandler(this);
        this.menuHandler = new MenuHandler(this);
        this.settings.put("RewardsPreview", this.getConfig().getBoolean("RewardsPreview.Enabled"));
        this.menuHandler.setClickType(this.getConfig().getString("RewardsPreview.ClickType"));
        this.settings.put("GiftCubeletsCommand", this.getConfig().getBoolean("GiftCubeletsCommand"));
        this.conversationHandler = new ConversationHandler(this);
        this.fireworkUtil = new FireworkUtil(this);
        this.cubeletsAPI = new CubeletsAPI(this);
        this.pointsAPI = new PointsAPI(this);
        this.registerCommands();
        this.registerEvents();
        this.playerCount = this.getServer().getOnlinePlayers().size();
        PluginDescriptionFile pluginDescriptionFile = this.getDescription();
        log.sendMessage(Utils.translate("  &eACubelets Enabled!"));
        log.sendMessage(Utils.translate("    &aVersion: &b" + pluginDescriptionFile.getVersion()));
        log.sendMessage(Utils.translate("    &aAuthor: &b" + pluginDescriptionFile.getAuthors()));
        log.sendMessage("");
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderHook(this).register();
            this.settings.put("placeholderapi", true);
        } else {
            this.settings.put("placeholderapi", false);
        }
    }

    public void onDisable() {
        PluginDescriptionFile pluginDescriptionFile = this.getDescription();
        log.sendMessage("");
        log.sendMessage(Utils.translate("  &eACubelets Disabled!"));
        log.sendMessage(Utils.translate("    &aVersion: &b" + pluginDescriptionFile.getVersion()));
        log.sendMessage(Utils.translate("    &aAuthor: &b" + pluginDescriptionFile.getAuthors()));
        log.sendMessage("");
        if (this.hologramHandler != null && this.hologramHandler.getImplementation() != null) {
            this.hologramHandler.getImplementation().removeHolograms();
        }
        main.getPlayerDataHandler().saveAllPlayerDataSync();
        for (Animation animation : new ArrayList<Animation>(main.getAnimationHandler().getTasks())) {
            animation.stop();
        }
        main.getAnimationHandler().getTasks().clear();
        for (Entity entity : main.getAnimationHandler().getEntities()) {
            entity.remove();
        }
        main.getAnimationHandler().getEntities().clear();
        if (this.hologramTask != null) {
            this.hologramTask.stop();
        }
        if (this.dataSaveTask != null) {
            this.dataSaveTask.stop();
        }
        if (this.databaseHandler != null) {
            this.databaseHandler.getDatabaseConnection().stop();
        }
    }

    public static Main get() {
        return main;
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public MetricsLite getMetrics() {
        return this.metrics;
    }

    public LanguageHandler getLanguageHandler() {
        return this.languageHandler;
    }

    public DatabaseHandler getDatabaseHandler() {
        return this.databaseHandler;
    }

    public DatabaseHandler getDatabase() {
        return this.databaseHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public PlayerDataHandler getPlayerDataHandler() {
        return this.playerDataHandler;
    }

    public CubeletTypesHandler getCubeletTypesHandler() {
        return this.cubeletTypesHandler;
    }

    public CubeletRarityHandler getCubeletRarityHandler() {
        return this.cubeletRarityHandler;
    }

    public CubeletRewardHandler getCubeletRewardHandler() {
        return this.cubeletRewardHandler;
    }

    public CubeletBoxHandler getCubeletBoxHandler() {
        return this.cubeletBoxHandler;
    }

    public HologramHandler getHologramHandler() {
        return this.hologramHandler;
    }

    public HologramImplementation getHologramImplementation() {
        return this.hologramHandler.getImplementation();
    }

    public CubeletOpenHandler getCubeletOpenHandler() {
        return this.cubeletOpenHandler;
    }

    public AnimationHandler getAnimationHandler() {
        return this.animationHandler;
    }

    public CubeletCraftingHandler getCubeletCraftingHandler() {
        return this.cubeletCraftingHandler;
    }

    public EconomyHandler getEconomyHandler() {
        return this.economyHandler;
    }

    public LayoutHandler getLayoutHandler() {
        return this.layoutHandler;
    }

    public MenuHandler getMenuHandler() {
        return this.menuHandler;
    }

    public ConversationHandler getConversationHandler() {
        return this.conversationHandler;
    }

    public PluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public HologramTask getHologramTask() {
        return this.hologramTask;
    }

    public LiveGuiTask getLiveGuiTask() {
        return this.liveGuiTask;
    }

    public FireworkUtil getFireworkUtil() {
        return this.fireworkUtil;
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public void setPlayerCount(int n) {
        this.playerCount = n;
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public boolean playerHasPermission(Player player, String string) {
        return player.hasPermission(string) || player.isOp();
    }

    public boolean isCubeletsCommandEnabled() {
        return this.settings.get("CubeletsCommand");
    }

    public void setCubeletsCommandEnabled(boolean bl) {
        this.settings.put("CubeletsCommand", bl);
    }

    public String getNoCubeletsCommandExecutor() {
        return this.noCubeletsCommandExecutor;
    }

    public void setNoCubeletsCommandExecutor(String string) {
        this.noCubeletsCommandExecutor = string;
    }

    public boolean isCraftingEnabled() {
        return this.settings.get("Crafting");
    }

    public void setCraftingEnabled(boolean bl) {
        this.settings.put("Crafting", bl);
    }

    public boolean isPreviewEnabled() {
        return this.settings.get("RewardsPreview");
    }

    public void setPreviewEnabled(boolean bl) {
        this.settings.put("RewardsPreview", bl);
    }

    public boolean isDuplicationVisibleAllPlayers() {
        return this.settings.get("HDVisibleToAllPlayers");
    }

    public void setDuplicationVisibleAllPlayers(boolean bl) {
        this.settings.put("HDVisibleToAllPlayers", bl);
    }

    public boolean isNoGuiMode() {
        return this.settings.get("NoGuiMode");
    }

    public void setNoGuiMode(boolean bl) {
        this.settings.put("NoGuiMode", bl);
    }

    public boolean isRewardSorting() {
        return this.settings.get("RewardAutoSorting");
    }

    public void setRewardSorting(boolean bl) {
        this.settings.put("RewardAutoSorting", bl);
    }

    public boolean isLiveGuiUpdates() {
        return this.settings.get("LiveGuiUpdates");
    }

    public void setLiveGuiUpdates(boolean bl) {
        this.settings.put("LiveGuiUpdates", bl);
    }

    public boolean isAnimationByPlayer() {
        return this.settings.get("AnimationsByPlayer");
    }

    public void setAnimationsByPlayer(boolean bl) {
        this.settings.put("AnimationsByPlayer", bl);
    }

    public boolean isSerializeBase64() {
        return this.settings.get("SerializeBase64");
    }

    public void setSerializeBase64(boolean bl) {
        this.settings.put("SerializeBase64", bl);
    }

    public boolean isGiftCubelets() {
        return this.settings.get("GiftCubeletsCommand");
    }

    public void setGiftCubelets(boolean bl) {
        this.settings.put("GiftCubeletsCommand", bl);
    }

    public boolean isKeysEnabled() {
        return this.settings.get("UseKeys");
    }

    public void setKeysEnabled(boolean bl) {
        this.settings.put("UseKeys", bl);
    }

    public boolean isBroadcastEnabled() {
        return this.settings.get("BroadcastReward");
    }

    public void setBroadcastEnabled(boolean bl) {
        this.settings.put("BroadcastReward", bl);
    }

    public void setLoginReminder(boolean bl) {
        this.settings.put("LoginReminder", bl);
    }

    public boolean isLoginReminder() {
        return this.settings.get("LoginReminder");
    }

    public String getNoCubeletsCommand() {
        return this.noCubeletsCommand;
    }

    public void setNoCubeletsCommand(String string) {
        this.noCubeletsCommand = string;
    }

    public CommandMap getCommandMap() {
        return this.commandMap;
    }

    public boolean hasPlaceholderAPI() {
        return this.settings.get("placeholderapi");
    }

    public String getDuplicationPermissionCommand() {
        return this.duplicationPermissionCommand;
    }

    public void setDuplicationPermissionCommand(String string) {
        this.duplicationPermissionCommand = string;
    }

    public String getDuplicationPointsCommand() {
        return this.duplicationPointsCommand;
    }

    public void setDuplicationPointsCommand(String string) {
        this.duplicationPointsCommand = string;
    }

    public void setDuplicationEnabled(boolean bl) {
        this.settings.put("RewardsDuplication", bl);
    }

    public boolean isDuplicationEnabled() {
        return this.settings.get("RewardsDuplication");
    }

    private void registerCommands() {
        Field field = null;
        try {
            field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            this.commandMap = (CommandMap)field.get(Bukkit.getServer());
            this.commandMap.register("acubelets", (Command)new CoreCommand(this.getConfig().getString("Commands.Cubelets").toLowerCase()));
            this.commandMap.register("acubelets", (Command)new me.davidml16.acubelets.commands.points.CoreCommand(this.getConfig().getString("Commands.Points").toLowerCase()));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new Event_Interact(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Event_JoinQuit(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Event_Damage(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Event_Menus(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Event_Block(this), (Plugin)this);
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=9379992").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

