/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation6;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.Random;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Rabbit;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Animation6_Rabbit
extends BukkitRunnable {
    private final Location spawnLoc;
    private final float yaw;
    private LivingEntity rabbit;
    private int tick;

    public Animation6_Rabbit(Main main, Location location, float f) {
        this.spawnLoc = location;
        this.yaw = f;
        this.tick = 0;
        this.spawnLoc.setYaw(this.yaw);
        this.rabbit = (LivingEntity)location.getWorld().spawnEntity(this.spawnLoc, EntityType.RABBIT);
        ((Rabbit)this.rabbit).setRabbitType(Rabbit.Type.values()[new Random().nextInt(Rabbit.Type.values().length - 1)]);
        if (XMaterial.supports(9)) {
            this.rabbit.setCollidable(false);
        }
        this.rabbit.setRemoveWhenFarAway(false);
        this.rabbit.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)Boolean.TRUE));
        this.rabbit.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 99999, 10, true, false));
        NBTEditor.set(this.rabbit, (byte)1, "Silent");
        NBTEditor.set(this.rabbit, (byte)1, "Invulnerable");
        this.rabbit.teleport(this.spawnLoc);
        UtilParticles.display(Particles.FIREWORKS_SPARK, 0.35, 0.1, 0.35, location, 10);
        main.getAnimationHandler().getEntities().add((Entity)this.rabbit);
        Sounds.playSound(location, Sounds.MySound.LAVA_POP, 1.0f, 1.0f);
    }

    public Entity getEntity() {
        return this.rabbit;
    }

    public void run() {
        if (this.tick == 0) {
            this.rabbit.setVelocity(new Vector(0.0, 0.35, 0.0));
            this.tick = 15;
        } else {
            --this.tick;
        }
        Location location = this.rabbit.getLocation();
        location.setX(this.spawnLoc.getX());
        location.setZ(this.spawnLoc.getZ());
        location.setYaw(this.yaw);
        this.rabbit.teleport(location);
    }
}

