/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.cubelets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteBox;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteClear;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteGift;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteGive;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteGiveKey;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteInfo;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteLootHistory;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteOptions;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecutePreview;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteReload;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteRemove;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteSetup;
import me.davidml16.acubelets.commands.cubelets.subcommands.ExecuteType;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CoreCommand
extends Command {
    private final Main main = Main.get();
    private final ExecuteGive executeGive = new ExecuteGive(this.main);
    private final ExecuteRemove executeRemove = new ExecuteRemove(this.main);
    private final ExecuteBox executeBox = new ExecuteBox(this.main);
    private final ExecuteType executeType = new ExecuteType(this.main);
    private final ExecuteReload executeReload = new ExecuteReload(this.main);
    private final ExecuteSetup executeSetup = new ExecuteSetup(this.main);
    private final ExecuteOptions executeOptions = new ExecuteOptions(this.main);
    private final ExecuteInfo executeInfo = new ExecuteInfo(this.main);
    private final ExecuteClear executeClear = new ExecuteClear(this.main);
    private final ExecuteGift executeGift = new ExecuteGift(this.main);
    private final ExecuteGiveKey executeGiveKey = new ExecuteGiveKey(this.main);
    private final ExecutePreview executePreview = new ExecutePreview(this.main);
    private final ExecuteLootHistory executeLootHistory = new ExecuteLootHistory(this.main);

    public CoreCommand(String string) {
        super(string);
    }

    public boolean execute(CommandSender commandSender, String string, String[] stringArray) {
        if (stringArray.length == 0) {
            if (commandSender instanceof Player) {
                commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.Balance.Cubelets").replaceAll("%cubelets_available%", "" + this.main.getPlayerDataHandler().getData((Player)commandSender).getCubelets().size()));
                return true;
            }
            return this.sendCommandHelp(commandSender, string);
        }
        if (commandSender instanceof Player && this.main.getConversationHandler().haveConversation((Player)commandSender)) {
            return true;
        }
        switch (stringArray[0]) {
            case "help": {
                return this.sendCommandHelp(commandSender, string);
            }
            case "machine": {
                return this.executeBox.executeCommand(commandSender, string, stringArray);
            }
            case "give": {
                return this.executeGive.executeCommand(commandSender, string, stringArray);
            }
            case "givekey": {
                return this.executeGiveKey.executeCommand(commandSender, string, stringArray);
            }
            case "remove": {
                return this.executeRemove.executeCommand(commandSender, string, stringArray);
            }
            case "type": {
                return this.executeType.executeCommand(commandSender, string, stringArray);
            }
            case "setup": {
                return this.executeSetup.executeCommand(commandSender, string, stringArray);
            }
            case "options": {
                return this.executeOptions.executeCommand(commandSender, string, stringArray);
            }
            case "reload": {
                return this.executeReload.executeCommand(commandSender, string, stringArray);
            }
            case "info": {
                return this.executeInfo.executeCommand(commandSender, string, stringArray);
            }
            case "clear": {
                return this.executeClear.executeCommand(commandSender, string, stringArray);
            }
            case "gift": {
                return this.executeGift.executeCommand(commandSender, string, stringArray);
            }
            case "preview": {
                return this.executePreview.executeCommand(commandSender, string, stringArray);
            }
            case "history": {
                return this.executeLootHistory.executeCommand(commandSender, string, stringArray);
            }
        }
        commandSender.sendMessage("");
        commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cInvalid argument, use /" + string + " help to see available commands"));
        commandSender.sendMessage("");
        return false;
    }

    private boolean sendCommandHelp(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            if (this.main.isGiftCubelets()) {
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " gift [player]"));
            } else {
                commandSender.sendMessage("");
            }
            if (this.main.isPreviewEnabled()) {
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " preview [typeID]"));
            }
            commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " history"));
            if (this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " [give/remove] [player] [typeID] [amount]"));
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " [info/clear] [player]"));
                if (this.main.isKeysEnabled()) {
                    commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " givekey [player] [typeID] [amount]"));
                }
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " machine [create/remove/edit]"));
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " type"));
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " setup [typeID]"));
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " options"));
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " reload"));
                commandSender.sendMessage("");
            } else {
                commandSender.sendMessage("");
            }
        } else {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " [give/remove] [player] [typeID] [amount]"));
            commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " [info/clear] [player]"));
            if (this.main.isKeysEnabled()) {
                commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " givekey [player] [typeID] [amount]"));
            }
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " reload"));
            commandSender.sendMessage("");
        }
        return true;
    }

    public List<String> tabComplete(CommandSender commandSender, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return null;
        }
        Player player = (Player)commandSender;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray.length == 1) {
            if (this.main.isGiftCubelets()) {
                arrayList.add("gift");
            }
            if (this.main.isPreviewEnabled()) {
                arrayList.add("preview");
            }
            arrayList.add("history");
            if (this.main.playerHasPermission(player, "acubelets.admin")) {
                arrayList.add("help");
                arrayList.add("give");
                if (this.main.isKeysEnabled()) {
                    arrayList.add("givekey");
                }
                arrayList.add("info");
                arrayList.add("clear");
                arrayList.add("remove");
                arrayList.add("machine");
                arrayList.add("type");
                arrayList.add("setup");
                arrayList.add("options");
                arrayList.add("reload");
            }
        }
        if (stringArray[0].equalsIgnoreCase("give") || stringArray[0].equalsIgnoreCase("givekey")) {
            if (stringArray.length == 2) {
                if (this.main.playerHasPermission(player, "acubelets.admin")) {
                    for (Player player2 : this.main.getServer().getOnlinePlayers()) {
                        arrayList.add(player2.getName());
                    }
                    arrayList.add("*");
                }
            } else if (stringArray.length == 3) {
                if (this.main.playerHasPermission(player, "acubelets.admin")) {
                    arrayList.addAll(this.main.getCubeletTypesHandler().getTypes().keySet());
                }
            } else if (stringArray.length == 4) {
                arrayList.add("1");
            }
        } else if (stringArray[0].equalsIgnoreCase("remove")) {
            if (stringArray.length == 2) {
                if (this.main.playerHasPermission(player, "acubelets.admin")) {
                    for (Player player3 : this.main.getServer().getOnlinePlayers()) {
                        arrayList.add(player3.getName());
                    }
                }
            } else if (stringArray.length == 3 && this.main.playerHasPermission(player, "acubelets.admin")) {
                arrayList.addAll(this.main.getCubeletTypesHandler().getTypes().keySet());
            }
        } else if (stringArray[0].equalsIgnoreCase("info") || stringArray[0].equalsIgnoreCase("clear")) {
            if (stringArray.length == 2 && this.main.playerHasPermission(player, "acubelets.admin")) {
                for (Player player4 : this.main.getServer().getOnlinePlayers()) {
                    arrayList.add(player4.getName());
                }
            }
        } else if (stringArray[0].equalsIgnoreCase("setup")) {
            if (stringArray.length == 2 && this.main.playerHasPermission(player, "acubelets.admin")) {
                for (File file : Objects.requireNonNull(new File(this.main.getDataFolder(), "types").listFiles())) {
                    arrayList.add(file.getName().replace(".yml", ""));
                }
            }
        } else if (stringArray[0].equalsIgnoreCase("machine")) {
            if (stringArray.length == 2 && this.main.playerHasPermission(player, "acubelets.admin")) {
                arrayList.add("create");
                arrayList.add("remove");
                arrayList.add("edit");
            }
        } else if (stringArray[0].equalsIgnoreCase("type")) {
            if (this.main.playerHasPermission(player, "acubelets.admin")) {
                if (stringArray.length == 2) {
                    arrayList.add("create");
                    arrayList.add("remove");
                    arrayList.add("template");
                    arrayList.add("list");
                } else if (stringArray.length == 3) {
                    if (stringArray[1].equalsIgnoreCase("remove")) {
                        for (String string2 : this.main.getCubeletTypesHandler().getTypes().keySet()) {
                            arrayList.add(string2.toLowerCase());
                        }
                    } else if (stringArray[1].equalsIgnoreCase("template")) {
                        arrayList.addAll(this.main.getTemplates());
                        arrayList.add("*");
                    }
                }
            }
        } else if (stringArray[0].equalsIgnoreCase("gift")) {
            if (stringArray.length == 2) {
                for (Player player5 : this.main.getServer().getOnlinePlayers()) {
                    if (player5.getName().equalsIgnoreCase(player.getName())) continue;
                    arrayList.add(player5.getName());
                }
            }
        } else if (stringArray[0].equalsIgnoreCase("preview") && stringArray.length == 2) {
            arrayList.addAll(this.main.getCubeletTypesHandler().getTypes().keySet());
        }
        for (String string3 : arrayList) {
            if (!string3.startsWith(stringArray[stringArray.length - 1])) continue;
            arrayList2.add(string3);
        }
        return arrayList2.isEmpty() ? arrayList : arrayList2;
    }
}

