/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.cubelets.subcommands;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ExecuteGiveKey {
    private Main main;

    public ExecuteGiveKey(Main main) {
        this.main = main;
    }

    public boolean executeCommand(CommandSender commandSender, String string, String[] stringArray) {
        if (commandSender instanceof Player && !this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
            commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.NoPerms"));
            return false;
        }
        if (!this.main.isKeysEnabled()) {
            return true;
        }
        if (stringArray.length == 1 || stringArray.length == 2) {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " givekey [player] [typeID] [amount]"));
            commandSender.sendMessage("");
            return false;
        }
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (!this.main.getCubeletTypesHandler().getTypes().containsKey(string3)) {
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " type doesn't exists!"));
            return false;
        }
        int n = 1;
        CubeletType cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string3);
        if (string2.equalsIgnoreCase("*") || string2.equalsIgnoreCase("all")) {
            if (stringArray.length == 3) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.giveKey(commandSender, player, cubeletType, n);
                }
                return true;
            }
            if (stringArray.length == 4) {
                n = Integer.parseInt(stringArray[3]);
                if (n > 0) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        this.giveKey(commandSender, player, cubeletType, n);
                    }
                    return true;
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cAmount to give need to be more than 0!"));
                return false;
            }
        } else {
            Player player = Bukkit.getPlayer((String)string2);
            if (player == null) {
                commandSender.sendMessage(this.main.getLanguageHandler().getPrefix() + " &cPlayer " + string2 + " is not online!");
                return false;
            }
            if (stringArray.length == 3) {
                this.giveKey(commandSender, player, cubeletType, n);
                return true;
            }
            if (stringArray.length == 4) {
                n = Integer.parseInt(stringArray[3]);
                if (n > 0) {
                    this.giveKey(commandSender, player, cubeletType, n);
                    return true;
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cAmount to give need to be more than 0!"));
                return false;
            }
        }
        return true;
    }

    private void giveKey(CommandSender commandSender, Player player, CubeletType cubeletType, int n) {
        ItemStack itemStack = cubeletType.getKeyNBT();
        for (int i = 0; i < n; ++i) {
            if (player.getInventory().firstEmpty() >= 0) {
                player.getInventory().addItem(new ItemStack[]{itemStack});
                continue;
            }
            player.getLocation().getWorld().dropItemNaturally(player.getLocation(), itemStack);
        }
        String string = this.main.getLanguageHandler().getMessage("Commands.Cubelets.GiveKey.Give");
        string = string.replaceAll("%amount%", Integer.toString(n));
        string = string.replaceAll("%cubelet%", cubeletType.getName());
        string = string.replaceAll("%player%", player.getName());
        commandSender.sendMessage(Utils.translate(string));
        String string2 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.GiveKey.Received");
        string2 = string2.replaceAll("%amount%", Integer.toString(n));
        string2 = string2.replaceAll("%cubelet%", cubeletType.getName());
        player.sendMessage(Utils.translate(string2));
    }
}

