/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.rarities;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.rewards.RaritiesMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RarityConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public RarityConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"cubeletType", (Object)cubeletType);
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    private boolean rarityIdExist(CubeletType cubeletType, String string) {
        return cubeletType.getRarities().containsKey(string);
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4", "5", "6"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"cubeletType");
            switch (string) {
                case "1": {
                    return new CommonPrompts.CommonStringPrompt(RarityConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter rarity identificator, \"cancel\" to return.\n\n ", "rarityID");
                }
                case "2": {
                    return new CommonPrompts.CommonStringPrompt(RarityConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Enter rarity name (You can use color codes), \"cancel\" to return.\n\n ", "rarityName");
                }
                case "3": {
                    return new CommonPrompts.NumericRangePrompt(RarityConversation.this.main, (Prompt)this, ChatColor.YELLOW + "  Enter rarity chance, \"cancel\" to return.\n  Range: 0 to 100\n\n ", "rarityChance", 0.0, 100.0);
                }
                case "4": {
                    return new CommonPrompts.DuplicateRangeStringPrompt(RarityConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter rarity duplicate points range, \"cancel\" to return.\n  Format: min-max. Example: 50-450\n\n ", "rarityDuplicate");
                }
                case "5": {
                    if (conversationContext.getSessionData((Object)"rarityID") != null && conversationContext.getSessionData((Object)"rarityName") != null && conversationContext.getSessionData((Object)"rarityChance") != null && conversationContext.getSessionData((Object)"rarityDuplicate") != null) {
                        if (!RarityConversation.this.rarityIdExist(cubeletType, (String)conversationContext.getSessionData((Object)"rarityID"))) {
                            String string2 = (String)conversationContext.getSessionData((Object)"rarityID");
                            String string3 = (String)conversationContext.getSessionData((Object)"rarityName");
                            double d = (Double)conversationContext.getSessionData((Object)"rarityChance");
                            String string4 = (String)conversationContext.getSessionData((Object)"rarityDuplicate");
                            Rarity rarity = new Rarity(string2, string3, d, string4);
                            cubeletType.getRarities().put(string2, rarity);
                            cubeletType.saveType();
                            conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(RarityConversation.this.main.getLanguageHandler().getPrefix() + " &aYou added rarity &e" + rarity.getId() + " &ato rarities of cubelet type &e" + cubeletType.getId()));
                            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                            RarityConversation.this.main.getMenuHandler().reloadAllMenus(RaritiesMenu.class);
                            Player player = (Player)conversationContext.getSessionData((Object)"player");
                            RaritiesMenu raritiesMenu = new RaritiesMenu(RarityConversation.this.main, player);
                            raritiesMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                            raritiesMenu.open();
                            RarityConversation.this.main.getConversationHandler().removeConversation(player);
                            return Prompt.END_OF_CONVERSATION;
                        }
                        return new CommonPrompts.ErrorPrompt(RarityConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  There is already a rarity with that ID, please change it and try again\n  Write anything to continue\n ");
                    }
                    return new CommonPrompts.ErrorPrompt(RarityConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup ID, NAME and CHANCE to save rarity!\n  Write anything to continue\n ");
                }
                case "6": {
                    return new CommonPrompts.ConfirmExitPrompt(RarityConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET RARITY CREATION MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"rarityID") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Set rarity ID (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Set rarity ID (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)((String)conversationContext.getSessionData((Object)"rarityID"))) + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rarityName") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Set rarity name (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Set rarity name (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"rarityName") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rarityChance") == null ? string + ChatColor.RED + "    3 " + ChatColor.GRAY + "- Set rarity chance (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Set rarity chance (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf((Double)conversationContext.getSessionData((Object)"rarityChance"))) + "%" + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rarityDuplicate") == null ? string + ChatColor.RED + "    4 " + ChatColor.GRAY + "- Set rarity duplicate points range (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Set rarity duplicate points range (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(conversationContext.getSessionData((Object)"rarityDuplicate"))) + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    5 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    6 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

