/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.rewards;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.rewards.RewardsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EditRewardConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public EditRewardConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType, Reward reward) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"cubeletType", (Object)cubeletType);
        conversation.getContext().setSessionData((Object)"rewardID", (Object)reward.getId());
        conversation.getContext().setSessionData((Object)"rewardName", (Object)reward.getName());
        conversation.getContext().setSessionData((Object)"rewardRarity", (Object)reward.getRarity().getId());
        conversation.getContext().setSessionData((Object)"rewardIcon", (Object)reward.getIcon());
        conversation.getContext().setSessionData((Object)"bypassDuplication", (Object)reward.isBypassDuplicationSystem());
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    private boolean rewardsIdExist(CubeletType cubeletType, String string) {
        for (Reward reward : cubeletType.getAllRewards()) {
            if (!reward.getId().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4", "5", "6"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"cubeletType");
            switch (string) {
                case "1": {
                    return new CommonPrompts.UncoloredStringPrompt(EditRewardConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Edit reward name, \"cancel\" to return.\n\n ", "rewardName");
                }
                case "2": {
                    return new CommonPrompts.CommonStringPrompt(EditRewardConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Edit reward rarity, \"cancel\" to return.\n  Available rarities: " + cubeletType.getRaritiesIDs() + "\n\n ", "rewardRarity");
                }
                case "3": {
                    Player player = (Player)conversationContext.getSessionData((Object)"player");
                    ItemStack itemStack = player.getInventory().getItemInHand();
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  AIR icon not allowed!\n ");
                        Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                        return this;
                    }
                    conversationContext.setSessionData((Object)"rewardIcon", (Object)itemStack);
                    conversationContext.getForWhom().sendRawMessage(ChatColor.GREEN + "  Succesfully setup reward icon.");
                    Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
                    return this;
                }
                case "4": {
                    return new CommonPrompts.BooleanPrompt(EditRewardConversation.this.main, (Prompt)this, ChatColor.YELLOW + "  Toggle bypass duplication system, \"cancel\" to return.\n  Available parameters: true or false\n\n ", "bypassDuplication");
                }
                case "5": {
                    if (conversationContext.getSessionData((Object)"rewardName") != null && conversationContext.getSessionData((Object)"rewardRarity") != null && conversationContext.getSessionData((Object)"rewardIcon") != null) {
                        if (cubeletType.getRarities().containsKey((String)conversationContext.getSessionData((Object)"rewardRarity"))) {
                            if (EditRewardConversation.this.rewardsIdExist(cubeletType, (String)conversationContext.getSessionData((Object)"rewardID"))) {
                                String string2 = (String)conversationContext.getSessionData((Object)"rewardID");
                                String string3 = (String)conversationContext.getSessionData((Object)"rewardName");
                                String string4 = (String)conversationContext.getSessionData((Object)"rewardRarity");
                                boolean bl = (Boolean)conversationContext.getSessionData((Object)"bypassDuplication");
                                ItemStack itemStack = (ItemStack)conversationContext.getSessionData((Object)"rewardIcon");
                                Reward reward = cubeletType.getReward(string2);
                                reward.setName(string3);
                                reward.setRarity(cubeletType.getRarities().get(string4));
                                reward.setIcon(itemStack.clone());
                                reward.setBypassDuplicationSystem(bl);
                                cubeletType.saveType();
                                EditRewardConversation.this.main.getCubeletRewardHandler().loadReward(cubeletType);
                                conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(EditRewardConversation.this.main.getLanguageHandler().getPrefix() + " &aYou edited reward &e" + reward.getId() + " &afrom rewards of cubelet type &e" + cubeletType.getId()));
                                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                                EditRewardConversation.this.main.getMenuHandler().reloadAllMenus(RewardsMenu.class);
                                Player player = (Player)conversationContext.getSessionData((Object)"player");
                                RewardsMenu rewardsMenu = new RewardsMenu(EditRewardConversation.this.main, player);
                                rewardsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                                rewardsMenu.open();
                                EditRewardConversation.this.main.getConversationHandler().removeConversation(player);
                                return Prompt.END_OF_CONVERSATION;
                            }
                            EditRewardConversation.this.main.getConversationHandler().removeConversation((Player)conversationContext.getSessionData((Object)"player"));
                            return Prompt.END_OF_CONVERSATION;
                        }
                        return new CommonPrompts.ErrorPrompt(EditRewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  This reward rarity not exist, please change it and try again\n  Write anything to continue\n ");
                    }
                    return new CommonPrompts.ErrorPrompt(EditRewardConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup ID, NAME, RARITY, PERMISSION and ICON to save reward!\n  Write anything to continue\n ");
                }
                case "6": {
                    return new CommonPrompts.ConfirmExitPrompt(EditRewardConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET REWARD EDITOR MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"rewardName") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Edit reward name (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Edit reward name (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"rewardName") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rewardRarity") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Edit reward rarity (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Edit reward rarity (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)((String)conversationContext.getSessionData((Object)"rewardRarity"))) + ChatColor.GRAY + ")\n";
            if (conversationContext.getSessionData((Object)"rewardIcon") == null) {
                string = string + ChatColor.RED + "    3 " + ChatColor.GRAY + "- Edit reward icon 'Item in Hand' (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n";
            } else {
                ItemStack itemStack = (ItemStack)conversationContext.getSessionData((Object)"rewardIcon");
                string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Edit reward icon 'Item in Hand' (" + ChatColor.YELLOW + itemStack.getType().name() + ChatColor.GRAY + ")\n";
            }
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Bypass duplication system (" + ChatColor.YELLOW + (Boolean)conversationContext.getSessionData((Object)"bypassDuplication") + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    5 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    6 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

