/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.Animation;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PluginHandler {
    private final Main main;

    public PluginHandler(Main main) {
        this.main = main;
    }

    public void reloadAll() {
        for (Player object : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.main.getMenuHandler().hasOpenedMenu(object)) continue;
            object.closeInventory();
        }
        this.main.getPlayerDataHandler().saveAllPlayerDataAsync();
        for (Animation animation : new ArrayList<Animation>(this.main.getAnimationHandler().getTasks())) {
            animation.stop();
        }
        this.main.getAnimationHandler().getTasks().clear();
        for (Entity entity : this.main.getAnimationHandler().getEntities()) {
            if (entity == null || entity.isDead()) continue;
            entity.remove();
        }
        this.main.getAnimationHandler().getEntities().clear();
        this.main.reloadConfig();
        this.main.setCraftingEnabled(this.main.getConfig().getBoolean("Crafting"));
        this.main.setPreviewEnabled(this.main.getConfig().getBoolean("RewardsPreview.Enabled"));
        this.main.getMenuHandler().setClickType(this.main.getConfig().getString("RewardsPreview.ClickType"));
        this.main.setCubeletsCommandEnabled(this.main.getConfig().getBoolean("NoCubelets.ExecuteCommand"));
        this.main.setNoCubeletsCommand(this.main.getConfig().getString("NoCubelets.Command"));
        this.main.setNoCubeletsCommandExecutor(this.main.getConfig().getString("NoCubelets.Executor"));
        this.main.setDuplicationEnabled(this.main.getConfig().getBoolean("RewardsDuplication.Enabled"));
        this.main.setDuplicationPermissionCommand(this.main.getConfig().getString("RewardsDuplication.PermissionCommand"));
        this.main.setDuplicationPointsCommand(this.main.getConfig().getString("RewardsDuplication.PointsCommand"));
        this.main.setDuplicationVisibleAllPlayers(this.main.getConfig().getBoolean("Holograms.Duplication.VisibleToAllPlayers"));
        this.main.setNoGuiMode(this.main.getConfig().getBoolean("NoGuiMode"));
        this.main.setRewardSorting(this.main.getConfig().getBoolean("RewardAutoSorting"));
        this.main.setLiveGuiUpdates(this.main.getConfig().getBoolean("LiveGuiUpdates"));
        this.main.setSerializeBase64(this.main.getConfig().getBoolean("SerializeBase64"));
        this.main.setGiftCubelets(this.main.getConfig().getBoolean("GiftCubeletsCommand"));
        this.main.setAnimationsByPlayer(this.main.getConfig().getBoolean("AnimationsByPlayer"));
        this.main.setKeysEnabled(this.main.getConfig().getBoolean("UseKeys"));
        this.main.setBroadcastEnabled(this.main.getConfig().getBoolean("BroadcastReward"));
        this.main.setLoginReminder(this.main.getConfig().getBoolean("LoginReminder"));
        this.main.getLanguageHandler().loadLanguage("en");
        this.main.getLanguageHandler().loadLanguage("es");
        this.main.getLanguageHandler().setLanguage(this.main.getConfig().getString("Language").toLowerCase());
        this.main.getHologramTask().stop();
        this.main.getLiveGuiTask().stop();
        this.main.getHologramImplementation().removeHolograms();
        this.main.getLanguageHandler().pushMessages();
        this.main.getCubeletBoxHandler().loadBoxes();
        this.main.getCubeletTypesHandler().loadTypes();
        this.main.getCubeletRarityHandler().loadRarities();
        this.main.getCubeletRewardHandler().loadRewards();
        this.main.getCubeletTypesHandler().printLog();
        this.main.getCubeletCraftingHandler().loadCrafting();
        this.main.getLayoutHandler().loadLayouts();
        this.main.getAnimationHandler().loadAnimations();
        this.main.getHologramHandler().getColorAnimation().setColors(this.main.getConfig().getStringList("Holograms.ColorAnimation"));
        int n = this.main.getConfig().getInt("Holograms.VisibilityDistance");
        this.main.getHologramHandler().setVisibilityDistance(n * n);
        this.main.getHologramImplementation().loadHolograms();
        this.main.getHologramTask().start();
        if (this.main.isLiveGuiUpdates()) {
            this.main.getLiveGuiTask().start();
        }
    }
}

