/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.interfaces.LootDateComparator;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.objects.loothistory.LootHistory;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.TimeAPI.TimeUtils;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class LootHistoryMenu
extends Menu {
    public LootHistoryMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        ItemStack itemStack;
        int n3;
        Boolean bl = (Boolean)this.getAttribute(Menu.AttrType.OPENED_EXTERNALLY_ATTR);
        Player player = this.getOwner();
        Profile profile = this.getMain().getPlayerDataHandler().getData(player);
        List<LootHistory> list = profile.getLootHistory();
        list.sort(new LootDateComparator());
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("loothistory");
        int n4 = this.getPageSize(gUILayout);
        if (n > 0 && list.size() < n * n4 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > n4) {
            list = list.subList(n * n4, Math.min(n * n4 + n4, list.size()));
        }
        int n5 = this.getNeededSize(gUILayout, list.size());
        Inventory inventory = this.createInventory(n5, gUILayout.getMessage("Title"));
        if (n > 0) {
            n3 = gUILayout.getBoolean("Items.PreviousPage.ShowPageNumber") ? n : 1;
            ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PreviousPage.Material")).get().parseMaterial(), n3).setName(gUILayout.getMessage("Items.PreviousPage.Name")).toItemStack();
            itemStack2 = NBTEditor.set(itemStack2, "previous", "action");
            if (gUILayout.getSlot("PreviousPage") >= 0) {
                inventory.setItem(n5 - 10 + gUILayout.getSlot("PreviousPage"), itemStack2);
            }
        }
        if (profile.getLootHistory().size() > (n + 1) * n4) {
            n3 = gUILayout.getBoolean("Items.NextPage.ShowPageNumber") ? n + 2 : 1;
            ItemStack itemStack4 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NextPage.Material")).get().parseMaterial(), n3).setName(gUILayout.getMessage("Items.NextPage.Name")).toItemStack();
            itemStack4 = NBTEditor.set(itemStack4, "next", "action");
            if (gUILayout.getSlot("NextPage") >= 0) {
                inventory.setItem(n5 - 10 + gUILayout.getSlot("NextPage"), itemStack4);
            }
        }
        if (!bl.booleanValue()) {
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Back.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Back.Name")).setLore(gUILayout.getMessageList("Items.Back.Lore")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "back", "action");
            inventory.setItem(n5 - 10 + gUILayout.getSlot("Back"), itemStack);
        } else {
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Close.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Close.Name")).setLore(gUILayout.getMessageList("Items.Close.Lore")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "close", "action");
            inventory.setItem(n5 - 10 + gUILayout.getSlot("Close"), itemStack);
        }
        for (n2 = 0; n2 <= n5 - 10; ++n2) {
            inventory.setItem(n2, null);
        }
        if (list.size() > 0) {
            for (LootHistory lootHistory : list) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : gUILayout.getMessageList("Items.LootItem.Lore")) {
                    string = string.replaceAll("%cubelet_name%", lootHistory.getCubeletName());
                    string = string.replaceAll("%received%", TimeUtils.millisToLongDHMS(System.currentTimeMillis() - lootHistory.getReceived()));
                    arrayList.add(Utils.translate(string));
                }
                ItemStack itemStack5 = new ItemBuilder(lootHistory.getRewardHistory().getItemStack().clone()).setName(Utils.translate(gUILayout.getMessage("Items.LootItem.Name").replaceAll("%reward_name%", Matcher.quoteReplacement(lootHistory.getRewardHistory().getName())))).setLore(arrayList).hideAttributes().toItemStack();
                itemStack5 = NBTEditor.set(itemStack5, UUID.randomUUID().toString(), "randomUUID");
                inventory.addItem(new ItemStack[]{itemStack5});
            }
        } else {
            n2 = 0;
            if (!gUILayout.getBoolean("Size.Dynamic") && gUILayout.getSlot("NoHistory") <= n5 - 10) {
                n2 = gUILayout.getSlot("NoHistory");
            }
            inventory.setItem(n2, new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NoHistory.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.NoHistory.Name")).setLore(gUILayout.getMessageList("Items.NoHistory.Lore")).toItemStack());
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        int n;
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = this.getOwner();
        int n2 = inventoryClickEvent.getRawSlot();
        if (n2 >= (n = player.getOpenInventory().getTopInventory().getSize()) - 9 && n2 <= n) {
            String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
            if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (string == null) {
                return;
            }
            switch (string) {
                case "previous": {
                    this.previousPage();
                    break;
                }
                case "next": {
                    this.nextPage();
                    break;
                }
                case "close": {
                    player.closeInventory();
                    break;
                }
                case "back": {
                    new CubeletsMenu(this.getMain(), player).open();
                }
            }
        }
        player.updateInventory();
    }

    @Override
    public void OnMenuClosed() {
    }

    private int getNeededSize(GUILayout gUILayout, int n) {
        int n2 = 0;
        int n3 = gUILayout.getInteger("Size.Max-History-Rows");
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > 5) {
            n3 = 5;
        }
        n2 = gUILayout.getBoolean("Size.Dynamic") ? (n3 == 1 ? 1 : (n3 == 2 ? (n <= 9 ? 1 : 2) : (n3 == 3 ? (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : 3)) : (n3 == 4 ? (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : (n >= 18 && n <= 27 ? 3 : 4))) : (n >= 0 && n <= 9 ? 1 : (n >= 9 && n <= 18 ? 2 : (n >= 18 && n <= 27 ? 3 : (n >= 27 && n <= 36 ? 4 : 5)))))))) : n3;
        return (n2 + 1) * 9;
    }

    private int getPageSize(GUILayout gUILayout) {
        int n = gUILayout.getInteger("Size.Max-History-Rows");
        if (n < 1) {
            n = 1;
        } else if (n > 5) {
            n = 5;
        }
        return n * 9;
    }
}

