/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.player;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerAnimationMenu
extends Menu {
    public PlayerAnimationMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        ItemStack itemStack;
        int n2;
        List list;
        Player player = this.getOwner();
        player.updateInventory();
        Profile profile = this.getMain().getPlayerDataHandler().getData(player);
        if (!profile.getAnimation().equalsIgnoreCase("random") && ((AnimationSettings)((Object)(list = this.getMain().getAnimationHandler().getAnimationSetting(profile.getAnimation())))).isNeedPermission() && !this.getMain().getAnimationHandler().haveAnimationPermission(player, (AnimationSettings)((Object)list))) {
            profile.setAnimation(AnimationHandler.DEFAULT_ANIMATION);
        }
        list = new ArrayList<AnimationSettings>(this.getMain().getAnimationHandler().getAnimationSettings());
        Collections.sort(list);
        if (n < 0) {
            this.openPage(0);
            return;
        }
        if (n > 0 && list.size() < n * 14 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > 14) {
            list = list.subList(n * 14, Math.min(n * 14 + 14, list.size()));
        }
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("animations");
        Inventory inventory = this.createInventory(45, gUILayout.getMessage("Title"));
        if (n > 0) {
            n2 = gUILayout.getBoolean("Items.PreviousPage.ShowPageNumber") ? n : 1;
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.PreviousPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.PreviousPage.Name")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "previous", "action");
            if (gUILayout.getSlot("PreviousPage") >= 0) {
                inventory.setItem(35 + gUILayout.getSlot("PreviousPage"), itemStack);
            }
        }
        if (this.getMain().getAnimationHandler().getAnimationSettings().size() > (n + 1) * 14) {
            n2 = gUILayout.getBoolean("Items.NextPage.ShowPageNumber") ? n + 2 : 1;
            itemStack = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.NextPage.Material")).get().parseMaterial(), n2).setName(gUILayout.getMessage("Items.NextPage.Name")).toItemStack();
            itemStack = NBTEditor.set(itemStack, "next", "action");
            if (gUILayout.getSlot("NextPage") >= 0) {
                inventory.setItem(inventory.getSize() - 10 + gUILayout.getSlot("NextPage"), itemStack);
            }
        }
        ItemStack itemStack2 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Back.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Back.Name")).setLore(gUILayout.getMessageList("Items.Back.Lore")).toItemStack();
        itemStack2 = NBTEditor.set(itemStack2, "back", "action");
        inventory.setItem(inventory.getSize() - 10 + gUILayout.getSlot("Back"), itemStack2);
        itemStack = XMaterial.GRAY_STAINED_GLASS_PANE.parseItem();
        this.fillTopSide(itemStack, 3);
        for (AnimationSettings animationSettings : list) {
            inventory.addItem(new ItemStack[]{this.getAnimationItem(player, gUILayout, animationSettings.getId())});
        }
        ItemStack itemStack3 = this.getRandomAnimationItem(player, gUILayout);
        itemStack3 = NBTEditor.set(itemStack3, "random", "action");
        inventory.setItem(inventory.getSize() - 10 + gUILayout.getSlot("RandomAnimation"), itemStack3);
        this.fillTopSide(null, 3);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        Player player = this.getOwner();
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (string == null) {
            return;
        }
        switch (string) {
            case "previous": {
                this.previousPage();
                break;
            }
            case "next": {
                this.nextPage();
                break;
            }
            case "random": {
                String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "status");
                if (!string2.equalsIgnoreCase("disabled")) break;
                this.getMain().getPlayerDataHandler().getData(player).setAnimation("random");
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMyMenu();
                break;
            }
            case "animation": {
                String string3 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "animation");
                String string4 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "status");
                if (!string4.equalsIgnoreCase("unlocked")) break;
                this.getMain().getPlayerDataHandler().getData(player).setAnimation(string3);
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMyMenu();
                break;
            }
            case "back": {
                new CubeletsMenu(this.getMain(), player).open();
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }

    private ItemStack getAnimationItem(Player player, GUILayout gUILayout, String string) {
        AnimationSettings animationSettings = this.getMain().getAnimationHandler().getAnimationSetting(string);
        ItemStack itemStack = animationSettings.getDisplayItem().clone();
        itemStack = animationSettings.isNeedPermission() ? (this.getMain().getAnimationHandler().haveAnimationPermission(player, animationSettings) ? (!this.getMain().getPlayerDataHandler().getData(player).getAnimation().equalsIgnoreCase(string) ? this.getItem(gUILayout, animationSettings, "Unlocked", itemStack) : this.getItem(gUILayout, animationSettings, "Selected", itemStack)) : this.getItem(gUILayout, animationSettings, "Locked", XMaterial.GRAY_DYE.parseItem())) : (!this.getMain().getPlayerDataHandler().getData(player).getAnimation().equalsIgnoreCase(string) ? this.getItem(gUILayout, animationSettings, "Unlocked", itemStack) : this.getItem(gUILayout, animationSettings, "Selected", itemStack));
        itemStack = NBTEditor.set(itemStack, "animation", "action");
        itemStack = NBTEditor.set(itemStack, string, "animation");
        return itemStack;
    }

    private ItemStack getItem(GUILayout gUILayout, AnimationSettings animationSettings, String string, ItemStack itemStack) {
        String string2 = gUILayout.getMessage("Items.Animation." + string + ".Name").replaceAll("%animation%", animationSettings.getFormatedDisplayName());
        List<String> list = gUILayout.getMessageList("Items.Animation." + string + ".Lore");
        ItemStack itemStack2 = string.equalsIgnoreCase("Selected") ? new ItemBuilder(itemStack).setName(string2).setLore(list).addGlow().hideAttributes().toItemStack() : new ItemBuilder(itemStack).setName(string2).setLore(list).hideAttributes().toItemStack();
        return NBTEditor.set(itemStack2, string.toLowerCase(), "status");
    }

    private ItemStack getRandomAnimationItem(Player player, GUILayout gUILayout) {
        String string;
        ItemStack itemStack = new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).toItemStack();
        if (!this.getMain().getPlayerDataHandler().getData(player).getAnimation().equalsIgnoreCase("random")) {
            String string2 = gUILayout.getMessage("Items.RandomAnimation.NoSelected.Name");
            List<String> list = gUILayout.getMessageList("Items.RandomAnimation.NoSelected.Lore");
            itemStack = new ItemBuilder(itemStack).setName(string2).setLore(list).toItemStack();
            string = "disabled";
        } else {
            String string3 = gUILayout.getMessage("Items.RandomAnimation.Selected.Name");
            List<String> list = gUILayout.getMessageList("Items.RandomAnimation.Selected.Lore");
            itemStack = new ItemBuilder(itemStack).setName(string3).setLore(list).addGlow().toItemStack();
            string = "enabled";
        }
        return NBTEditor.set(itemStack, string.toLowerCase(), "status");
    }
}

