/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.davidml16.acubelets.utils.ParticlesAPI.PackageType;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
        Class<?>[] classArray2 = DataType.getPrimitive(classArray);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!DataType.compare(DataType.getPrimitive(constructor.getParameterTypes()), classArray2)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("There is no such constructor in this class with the specified parameter types");
    }

    public static Constructor<?> getConstructor(String string, PackageType packageType, Class<?> ... classArray) {
        return ReflectionUtils.getConstructor(packageType.getClass(string), classArray);
    }

    public static Object instantiateObject(Class<?> clazz, Object ... objectArray) {
        return ReflectionUtils.getConstructor(clazz, DataType.getPrimitive(objectArray)).newInstance(objectArray);
    }

    public static Object instantiateObject(String string, PackageType packageType, Object ... objectArray) {
        return ReflectionUtils.instantiateObject(packageType.getClass(string), objectArray);
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Class<?>[] classArray2 = DataType.getPrimitive(classArray);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string) || !DataType.compare(DataType.getPrimitive(method.getParameterTypes()), classArray2)) continue;
            return method;
        }
        throw new NoSuchMethodException("There is no such method in this class with the specified name and parameter types");
    }

    public static Method getMethod(String string, PackageType packageType, String string2, Class<?> ... classArray) {
        return ReflectionUtils.getMethod(packageType.getClass(string), string2, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) {
        return ReflectionUtils.getMethod(object.getClass(), string, DataType.getPrimitive(objectArray)).invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, Class<?> clazz, String string, Object ... objectArray) {
        return ReflectionUtils.getMethod(clazz, string, DataType.getPrimitive(objectArray)).invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, String string, PackageType packageType, String string2, Object ... objectArray) {
        return ReflectionUtils.invokeMethod(object, packageType.getClass(string), string2, objectArray);
    }

    public static Field getField(Class<?> clazz, boolean bl, String string) {
        Field field = bl ? clazz.getDeclaredField(string) : clazz.getField(string);
        field.setAccessible(true);
        return field;
    }

    public static Field getField(String string, PackageType packageType, boolean bl, String string2) {
        return ReflectionUtils.getField(packageType.getClass(string), bl, string2);
    }

    public static Object getValue(Object object, Class<?> clazz, boolean bl, String string) {
        return ReflectionUtils.getField(clazz, bl, string).get(object);
    }

    public static Object getValue(Object object, String string, PackageType packageType, boolean bl, String string2) {
        return ReflectionUtils.getValue(object, packageType.getClass(string), bl, string2);
    }

    public static Object getValue(Object object, boolean bl, String string) {
        return ReflectionUtils.getValue(object, object.getClass(), bl, string);
    }

    public static void setValue(Object object, Class<?> clazz, boolean bl, String string, Object object2) {
        ReflectionUtils.getField(clazz, bl, string).set(object, object2);
    }

    public static void setValue(Object object, String string, PackageType packageType, boolean bl, String string2, Object object2) {
        ReflectionUtils.setValue(object, packageType.getClass(string), bl, string2, object2);
    }

    public static void setValue(Object object, boolean bl, String string, Object object2) {
        ReflectionUtils.setValue(object, object.getClass(), bl, string, object2);
    }

    public static enum DataType {
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        INTEGER(Integer.TYPE, Integer.class),
        LONG(Long.TYPE, Long.class),
        CHARACTER(Character.TYPE, Character.class),
        FLOAT(Float.TYPE, Float.class),
        DOUBLE(Double.TYPE, Double.class),
        BOOLEAN(Boolean.TYPE, Boolean.class);

        private static final Map<Class<?>, DataType> CLASS_MAP;
        private final Class<?> primitive;
        private final Class<?> reference;

        private DataType(Class<?> clazz, Class<?> clazz2) {
            this.primitive = clazz;
            this.reference = clazz2;
        }

        public Class<?> getPrimitive() {
            return this.primitive;
        }

        public Class<?> getReference() {
            return this.reference;
        }

        public static DataType fromClass(Class<?> clazz) {
            return CLASS_MAP.get(clazz);
        }

        public static Class<?> getPrimitive(Class<?> clazz) {
            DataType dataType = DataType.fromClass(clazz);
            return dataType == null ? clazz : dataType.getPrimitive();
        }

        public static Class<?> getReference(Class<?> clazz) {
            DataType dataType = DataType.fromClass(clazz);
            return dataType == null ? clazz : dataType.getReference();
        }

        public static Class<?>[] getPrimitive(Class<?>[] classArray) {
            int n = classArray == null ? 0 : classArray.length;
            Class[] classArray2 = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray2[i] = DataType.getPrimitive(classArray[i]);
            }
            return classArray2;
        }

        public static Class<?>[] getReference(Class<?>[] classArray) {
            int n = classArray == null ? 0 : classArray.length;
            Class[] classArray2 = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray2[i] = DataType.getReference(classArray[i]);
            }
            return classArray2;
        }

        public static Class<?>[] getPrimitive(Object[] objectArray) {
            int n = objectArray == null ? 0 : objectArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = DataType.getPrimitive(objectArray[i].getClass());
            }
            return classArray;
        }

        public static Class<?>[] getReference(Object[] objectArray) {
            int n = objectArray == null ? 0 : objectArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = DataType.getReference(objectArray[i].getClass());
            }
            return classArray;
        }

        public static boolean compare(Class<?>[] classArray, Class<?>[] classArray2) {
            if (classArray == null || classArray2 == null || classArray.length != classArray2.length) {
                return false;
            }
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                Class<?> clazz2 = classArray2[i];
                if (clazz.equals(clazz2) || clazz.isAssignableFrom(clazz2)) continue;
                return false;
            }
            return true;
        }

        static {
            CLASS_MAP = new HashMap();
            for (DataType dataType : DataType.values()) {
                CLASS_MAP.put(dataType.primitive, dataType);
                CLASS_MAP.put(dataType.reference, dataType);
            }
        }
    }
}

