/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.ChatColor;

public class Utils {
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)" + String.valueOf('&') + "[0-9A-FK-OR]");
    private static final Pattern hexPattern = Pattern.compile("\\{#([A-Fa-f0-9]{6})}");
    public static final char COLOR_CHAR = '\u00a7';
    private static Map<ChatColor, ColorSet<Integer, Integer, Integer>> colorMap = new HashMap<ChatColor, ColorSet<Integer, Integer, Integer>>();

    private static String translateHexColorCodes(String string) {
        Matcher matcher = hexPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, "\u00a7x\u00a7" + string2.charAt(0) + '\u00a7' + string2.charAt(1) + '\u00a7' + string2.charAt(2) + '\u00a7' + string2.charAt(3) + '\u00a7' + string2.charAt(4) + '\u00a7' + string2.charAt(5));
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    public static String translate(String string) {
        if (XMaterial.supports(16)) {
            string = Utils.translateHexColorCodes(string);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String removeColors(String string) {
        return string == null ? null : STRIP_COLOR_PATTERN.matcher(string).replaceAll("");
    }

    public static ChatColor fromRGB(int n, int n2, int n3) {
        TreeMap treeMap = new TreeMap();
        colorMap.forEach((chatColor, colorSet) -> {
            int n4 = Math.abs(n - colorSet.getRed());
            int n5 = Math.abs(n2 - colorSet.getGreen());
            int n6 = Math.abs(n3 - colorSet.getBlue());
            treeMap.put(n4 + n5 + n6, chatColor);
        });
        return (ChatColor)treeMap.firstEntry().getValue();
    }

    public static ChatColor getColorByText(String string) {
        for (ChatColor chatColor : colorMap.keySet()) {
            if (!string.contains("&" + chatColor.getChar())) continue;
            return chatColor;
        }
        return ChatColor.WHITE;
    }

    public static ColorSet<Integer, Integer, Integer> getRGBbyColor(ChatColor chatColor) {
        return colorMap.get(chatColor);
    }

    static {
        colorMap.put(ChatColor.BLACK, new ColorSet(0, 0, 0));
        colorMap.put(ChatColor.DARK_BLUE, new ColorSet(0, 0, 170));
        colorMap.put(ChatColor.DARK_GREEN, new ColorSet(0, 170, 0));
        colorMap.put(ChatColor.DARK_AQUA, new ColorSet(0, 170, 170));
        colorMap.put(ChatColor.DARK_RED, new ColorSet(170, 0, 0));
        colorMap.put(ChatColor.DARK_PURPLE, new ColorSet(170, 0, 170));
        colorMap.put(ChatColor.GOLD, new ColorSet(255, 170, 0));
        colorMap.put(ChatColor.GRAY, new ColorSet(170, 170, 170));
        colorMap.put(ChatColor.DARK_GRAY, new ColorSet(85, 85, 85));
        colorMap.put(ChatColor.BLUE, new ColorSet(85, 85, 255));
        colorMap.put(ChatColor.GREEN, new ColorSet(85, 255, 85));
        colorMap.put(ChatColor.AQUA, new ColorSet(85, 255, 255));
        colorMap.put(ChatColor.RED, new ColorSet(255, 85, 85));
        colorMap.put(ChatColor.LIGHT_PURPLE, new ColorSet(255, 85, 255));
        colorMap.put(ChatColor.YELLOW, new ColorSet(255, 255, 85));
        colorMap.put(ChatColor.WHITE, new ColorSet(255, 255, 255));
    }

    public static class ColorSet<I extends Number, I1 extends Number, I2 extends Number> {
        Integer red = 0;
        Integer green = 0;
        Integer blue = 0;

        ColorSet(Integer n, Integer n2, Integer n3) {
            this.red = n;
            this.green = n2;
            this.blue = n3;
        }

        public Integer getRed() {
            return this.red;
        }

        public Integer getGreen() {
            return this.green;
        }

        public Integer getBlue() {
            return this.blue;
        }
    }
}

