/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.XSeries;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.davidml16.acubelets.utils.XSeries.SkullUtils;
import me.davidml16.acubelets.utils.XSeries.XEnchantment;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import me.davidml16.acubelets.utils.XSeries.XPotion;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class XItemStack {
    public static void serializeIcon(ItemStack itemStack, FileConfiguration fileConfiguration, String string, boolean bl) {
        Object object;
        Object object2;
        Objects.requireNonNull(itemStack, "Cannot serialize a null item");
        Objects.requireNonNull(fileConfiguration, "Cannot serialize item from a null configuration section.");
        ItemMeta itemMeta = itemStack.getItemMeta();
        fileConfiguration.set(string + ".material", (Object)itemStack.getType().name());
        if (itemStack.getAmount() > 1) {
            fileConfiguration.set(string + ".amount", (Object)itemStack.getAmount());
        }
        if (XMaterial.isNewVersion()) {
            if (itemMeta instanceof Damageable && (object2 = (Damageable)itemMeta).hasDamage()) {
                fileConfiguration.set(string + ".damage", (Object)object2.getDamage());
            }
        } else {
            short s = itemStack.getDurability();
            if (s > 0) {
                fileConfiguration.set(string + ".damage", (Object)s);
            }
        }
        if (bl && itemMeta.hasLore()) {
            object2 = new ArrayList();
            for (ArrayList<String> arrayList : itemMeta.getLore()) {
                object2.add(((String)((Object)arrayList)).replace('\u00a7', '&'));
            }
            fileConfiguration.set(string + ".lore", object2);
        }
        if (bl && XMaterial.supports(11)) {
            fileConfiguration.set(string + ".unbreakable", (Object)itemMeta.isUnbreakable());
        }
        if (XMaterial.supports(14) && itemMeta.hasCustomModelData()) {
            fileConfiguration.set(string + ".custom-model", (Object)itemMeta.getCustomModelData());
        }
        if (bl) {
            if (itemMeta.getEnchants().size() > 0) {
                fileConfiguration.set(string + ".enchanted", (Object)true);
            } else {
                fileConfiguration.set(string + ".enchanted", (Object)false);
            }
        }
        if (itemMeta.getItemFlags().size() > 0) {
            object2 = new ArrayList();
            for (ArrayList<String> arrayList : itemMeta.getItemFlags()) {
                object2.add(arrayList.name());
            }
            fileConfiguration.set(string + ".flags", object2);
        }
        if (itemMeta instanceof SkullMeta) {
            object2 = SkullUtils.getSkinValue(itemStack);
            if (object2 == null) {
                if (((SkullMeta)itemMeta).hasOwner()) {
                    if (XMaterial.supports(12)) {
                        fileConfiguration.set(string + ".skull", (Object)((SkullMeta)itemMeta).getOwningPlayer().getUniqueId().toString());
                    } else {
                        fileConfiguration.set(string + ".skull", (Object)((SkullMeta)itemMeta).getOwner());
                    }
                }
            } else {
                fileConfiguration.set(string + ".skull", object2);
            }
        } else if (itemMeta instanceof BannerMeta) {
            object2 = (BannerMeta)itemMeta;
            object = fileConfiguration.createSection(string + ".patterns");
            for (Pattern pattern : object2.getPatterns()) {
                object.set(pattern.getPattern().name(), (Object)pattern.getColor().name());
            }
        } else if (itemMeta instanceof LeatherArmorMeta) {
            object2 = (LeatherArmorMeta)itemMeta;
            object = object2.getColor();
            fileConfiguration.set(string + ".color", (Object)(object.getRed() + ", " + object.getGreen() + ", " + object.getBlue()));
        } else if (itemMeta instanceof PotionMeta) {
            if (XMaterial.supports(9)) {
                ArrayList<String> arrayList;
                object2 = (PotionMeta)itemMeta;
                object = object2.getCustomEffects();
                arrayList = new ArrayList<String>(object.size());
                PotionData potionData = object.iterator();
                while (potionData.hasNext()) {
                    PotionEffect potionEffect = (PotionEffect)potionData.next();
                    arrayList.add(potionEffect.getType().getName() + ", " + potionEffect.getDuration() + ", " + potionEffect.getAmplifier());
                }
                fileConfiguration.set(string + "custom-effects", arrayList);
                potionData = object2.getBasePotionData();
                fileConfiguration.set(string + "base-effect", (Object)(potionData.getType().name() + ", " + potionData.isExtended() + ", " + potionData.isUpgraded()));
                if (object2.hasColor()) {
                    fileConfiguration.set(string + "color", (Object)object2.getColor().asRGB());
                }
            } else if (itemStack.getDurability() != 0) {
                object2 = Potion.fromItemStack((ItemStack)itemStack);
                fileConfiguration.set("level", (Object)object2.getLevel());
                fileConfiguration.set("base-effect", (Object)(object2.getType().name() + ", " + object2.hasExtendedDuration() + ", " + object2.isSplash()));
            }
        }
    }

    public static ItemStack deserializeIcon(FileConfiguration fileConfiguration, String string, boolean bl) {
        int n;
        Object object4;
        Object object22;
        Object object3;
        int n2;
        Objects.requireNonNull(fileConfiguration, "Cannot deserialize item to a null configuration section.");
        String string2 = fileConfiguration.getString(string + ".material");
        if (string2 == null) {
            return null;
        }
        Optional<XMaterial> optional = XMaterial.matchXMaterial(string2);
        if (!optional.isPresent()) {
            return null;
        }
        ItemStack itemStack = optional.get().parseItem();
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n3 = fileConfiguration.getInt(string + ".amount");
        if (n3 > 1) {
            itemStack.setAmount(n3);
        }
        if (XMaterial.isNewVersion()) {
            if (itemMeta instanceof Damageable && (n2 = fileConfiguration.getInt(string + ".damage")) > 0) {
                ((Damageable)itemMeta).setDamage(n2);
            }
        } else {
            n2 = fileConfiguration.getInt(string + ".damage");
            if (n2 > 0) {
                itemStack.setDurability((short)n2);
            }
        }
        if (itemStack.getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
            String string3 = fileConfiguration.getString(string + ".skull");
            if (string3 != null) {
                SkullUtils.applySkin(itemMeta, string3);
            }
        } else if (itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)itemMeta;
            object3 = fileConfiguration.getConfigurationSection(string + ".patterns");
            if (object3 != null) {
                for (Object object22 : object3.getKeys(false)) {
                    PatternType patternType = PatternType.getByIdentifier((String)object22);
                    if (patternType == null) {
                        patternType = (PatternType)Enums.getIfPresent(PatternType.class, (String)((String)object22).toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                    }
                    DyeColor dyeColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)object3.getString((String)object22).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    bannerMeta.addPattern(new Pattern(dyeColor, patternType));
                }
            }
        } else if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            object3 = fileConfiguration.getString(string + ".color");
            if (object3 != null) {
                leatherArmorMeta.setColor(XItemStack.parseColor((String)object3));
            }
        } else if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            for (Object object4 : fileConfiguration.getStringList(string + ".effects")) {
                object22 = XPotion.parseEffect((String)object4);
                if (!((XPotion.Effect)object22).hasChance()) continue;
                potionMeta.addCustomEffect(((XPotion.Effect)object22).getEffect(), true);
            }
            object3 = fileConfiguration.getString(string + ".base-effect");
            if (!Strings.isNullOrEmpty((String)object3)) {
                object4 = StringUtils.split((String)object3, (char)',');
                object22 = (PotionType)Enums.getIfPresent(PotionType.class, (String)object4[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.UNCRAFTABLE);
                boolean bl2 = ((String[])object4).length != 1 && Boolean.parseBoolean(object4[1].trim());
                boolean bl3 = ((String[])object4).length > 2 && Boolean.parseBoolean(object4[2].trim());
                PotionData potionData = new PotionData((PotionType)object22, bl2, bl3);
                potionMeta.setBasePotionData(potionData);
            }
            if (fileConfiguration.contains(string + ".color")) {
                potionMeta.setColor(Color.fromRGB((int)fileConfiguration.getInt(string + ".color")));
            }
        }
        if (bl && XMaterial.supports(11) && fileConfiguration.contains(string + ".unbreakable")) {
            itemMeta.setUnbreakable(fileConfiguration.getBoolean(string + ".unbreakable", false));
        }
        if (XMaterial.supports(14) && (n = fileConfiguration.getInt(string + ".model-data")) != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        List list = fileConfiguration.getStringList("flags");
        for (Object object4 : list) {
            if (((String)(object4 = ((String)object4).toUpperCase(Locale.ENGLISH))).equals("ALL")) {
                itemMeta.addItemFlags(ItemFlag.values());
                break;
            }
            object22 = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)object4).orNull();
            if (object22 == null) continue;
            itemMeta.addItemFlags(new ItemFlag[]{object22});
        }
        if (bl && fileConfiguration.contains(string + ".enchanted") && fileConfiguration.getBoolean(string + ".enchanted")) {
            itemMeta.addEnchant(Enchantment.DURABILITY, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (bl && fileConfiguration.contains(string + ".lore")) {
            object3 = fileConfiguration.getStringList(string + ".lore");
            if (!object3.isEmpty()) {
                object4 = new ArrayList();
                object22 = object3.iterator();
                while (object22.hasNext()) {
                    String string4 = (String)object22.next();
                    if (string4.isEmpty()) {
                        object4.add(" ");
                        continue;
                    }
                    for (String string5 : StringUtils.splitPreserveAllTokens((String)string4, (char)'\n')) {
                        if (string5.isEmpty()) {
                            object4.add(" ");
                            continue;
                        }
                        string5 = ChatColor.translateAlternateColorCodes((char)'&', (String)string5);
                        object4.add(string5);
                    }
                }
                itemMeta.setLore((List)object4);
            } else {
                object4 = fileConfiguration.getString(string + ".lore");
                if (!Strings.isNullOrEmpty((String)object4)) {
                    object22 = new ArrayList();
                    for (String string6 : StringUtils.splitPreserveAllTokens((String)object4, (char)'\n')) {
                        if (string6.isEmpty()) {
                            object22.add(" ");
                            continue;
                        }
                        string6 = ChatColor.translateAlternateColorCodes((char)'&', (String)string6);
                        object22.add(string6);
                    }
                    itemMeta.setLore((List)object22);
                }
            }
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    /*
     * WARNING - void declaration
     */
    public static void serializeItem(ItemStack itemStack, FileConfiguration fileConfiguration, String string) {
        block25: {
            Object object;
            ItemMeta itemMeta;
            block30: {
                block31: {
                    Object object22;
                    block29: {
                        block28: {
                            block26: {
                                block27: {
                                    block24: {
                                        Objects.requireNonNull(itemStack, "Cannot serialize a null item");
                                        Objects.requireNonNull(fileConfiguration, "Cannot serialize item from a null configuration section.");
                                        itemMeta = itemStack.getItemMeta();
                                        if (itemMeta.hasDisplayName()) {
                                            fileConfiguration.set(string + ".name", (Object)itemMeta.getDisplayName().replace('\u00a7', '&'));
                                        }
                                        if (itemMeta.hasLore()) {
                                            object = new ArrayList();
                                            for (String string2 : itemMeta.getLore()) {
                                                object.add(string2.replace('\u00a7', '&'));
                                            }
                                            fileConfiguration.set(string + ".lore", object);
                                        }
                                        if (itemStack.getAmount() > 1) {
                                            fileConfiguration.set(string + ".amount", (Object)itemStack.getAmount());
                                        }
                                        if (XMaterial.isNewVersion()) {
                                            if (itemMeta instanceof Damageable && (object = (Damageable)itemMeta).hasDamage()) {
                                                fileConfiguration.set(string + ".damage", (Object)object.getDamage());
                                            }
                                        } else if (itemStack.getType().getMaxDurability() > 0) {
                                            fileConfiguration.set(string + ".damage", (Object)itemStack.getDurability());
                                        }
                                        fileConfiguration.set(string + ".material", (Object)itemStack.getType().name());
                                        if (XMaterial.supports(11) && itemMeta.isUnbreakable()) {
                                            fileConfiguration.set(string + ".unbreakable", (Object)true);
                                        }
                                        if (XMaterial.supports(14) && itemMeta.hasCustomModelData()) {
                                            fileConfiguration.set(string + ".custom-model", (Object)itemMeta.getCustomModelData());
                                        }
                                        for (Map.Entry entry : itemMeta.getEnchants().entrySet()) {
                                            String string3 = "enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
                                            fileConfiguration.set(string + "." + string3, entry.getValue());
                                        }
                                        if (itemMeta.getItemFlags().size() != 0) {
                                            object = new ArrayList();
                                            for (ItemFlag itemFlag : itemMeta.getItemFlags()) {
                                                object.add(itemFlag.name());
                                            }
                                            fileConfiguration.set(string + ".flags", object);
                                        }
                                        if (XMaterial.supports(14) && itemMeta.hasAttributeModifiers()) {
                                            for (Map.Entry entry : itemMeta.getAttributeModifiers().entries()) {
                                                String string4 = string + ".attributes." + ((Attribute)entry.getKey()).name() + '.';
                                                object22 = (AttributeModifier)entry.getValue();
                                                fileConfiguration.set(string4 + "id", (Object)object22.getUniqueId().toString());
                                                fileConfiguration.set(string4 + "name", (Object)object22.getName());
                                                fileConfiguration.set(string4 + "amount", (Object)object22.getAmount());
                                                fileConfiguration.set(string4 + "operation", (Object)object22.getOperation().name());
                                                fileConfiguration.set(string4 + "slot", (Object)object22.getSlot().name());
                                            }
                                        }
                                        if (!(itemMeta instanceof EnchantmentStorageMeta)) break block24;
                                        object = (EnchantmentStorageMeta)itemMeta;
                                        for (Map.Entry entry : object.getStoredEnchants().entrySet()) {
                                            object22 = string + ".stored-enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
                                            fileConfiguration.set((String)object22, entry.getValue());
                                        }
                                        break block25;
                                    }
                                    if (!(itemMeta instanceof SkullMeta)) break block26;
                                    object = SkullUtils.getSkinValue(itemStack);
                                    if (object != null) break block27;
                                    if (!((SkullMeta)itemMeta).hasOwner()) break block25;
                                    if (XMaterial.supports(12)) {
                                        fileConfiguration.set(string + ".skull", (Object)((SkullMeta)itemMeta).getOwningPlayer().getUniqueId().toString());
                                    } else {
                                        fileConfiguration.set(string + ".skull", (Object)((SkullMeta)itemMeta).getOwner());
                                    }
                                    break block25;
                                }
                                fileConfiguration.set(string + ".skull", object);
                                break block25;
                            }
                            if (!(itemMeta instanceof BannerMeta)) break block28;
                            object = (BannerMeta)itemMeta;
                            ConfigurationSection configurationSection = fileConfiguration.createSection(string + ".patterns");
                            for (Object object22 : object.getPatterns()) {
                                configurationSection.set(object22.getPattern().name(), (Object)object22.getColor().name());
                            }
                            break block25;
                        }
                        if (!(itemMeta instanceof LeatherArmorMeta)) break block29;
                        object = (LeatherArmorMeta)itemMeta;
                        Color color = object.getColor();
                        fileConfiguration.set(string + ".color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
                        break block25;
                    }
                    if (!(itemMeta instanceof PotionMeta)) break block30;
                    if (!XMaterial.supports(9)) break block31;
                    object = (PotionMeta)itemMeta;
                    List list = object.getCustomEffects();
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    for (PotionEffect potionEffect : list) {
                        arrayList.add(potionEffect.getType().getName() + ", " + potionEffect.getDuration() + ", " + potionEffect.getAmplifier());
                    }
                    fileConfiguration.set(string + "custom-effects", arrayList);
                    object22 = object.getBasePotionData();
                    fileConfiguration.set(string + "base-effect", (Object)(object22.getType().name() + ", " + object22.isExtended() + ", " + object22.isUpgraded()));
                    if (!object.hasColor()) break block25;
                    fileConfiguration.set(string + "color", (Object)object.getColor().asRGB());
                    break block25;
                }
                if (itemStack.getDurability() == 0) break block25;
                object = Potion.fromItemStack((ItemStack)itemStack);
                fileConfiguration.set("level", (Object)object.getLevel());
                fileConfiguration.set("base-effect", (Object)(object.getType().name() + ", " + object.hasExtendedDuration() + ", " + object.isSplash()));
                break block25;
            }
            if (itemMeta instanceof FireworkMeta) {
                object = (FireworkMeta)itemMeta;
                fileConfiguration.set(string + ".power", (Object)object.getPower());
                boolean bl = false;
                for (Object object22 : object.getEffects()) {
                    void var5_17;
                    fileConfiguration.set(string + ".firework." + (int)var5_17 + ".type", (Object)object22.getType().name());
                    ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection(string + ".firework." + (int)var5_17);
                    configurationSection.set("flicker", (Object)object22.hasFlicker());
                    configurationSection.set("trail", (Object)object22.hasTrail());
                    List list = object22.getColors();
                    List list2 = object22.getFadeColors();
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    ArrayList<String> arrayList2 = new ArrayList<String>(list2.size());
                    for (Color color : list) {
                        arrayList.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                    }
                    configurationSection.set("base-colors", arrayList);
                    for (Color color : list2) {
                        arrayList2.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                    }
                    configurationSection.set("fade-colors", arrayList2);
                    ++var5_17;
                }
            }
        }
    }

    public static ItemStack deserializeItem(FileConfiguration fileConfiguration, String string) {
        List list;
        int n;
        Object object;
        Object object222;
        Object object322;
        Object object4;
        int n2;
        Objects.requireNonNull(fileConfiguration, "Cannot deserialize item to a null configuration section.");
        String string3 = fileConfiguration.getString(string + ".material");
        if (string3 == null) {
            return null;
        }
        Optional<XMaterial> optional = XMaterial.matchXMaterial(string3);
        if (!optional.isPresent()) {
            return null;
        }
        ItemStack itemStack = optional.get().parseItem();
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n3 = fileConfiguration.getInt(string + ".amount");
        if (n3 > 1) {
            itemStack.setAmount(n3);
        }
        if (XMaterial.isNewVersion()) {
            if (itemMeta instanceof Damageable && (n2 = fileConfiguration.getInt(string + ".damage")) > 0) {
                ((Damageable)itemMeta).setDamage(n2);
            }
        } else {
            n2 = fileConfiguration.getInt(string + ".damage");
            if (n2 > 0) {
                itemStack.setDurability((short)n2);
            }
        }
        if (optional.get() == XMaterial.PLAYER_HEAD) {
            String string4 = fileConfiguration.getString(string + ".skull");
            if (string4 != null) {
                SkullUtils.applySkin(itemMeta, string4);
            }
        } else if (itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)itemMeta;
            object4 = fileConfiguration.getConfigurationSection(string + ".patterns");
            if (object4 != null) {
                for (Object object322 : object4.getKeys(false)) {
                    PatternType patternType = PatternType.getByIdentifier((String)object322);
                    if (patternType == null) {
                        patternType = (PatternType)Enums.getIfPresent(PatternType.class, (String)((String)object322).toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                    }
                    DyeColor dyeColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)object4.getString((String)object322).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    bannerMeta.addPattern(new Pattern(dyeColor, patternType));
                }
            }
        } else if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            object4 = fileConfiguration.getString(string + ".color");
            if (object4 != null) {
                leatherArmorMeta.setColor(XItemStack.parseColor((String)object4));
            }
        } else if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            for (Object object222 : fileConfiguration.getStringList(string + ".effects")) {
                object322 = XPotion.parseEffect((String)object222);
                if (!((XPotion.Effect)object322).hasChance()) continue;
                potionMeta.addCustomEffect(((XPotion.Effect)object322).getEffect(), true);
            }
            object4 = fileConfiguration.getString(string + ".base-effect");
            if (!Strings.isNullOrEmpty((String)object4)) {
                object222 = StringUtils.split((String)object4, (char)',');
                object322 = (PotionType)Enums.getIfPresent(PotionType.class, (String)object222[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.UNCRAFTABLE);
                boolean bl = ((FireworkEffect.Builder)object222).length != 1 && Boolean.parseBoolean(object222[1].trim());
                boolean bl2 = ((FireworkEffect.Builder)object222).length > 2 && Boolean.parseBoolean(((String)object222[2]).trim());
                object = new PotionData((PotionType)object322, bl, bl2);
                potionMeta.setBasePotionData((PotionData)object);
            }
            if (fileConfiguration.contains(string + ".color")) {
                potionMeta.setColor(Color.fromRGB((int)fileConfiguration.getInt(string + ".color")));
            }
        } else if (itemMeta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            object4 = blockStateMeta.getBlockState();
            if (object4 instanceof CreatureSpawner) {
                object222 = (CreatureSpawner)object4;
                object222.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)fileConfiguration.getString(string + ".spawner").toUpperCase(Locale.ENGLISH)).orNull());
                blockStateMeta.setBlockState((BlockState)object222);
            }
        } else if (itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            fireworkMeta.setPower(fileConfiguration.getInt(string + ".power"));
            object4 = fileConfiguration.getConfigurationSection(string + ".firework");
            if (object4 != null) {
                object222 = FireworkEffect.builder();
                object322 = object4.getKeys(false).iterator();
                while (object322.hasNext()) {
                    String string5 = (String)object322.next();
                    ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("firework." + string5);
                    object222.flicker(configurationSection.getBoolean("flicker"));
                    object222.trail(configurationSection.getBoolean("trail"));
                    object222.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)configurationSection.getString("type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                    object = new ArrayList();
                    for (String string2 : configurationSection.getStringList("colors")) {
                        object.add(XItemStack.parseColor(string2));
                    }
                    object222.withColor((Iterable)object);
                    object.clear();
                    for (String string2 : configurationSection.getStringList("fade-colors")) {
                        object.add(XItemStack.parseColor(string2));
                    }
                    object222.withFade((Iterable)object);
                    fireworkMeta.addEffect(object222.build());
                }
            }
        }
        String string6 = fileConfiguration.getString(string + ".name");
        if (!Strings.isNullOrEmpty((String)string6)) {
            object4 = ChatColor.translateAlternateColorCodes((char)'&', (String)string6);
            itemMeta.setDisplayName((String)object4);
        }
        if (XMaterial.supports(11) && fileConfiguration.contains(string + ".unbreakable")) {
            itemMeta.setUnbreakable(fileConfiguration.getBoolean(string + ".unbreakable", false));
        }
        if (XMaterial.supports(14) && (n = fileConfiguration.getInt(string + ".model-data")) != 0) {
            itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        if (!(list = fileConfiguration.getStringList(string + ".lore")).isEmpty()) {
            object222 = new ArrayList();
            object322 = list.iterator();
            while (object322.hasNext()) {
                String string7 = (String)object322.next();
                if (string7.isEmpty()) {
                    object222.add(" ");
                    continue;
                }
                for (String string2 : StringUtils.splitPreserveAllTokens((String)string7, (char)'\n')) {
                    if (string2.isEmpty()) {
                        object222.add(" ");
                        continue;
                    }
                    string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
                    object222.add(string2);
                }
            }
            itemMeta.setLore((List)object222);
        } else {
            object222 = fileConfiguration.getString(string + ".lore");
            if (!Strings.isNullOrEmpty((String)object222)) {
                object322 = new ArrayList();
                for (String itemFlag : StringUtils.splitPreserveAllTokens((String)object222, (char)'\n')) {
                    if (itemFlag.isEmpty()) {
                        object322.add(" ");
                        continue;
                    }
                    String string10 = ChatColor.translateAlternateColorCodes((char)'&', (String)itemFlag);
                    object322.add(string10);
                }
                itemMeta.setLore((List)object322);
            }
        }
        object222 = fileConfiguration.getConfigurationSection(string + ".enchants");
        if (object222 != null) {
            object322 = object222.getKeys(false).iterator();
            while (object322.hasNext()) {
                String string8 = (String)object322.next();
                Optional<XEnchantment> optional2 = XEnchantment.matchXEnchantment(string8);
                optional2.ifPresent(arg_0 -> XItemStack.lambda$deserializeItem$0(itemMeta, (ConfigurationSection)object222, string8, arg_0));
            }
        }
        if ((object322 = fileConfiguration.getConfigurationSection(string + ".stored-enchants")) != null) {
            for (String string9 : object322.getKeys(false)) {
                object = XEnchantment.matchXEnchantment(string9);
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
                ((Optional)object).ifPresent(arg_0 -> XItemStack.lambda$deserializeItem$1(enchantmentStorageMeta, (ConfigurationSection)object322, string9, arg_0));
            }
        }
        List list2 = fileConfiguration.getStringList(string + ".flags");
        ConfigurationSection configurationSection = list2.iterator();
        while (configurationSection.hasNext()) {
            object = (String)configurationSection.next();
            if (((String)(object = ((String)object).toUpperCase(Locale.ENGLISH))).equals("ALL")) {
                itemMeta.addItemFlags(ItemFlag.values());
                break;
            }
            ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)object).orNull();
            if (itemFlag == null) continue;
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (XMaterial.supports(14) && (configurationSection = fileConfiguration.getConfigurationSection(string + ".attributes")) != null) {
            for (String string4 : configurationSection.getKeys(false)) {
                String string2;
                string2 = (Attribute)Enums.getIfPresent(Attribute.class, (String)string4.toUpperCase(Locale.ENGLISH)).orNull();
                if (string2 == null) continue;
                String string5 = configurationSection.getString("id");
                UUID uUID = string5 != null ? UUID.fromString(string5) : UUID.randomUUID();
                AttributeModifier attributeModifier = new AttributeModifier(uUID, configurationSection.getString("name"), (double)configurationSection.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)configurationSection.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)configurationSection.getString("slot")).or((Object)EquipmentSlot.HAND));
                itemMeta.addAttributeModifier((Attribute)string2, attributeModifier);
            }
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static Color parseColor(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return Color.BLACK;
        }
        String[] stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',');
        if (stringArray.length < 3) {
            return Color.WHITE;
        }
        return Color.fromRGB((int)NumberUtils.toInt((String)stringArray[0], (int)0), (int)NumberUtils.toInt((String)stringArray[1], (int)0), (int)NumberUtils.toInt((String)stringArray[2], (int)0));
    }

    public static String itemStackToBase64(ItemStack itemStack) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)byteArrayOutputStream);
            bukkitObjectOutputStream.writeObject((Object)itemStack);
            bukkitObjectOutputStream.close();
            return Base64Coder.encodeLines((byte[])byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to save item stacks.", exception);
        }
    }

    public static ItemStack itemStackFromBase64(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)string));
            BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)byteArrayInputStream);
            ItemStack itemStack = (ItemStack)bukkitObjectInputStream.readObject();
            bukkitObjectInputStream.close();
            return itemStack;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new IOException("Unable to decode class type.", exception);
        }
    }

    private static /* synthetic */ void lambda$deserializeItem$1(EnchantmentStorageMeta enchantmentStorageMeta, ConfigurationSection configurationSection, String string, XEnchantment xEnchantment) {
        enchantmentStorageMeta.addStoredEnchant(xEnchantment.getEnchant(), configurationSection.getInt(string), true);
    }

    private static /* synthetic */ void lambda$deserializeItem$0(ItemMeta itemMeta, ConfigurationSection configurationSection, String string, XEnchantment xEnchantment) {
        itemMeta.addEnchant(xEnchantment.getEnchant(), configurationSection.getInt(string), true);
    }
}

