/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import javax.annotation.Nullable;
import org.jsoup.helper.ValidationException;

public final class Validate {
    private Validate() {
    }

    public static void notNull(@Nullable Object object) {
        if (object == null) {
            throw new ValidationException("Object must not be null");
        }
    }

    public static void notNullParam(@Nullable Object object, String string) {
        if (object == null) {
            throw new ValidationException(String.format("The parameter '%s' must not be null.", string));
        }
    }

    public static void notNull(@Nullable Object object, String string) {
        if (object == null) {
            throw new ValidationException(string);
        }
    }

    public static Object ensureNotNull(@Nullable Object object) {
        if (object == null) {
            throw new ValidationException("Object must not be null");
        }
        return object;
    }

    public static Object ensureNotNull(@Nullable Object object, String string, Object ... objectArray) {
        if (object == null) {
            throw new ValidationException(String.format(string, objectArray));
        }
        return object;
    }

    public static void isTrue(boolean bl) {
        if (!bl) {
            throw new ValidationException("Must be true");
        }
    }

    public static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new ValidationException(string);
        }
    }

    public static void isFalse(boolean bl) {
        if (bl) {
            throw new ValidationException("Must be false");
        }
    }

    public static void isFalse(boolean bl, String string) {
        if (bl) {
            throw new ValidationException(string);
        }
    }

    public static void noNullElements(Object[] objectArray) {
        Validate.noNullElements(objectArray, "Array must not contain any null objects");
    }

    public static void noNullElements(Object[] objectArray, String string) {
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new ValidationException(string);
        }
    }

    public static void notEmpty(@Nullable String string) {
        if (string == null || string.length() == 0) {
            throw new ValidationException("String must not be empty");
        }
    }

    public static void notEmptyParam(@Nullable String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new ValidationException(String.format("The '%s' parameter must not be empty.", string2));
        }
    }

    public static void notEmpty(@Nullable String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new ValidationException(string2);
        }
    }

    public static void wtf(String string) {
        throw new IllegalStateException(string);
    }

    public static void fail(String string) {
        throw new ValidationException(string);
    }
}

