/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3CDom {
    public static final String SourceProperty = "jsoupSource";
    private static final String ContextProperty = "jsoupContextSource";
    private static final String ContextNodeProperty = "jsoupContextNode";
    public static final String XPathFactoryProperty = "javax.xml.xpath.XPathFactory:jsoup";
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private boolean namespaceAware = true;

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public boolean namespaceAware() {
        return this.namespaceAware;
    }

    public W3CDom namespaceAware(boolean bl) {
        this.namespaceAware = bl;
        this.factory.setNamespaceAware(bl);
        return this;
    }

    public static org.w3c.dom.Document convert(Document document) {
        return new W3CDom().fromJsoup(document);
    }

    public static String asString(org.w3c.dom.Document document, @Nullable Map<String, String> map) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (map != null) {
                transformer.setOutputProperties(W3CDom.propertiesFromMap(map));
            }
            if (document.getDoctype() != null) {
                DocumentType documentType = document.getDoctype();
                if (!StringUtil.isBlank(documentType.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", documentType.getPublicId());
                }
                if (!StringUtil.isBlank(documentType.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", documentType.getSystemId());
                } else if (documentType.getName().equalsIgnoreCase("html") && StringUtil.isBlank(documentType.getPublicId()) && StringUtil.isBlank(documentType.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    static Properties propertiesFromMap(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    private static HashMap<String, String> methodMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("method", string);
        return hashMap;
    }

    public org.w3c.dom.Document fromJsoup(Document document) {
        return this.fromJsoup((org.jsoup.nodes.Element)document);
    }

    public org.w3c.dom.Document fromJsoup(org.jsoup.nodes.Element element) {
        Validate.notNull(element);
        try {
            Object object;
            org.jsoup.nodes.DocumentType documentType;
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            org.w3c.dom.Document document = documentBuilder.newDocument();
            Document document2 = element.ownerDocument();
            org.jsoup.nodes.DocumentType documentType2 = documentType = document2 != null ? document2.documentType() : null;
            if (documentType != null) {
                object = dOMImplementation.createDocumentType(documentType.name(), documentType.publicId(), documentType.systemId());
                document.appendChild((org.w3c.dom.Node)object);
            }
            document.setXmlStandalone(true);
            object = element instanceof Document ? element.child(0) : element;
            document.setUserData(ContextProperty, object, null);
            this.convert(document2 != null ? document2 : element, document);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    public void convert(Document document, org.w3c.dom.Document document2) {
        this.convert((org.jsoup.nodes.Element)document, document2);
    }

    public void convert(org.jsoup.nodes.Element element, org.w3c.dom.Document document) {
        W3CBuilder w3CBuilder = new W3CBuilder(document);
        w3CBuilder.namespaceAware = this.namespaceAware;
        Document document2 = element.ownerDocument();
        if (document2 != null) {
            if (!StringUtil.isBlank(document2.location())) {
                document.setDocumentURI(document2.location());
            }
            w3CBuilder.syntax = document2.outputSettings().syntax();
        }
        org.jsoup.nodes.Element element2 = element instanceof Document ? element.child(0) : element;
        NodeTraversor.traverse((NodeVisitor)w3CBuilder, element2);
    }

    public NodeList selectXpath(String string, org.w3c.dom.Document document) {
        return this.selectXpath(string, (org.w3c.dom.Node)document);
    }

    public NodeList selectXpath(String string, org.w3c.dom.Node node) {
        NodeList nodeList;
        Validate.notEmptyParam(string, "xpath");
        Validate.notNullParam(node, "contextNode");
        try {
            String string2 = System.getProperty(XPathFactoryProperty);
            XPathFactory xPathFactory = string2 != null ? XPathFactory.newInstance("jsoup") : XPathFactory.newInstance();
            XPathExpression xPathExpression = xPathFactory.newXPath().compile(string);
            nodeList = (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
            Validate.notNull(nodeList);
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xPathException) {
            throw new Selector.SelectorParseException("Could not evaluate XPath query [%s]: %s", string, xPathException.getMessage());
        }
        return nodeList;
    }

    public <T extends Node> List<T> sourceNodes(NodeList nodeList, Class<T> clazz) {
        Validate.notNull(nodeList);
        Validate.notNull(clazz);
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            Object object = node.getUserData(SourceProperty);
            if (!clazz.isInstance(object)) continue;
            arrayList.add((Node)clazz.cast(object));
        }
        return arrayList;
    }

    public org.w3c.dom.Node contextNode(org.w3c.dom.Document document) {
        return (org.w3c.dom.Node)document.getUserData(ContextNodeProperty);
    }

    public String asString(org.w3c.dom.Document document) {
        return W3CDom.asString(document, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private boolean namespaceAware = true;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private org.w3c.dom.Node dest;
        private Document.OutputSettings.Syntax syntax = Document.OutputSettings.Syntax.xml;
        @Nullable
        private final org.jsoup.nodes.Element contextElement;

        public W3CBuilder(org.w3c.dom.Document document) {
            this.doc = document;
            this.namespacesStack.push(new HashMap());
            this.dest = document;
            this.contextElement = (org.jsoup.nodes.Element)document.getUserData(W3CDom.ContextProperty);
        }

        @Override
        public void head(Node node, int n) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (node instanceof org.jsoup.nodes.Element) {
                org.jsoup.nodes.Element element = (org.jsoup.nodes.Element)node;
                String string = this.updateNamespaces(element);
                String string2 = this.namespaceAware ? this.namespacesStack.peek().get(string) : null;
                String string3 = element.tagName();
                try {
                    Element element2 = string2 == null && string3.contains(":") ? this.doc.createElementNS("", string3) : this.doc.createElementNS(string2, string3);
                    this.copyAttributes(element, element2);
                    this.append(element2, element);
                    if (element == this.contextElement) {
                        this.doc.setUserData(W3CDom.ContextNodeProperty, element2, null);
                    }
                    this.dest = element2;
                }
                catch (DOMException dOMException) {
                    this.append(this.doc.createTextNode("<" + string3 + ">"), element);
                }
            } else if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Text text = this.doc.createTextNode(textNode.getWholeText());
                this.append(text, textNode);
            } else if (node instanceof org.jsoup.nodes.Comment) {
                org.jsoup.nodes.Comment comment = (org.jsoup.nodes.Comment)node;
                Comment comment2 = this.doc.createComment(comment.getData());
                this.append(comment2, comment);
            } else if (node instanceof DataNode) {
                DataNode dataNode = (DataNode)node;
                Text text = this.doc.createTextNode(dataNode.getWholeData());
                this.append(text, dataNode);
            }
        }

        private void append(org.w3c.dom.Node node, Node node2) {
            node.setUserData(W3CDom.SourceProperty, node2, null);
            this.dest.appendChild(node);
        }

        @Override
        public void tail(Node node, int n) {
            if (node instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node node, Element element) {
            for (Attribute attribute : node.attributes()) {
                String string = Attribute.getValidKey(attribute.getKey(), this.syntax);
                if (string == null) continue;
                element.setAttribute(string, attribute.getValue());
            }
        }

        private String updateNamespaces(org.jsoup.nodes.Element element) {
            Attributes attributes = element.attributes();
            for (Attribute attribute : attributes) {
                String string;
                String string2 = attribute.getKey();
                if (string2.equals(xmlnsKey)) {
                    string = "";
                } else {
                    if (!string2.startsWith(xmlnsPrefix)) continue;
                    string = string2.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(string, attribute.getValue());
            }
            int n = element.tagName().indexOf(58);
            return n > 0 ? element.tagName().substring(0, n) : "";
        }
    }
}

