/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;

public class TextNode
extends LeafNode {
    public TextNode(String string) {
        this.value = string;
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String string) {
        this.coreValue(string);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    public TextNode splitText(int n) {
        String string = this.coreValue();
        Validate.isTrue(n >= 0, "Split offset must be not be negative");
        Validate.isTrue(n < string.length(), "Split offset must not be greater than current text length");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        this.text(string2);
        TextNode textNode = new TextNode(string3);
        if (this.parentNode != null) {
            this.parentNode.addChildren(this.siblingIndex() + 1, textNode);
        }
        return textNode;
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        boolean bl = outputSettings.prettyPrint();
        Element element = this.parentNode instanceof Element ? (Element)this.parentNode : null;
        boolean bl2 = bl && !Element.preserveWhitespace(this.parentNode);
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl2) {
            boolean bl5;
            bl3 = this.siblingIndex == 0 && element != null && element.tag().isBlock() || this.parentNode instanceof Document;
            bl4 = this.nextSibling() == null && element != null && element.tag().isBlock();
            Node node = this.nextSibling();
            boolean bl6 = bl5 = node instanceof Element && ((Element)node).shouldIndent(outputSettings) || node instanceof TextNode && ((TextNode)node).isBlank();
            if (bl5 && this.isBlank()) {
                return;
            }
            if (this.siblingIndex == 0 && element != null && element.tag().formatAsBlock() && !this.isBlank() || outputSettings.outline() && this.siblingNodes().size() > 0 && !this.isBlank()) {
                this.indent(appendable, n, outputSettings);
            }
        }
        Entities.escape(appendable, this.coreValue(), outputSettings, false, bl2, bl3, bl4);
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    public static TextNode createFromEncoded(String string) {
        String string2 = Entities.unescape(string);
        return new TextNode(string2);
    }

    static String normaliseWhitespace(String string) {
        string = StringUtil.normaliseWhitespace(string);
        return string;
    }

    static String stripLeadingWhitespace(String string) {
        return string.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder stringBuilder) {
        return stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ';
    }
}

